function Script(n, t, i) {
    var r = new BaseItem(n, t);
    return r.objType = "script", r.icon = IMG_SCRIPT, r.db = "", r.getContextMenuItems = function() {
        return [{
            label: "Run Script",
            icon: IMG_SCRIPT_RUN,
            action: r.run,
            auto: 1
        }, null, {
            label: "Delete",
            icon: IMG_DELETE,
            action: function() {
                n.delScript(r)
            }
        }]
    }, r.run = function() {
        var n = new Dialog,
            t, u;
        n.show('<div style="font-weight:bold;color:red;height:30px">' + RES.script_run_warn + '<\/div><table cellpadding="5"><tr><td>File Encoding<\/td><td id="phExecEnc" style="vertical-align:top"><\/td><\/tr><tr><td>Default Database<\/td><td id="phExecDefDB"><\/td><\/tr><\/table>', [{
            label: "Continue",
            img: IMG_ACCEPT,
            action: function() {
                function o() {
                    clearTimeout(e), n.close()
                }

                function s() {
                    r.sendReq("data.php", f, function(i) {
                        if (t += i.count, i.done) n.close(), Alert("Successfully executed " + t + " statement" + (t > 1 ? "s" : "")), r.getHost().reloadDBs();
                        else {
                            var u = $$("phExecReport");
                            u && (u.innerHTML = "Working... Executed " + t + " statement" + (t > 1 ? "s" : "") + " so far." + (i.db ? "<br />Default database: " + i.db : ""), f.offset = i.offset, f.db = i.db, e = setTimeout(s, 500))
                        }
                    }, function(n) {
                        return o(), Alert(n, "Error", 0, 0, null, null, !1, null, !1, !0), !0
                    }, 0, !1, !0)
                }
                var f = {
                        action: "plugin",
                        plugin: "exec",
                        cid: r.getHost().cid,
                        file: i,
                        db: r.db,
                        file_encoding: u.selectedLabel,
                        offset: 0,
                        step: 25
                    },
                    t = 0,
                    e;
                n.close(), n = new Alert('<div id="phExecReport" style="line-height:30px">Working...<\/div>', "Executing Script", 0, 0, o, "Abort", !1, null, !1, !0), s()
            }
        }, {
            label: "Cancel",
            img: IMG_CANCEL,
            action: n.close,
            onEscape: 1,
            selected: 1
        }], "Run Script"), t = {
            label: "-- Unspecified --"
        }, cmbDBs = new Combo($$("phExecDefDB"), function() {
            return [t].concat(r.getHost().children.map(function(n) {
                if (n.objType == "database") return n
            }))
        }, 200, r.db ? r.getHost().getChildByName(r.db) || t : t, function(n) {
            r.db = n.name || ""
        }), u = CreateEncodingsCombo("phExecEnc"), n._addToDeathList([cmbDBs, u])
    }, r
}

function ScriptGroup(n, t) {
    var i = new BaseItem(n, t);
    return i.icon = IMG_SCRIPT_SAVE, i.children = [], i._hidden = !0, i.getContextMenuItems = function() {
        return [{
            label: "Upload New Script",
            icon: IMG_SCRIPT_ADD
        }, null, {
            label: "Delete All",
            icon: IMG_DELETE,
            disabled: !i.children.length
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "upload new script":
                i.getHost().uploadScript();
                break;
            case "delete all":
                YesNoDialog("Delete all scripts?", function() {
                    i.children.map(function(n) {
                        n.destroy()
                    }), i.children.length = 0, i._hidden = !0, i.dispatchChange()
                })
        }
    }, i.addScript = function(n) {
        i.children.push(n), i._hidden = !1, i.dispatchChange()
    }, i.delScript = function(n) {
        YesNoDialog("Delete this script?", function() {
            n.destroy(), i.children.removeAll(n), i._hidden = !i.children.length, i.dispatchChange()
        })
    }, i
}

function FavouriteQuery(n, t, i, r) {
    function f() {
        return u.defDB ? u.getHost().getChildByName(u.defDB) : null
    }
    var u = new BaseItem(n, t);
    return u.query = u.tooltip = i, u.defDB = r, u.objType = "query", u.icon = IMG_QUERY, u.getContextMenuItems = function() {
        function t() {
            var n = OpenWindow(FillerQuery, u.getHost(), u.query, !0),
                t = f();
            return t && n.setDefaultDB(t), n
        }
        return [{
            label: "Open in Query Editor",
            action: t,
            auto: 1,
            icon: IMG_QUERY
        }, {
            label: "Run in Query Editor",
            action: function() {
                t().refresh()
            },
            icon: IMG_QUERY_RUN
        }, null, {
            label: "Export Data",
            icon: IMG_EXPORT,
            action: function() {
                new PopupExportData(f() || u.getHost(), u.query)
            }
        }, null, {
            label: "Copy to Clipboard",
            action: function() {
                SetClipboard(u.query)
            },
            icon: IMG_COPY
        }, null, {
            label: "Edit",
            action: function() {
                n.editQuery(u)
            },
            icon: IMG_PENCIL
        }, null, {
            label: "Delete",
            action: function() {
                n.delQuery(u)
            },
            icon: IMG_DELETE
        }]
    }, u
}

function FavouritesGroup(n, t) {
    var i = new BaseItem(n, t);
    return i.icon = IMG_FAVOURITES, i.children = [], i.getContextMenuItems = function() {
        return [{
            label: "Add Query",
            action: function() {
                i.editQuery()
            },
            icon: IMG_FAVOURITES_ADD
        }]
    }, i.delQuery = function(n) {
        YesNoDialog("Delete this query?", function() {
            n.destroy(), i.children.removeAll(n), i.dispatchChange(), i.save()
        })
    }, i.editQuery = function(n) {
        var e, t, u, r = new Dialog,
            f;
        r.show('<table cellpadding="5" style="width:579px;height:215px"><tr><td style="width:37px">Label<\/td><td style="width:220px"><input id="favTitle" type="text" style="width:200px"/><\/td><td style="width:60px">Default DB<\/td><td id="phDefDB" style="height:40px"><\/td><\/tr><tr><td style="vertical-align:top">Query<\/td><td colspan="3"><\/td><\/tr><\/table><div id="phFavQuery" data-sticky="76,5,95," style="height:163px"><\/div>', [{
            label: "Save",
            img: IMG_ACCEPT,
            action: function() {
                clearInterval(e), n && n.destroy();
                var f = !n || n.temp ? i.children.length : i.children.indexOf(n);
                n = new FavouriteQuery(i, $$("favTitle").value, t.getValue(), u.selectedIndex == 0 ? "" : u.selectedItem.name), r.close(), i.children[f] = n, i.children[f].dispatchChange(), i.save()
            }
        }, {
            label: "Cancel",
            action: function() {
                n && n.temp && n.destroy(), clearInterval(e), r.close()
            },
            img: IMG_CANCEL,
            onEscape: 1
        }], "Add Favorite Query", 700, 600), f = {
            label: "-- No Default --"
        }, u = new Combo($$("phDefDB"), function() {
            return [f].concat(i.getHost().children.map(function(n) {
                if (n.objType == "database") return n
            }))
        }, 220, n && n.defDB ? i.getHost().getChildByName(n.defDB) || f : f), t = new CodeEditor($$("phFavQuery"), {
            noHelp: 1,
            extraKeys: {
                Tab: !1,
                "Shift-Tab": !1
            }
        }), ValidateLayout(r.elem), n === undefined || n.temp ? (t.fill(n ? n.query : ""), $$("favTitle").focus()) : (t.fill(n.query), $$("favTitle").value = n.name, t.focus()), r._addToDeathList([u, t]), r.center(), e = setInterval(function() {
            DisableElem(r.getButtonElem(0), !$$("favTitle").value.trim() || !t.getValue().trim())
        }, 100)
    }, i.update = function(n) {
        n.map(function(n) {
            i.children.push(new FavouriteQuery(i, n.name, n.query, n.defDB))
        })
    }, i.cloneChildren = function() {
        return i.children.clone(["name", "defDB", "query"])
    }, i.save = function(n) {
        APP.save(null, null, n)
    }, i
}

function Event(n, t) {
    var i = new BaseItem(n, t || GetNewName("new_event_", n.children));
    return i.objType = "event", i.icon = IMG_EVENT, i.recurring = !1, i.definer = "CURRENT_USER", i.code = "BEGIN\n\nEND", i.executeAt = "CURRENT_TIMESTAMP", i.intervalValue = 1, i.intervalField = "DAY", i.starts = "", i.ends = "", i.state = "ENABLED", i.preserve = !1, i.comment = "", i.selRdo = 1, i.getContextMenuItems = function() {
        return i.temp ? [{
            label: RES.obj_doesnt_exist,
            disabled: !0
        }] : [{
            label: "Edit",
            auto: 1,
            icon: IMG_EVENT_EDIT
        }, null, {
            label: "Drop",
            icon: IMG_EVENT_DELETE
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "edit":
                OpenWindow(FillerEvent, i);
                break;
            case "drop":
                i.getDB().drop(i)
        }
    }, i.load = function(n) {
        i.sendQuery('SELECT definer,event_definition,event_type,execute_at,interval_value,interval_field,starts,ends,status,on_completion,event_comment FROM information_schema.events WHERE event_schema="' + i.getDB().name + '" and event_name="' + i.name + '"', function(t) {
            var r = t.data[0];
            i.definer = r[0], i.code = r[1].replace(/\r/g, ""), i.recurring = r[2] == "RECURRING", i.executeAt = r[3] || "", i.intervalValue = r[4] || 1, i.intervalField = r[5] || "DAY", i.starts = r[6] || "", i.ends = r[7] || "", i.state = r[8].indexOf("SLAVE") > -1 ? "DISABLED ON SLAVE" : r[8], i.preserve = r[9] == "PRESERVE", i.comment = r[10] || "", i.selRdo = i.executeAt ? 1 : 2, n && n()
        })
    }, i.save = function(n) {
        var t = (i.temp ? "CREATE" : "ALTER") + " DEFINER=" + i.formatDefiner() + " EVENT `" + (i.temp ? i.name : i.prevValue("name")) + "`\nON SCHEDULE ";
        i.selRdo == 1 ? t += "AT " + (i.executeAt.toLowerCase() == "current_timestamp" ? i.executeAt : "'" + i.executeAt + "'") + "\n" : (t += "EVERY " + i.intervalValue + " " + i.intervalField + "\n", i.starts && (t += "STARTS " + (i.starts.toLowerCase() == "current_timestamp" ? i.starts : "'" + i.starts + "'") + "\n"), i.ends && (t += "ENDS " + (i.ends.toLowerCase() == "current_timestamp" ? i.ends : "'" + i.ends + "'") + "\n")), t += "ON COMPLETION " + (i.preserve ? "" : "NOT ") + "PRESERVE\n", !i.temp && i.propChanged("name") && (t += "RENAME TO `" + i.name + "`\n"), t += (i.state == "ENABLED" ? "ENABLE" : i.state == "DISABLED" ? "DISABLE" : "DISABLE ON SLAVE") + "\n", (i.temp || i.propChanged("code")) && (t += "DO\n" + i.code), i.sendQuery(t, function() {
            i.temp = !1, i.confirmChanges(), i.dispatchChange(), n && n()
        })
    }, i.watchChanges(), i
}

function QueryResult(n) {
    var t = this;
    this.results = n.results, this.lastInsertId = n.lastInsertId, this.affectedRows = n.affectedRows, this.resultCount = n.results.length, this.execTime = n.execTime || 0, this.pageSize = n.pageSize, this.outFile = n.outFile || null, this.warning = n.warning || null, n.results.map(function(n) {
        var t = null;
        n.fields.map(function(n, i) {
            n.db ? t = n.db : t && n.table && (n.table = n.tableAlias = null), n.index = i, n.notNull = !!(n.flags & FIELD_FLAGS.NOT_NULL), n.flags & FIELD_FLAGS.AUTO_INCREMENT && (n.autoInc = !0), n.flags & FIELD_FLAGS.PRI_KEY && (n.primaryKey = !0), n.flags & FIELD_FLAGS.UNIQUE_KEY && (n.uniqueKey = !0), n.flags & FIELD_FLAGS.MULTIPLE_KEY && (n.normalKey = !0), n.temporal = ["timestamp", "datetime", "date", "time", "year"].indexOf(n.type) != -1
        })
    }), this.selectResult = function(i, r) {
        this.autoIncField = null;
        var u = n.results[i];
        if (!u) {
            this.data = [], this.fields = [], this.fieldNames = [], this.resultIndex = -1, this.page = -1, this.pageCount = 0, this.rowCount = 0;
            return
        }
        this.resultIndex = i, this.data = u.data || [], this.fields = u.fields, this.fieldNames = this.fields.map(function(n) {
            return n.autoInc && (t.autoIncField = n), n.fieldAlias
        }), this.page = 0, this.pageCount = u.pageCount, this.rowCount = u.rowCount, n.outFile && r ? this.selectPage(0, r) : r && r()
    }, this.selectPage = function(i, r) {
        APP.sendReq("data.php", {
            action: "get_query_result",
            file: n.outFile,
            result: this.resultIndex,
            page: i
        }, function(n) {
            if (n.error) {
                Alert(n.error + "<br />Please try running the query again.");
                return
            }
            t.page = i, t.data = n, r && r()
        })
    }, this.getResult = function(t) {
        return n.results[t] ? n.results[t].data : []
    }, this.getUniqueKeyFields = function() {
        var n = this.fields.map(function(n) {
            if (n.primaryKey) return n
        });
        return n.length ? n : (n = this.fields.map(function(n) {
            if (n.uniqueKey) return n
        }), n.length) ? n : null
    }, this.getDataFromFields = function(n) {
        var i = n.map(function(n) {
                return t.fieldNames.indexOf(n)
            }),
            r = i.length;
        return this.data.map(function(n) {
            for (var u = [], t = 0; t < r; t++) u[t] = i[t] > -1 ? n[i[t]] : null;
            return u
        })
    }, this.selectResult(0)
}

function Column(n, t) {
    function r(n) {
        return i.type.search(new RegExp(n.join("|"), "i")) > -1
    }

    function e() {
        var n = i.type;
        i.isNumeric = r(["int", "float", "double", "decimal"]) && !r(["point"]), i.isTemporal = r(["time", "date", "year"]), i.withCharset = r(["char", "text", "enum", "set"]), i.withLength = i.isNumeric || r(["char", "binary", "bit"]), i.withLength2 = i.isNumeric && !r(["int"]), i.withValues = r(["enum", "set"]), i.withNoDefault = r(["text", "blob"])
    }

    function f() {
        i.len || i.isNumeric || !i.withLength || (i.len = i.type == "BIT" ? 1 : 50), i.lenOrValues = i.withLength2 ? i.len2 : i.withLength ? i.len : i.withValues ? i.values : null
    }

    function o(t, r) {
        if (u) {
            u = !1;
            return
        }
        switch (t) {
            case "charset":
                u = !0, i._set("collation", r ? n.getHost().getDefaultCollation(r) : "");
                break;
            case "collation":
                !i.charset && r && (u = !0, i._set("charset", n.getHost().getCharsetForCollation(r)));
                break;
            case "type":
                e(), f();
                break;
            case "lenOrValues":
                i.withLength2 ? i.len2 = r : i.withLength ? i.len = r : i.withValues && (i.values = r), f()
        }
    }
    var i = this,
        u;
    return t || (t = {
        name: GetNewName("new_column_", n.columns),
        type: "int"
    }, i.temp = !0), i.parent = n, i.name = i.label = t.name, i.type = t.type.toUpperCase(), e(), i.autoInc = !!t.autoInc, i.onUpdateTimestamp = !!t.onUpdateTimestamp, i.notNull = !!t.notNull, i.defValue = t.defValue, i.comment = t.comment || "", i.charset = i.collation = "", i.isNumeric ? (i.withLength2 ? i.len2 = t.len || "" : i.len = t.len || "", i.unsigned = t.unsigned || !1, i.zeroFill = t.zeroFill || !1) : (i.withCharset && (i.charset = t.charset || "", i.collation = t.collation || "", i.charset && !i.collation ? i.collation = n.getHost().getDefaultCollation(i.charset) : i.collation && !i.charset && (i.charset = n.getHost().getCharsetForCollation(i.collation))), i.withLength ? i.len = t.len || (i.type == "BIT" ? 1 : 50) : i.type == "SET" ? i.values = t.values || "'a','b','c'" : i.type == "ENUM" && (i.values = t.values || "'yes','no'")), f(), u = !1, i.getDataTypeDefinition = function(n) {
        var t = i.type;
        return i.lenOrValues && (t += "(" + i.lenOrValues + ")"), i.withCharset ? (i.charset && (t += " CHARACTER SET '" + i.charset + "'"), i.collation && !n && (t += " COLLATE '" + i.collation + "'")) : i.isNumeric && (i.unsigned && (t += " UNSIGNED"), i.zeroFill && (t += " ZEROFILL")), t
    }, i.getDefinition = function() {
        var t, r, u;
        if (i._deleted) return "DROP COLUMN `" + i.prevValue("name") + "`";
        if (t = [], !n.temp)
            if (i.temp) t.push("ADD COLUMN");
            else if (i._changed) t.push("CHANGE COLUMN `" + i.prevValue("name") + "`");
            else return;
        return t.push("`" + i.name + "` " + i.getDataTypeDefinition()), i.notNull ? t.push("NOT NULL") : i.defValue === null && i.type == "TIMESTAMP" && t.push("NULL"), i.defValue !== undefined && (i.defValue === null ? t.push("DEFAULT NULL") : (i.type == "TIMESTAMP" || i.type == "DATETIME") && i.defValue.toUpperCase() == "CURRENT_TIMESTAMP" ? t.push("DEFAULT CURRENT_TIMESTAMP") : i.withNoDefault || t.push("DEFAULT '" + i.defValue.SQLEscape() + "'")), (i.type == "TIMESTAMP" || i.type == "DATETIME") && i.onUpdateTimestamp && t.push("ON UPDATE CURRENT_TIMESTAMP"), i.isNumeric && i.autoInc && t.push("AUTO_INCREMENT"), i.comment && t.push("COMMENT '" + i.comment.SQLEscape() + "'"), !n.temp && (i.temp || i.propChanged("_index")) && (r = n.columns.map(function(n) {
            if (!n._deleted) return n
        }), u = r.indexOf(i), u == 0 ? t.push("FIRST") : t.push("AFTER `" + r[u - 1].name + "`")), t.join(" ")
    }, i.watchChanges(o), i
}

function Index(n, t) {
    return t || (t = {
        temp: !0,
        name: GetNewName("new_index_", n.indices),
        columns: [],
        type: "NORMAL",
        using: "DEFAULT"
    }), t.parent = n, t.updateColumnNames = function() {
        t._set("columnNames", t.columns.map(function(n) {
            return n.name + (n.prefixLen ? "(" + n.prefixLen + ")" : "")
        }).join("<br />"))
    }, t.getDropStmt = function() {
        var n = t.prevValue("type");
        return n == "PRIMARY" ? "DROP PRIMARY KEY" : "DROP KEY `" + t.prevValue("name") + "`"
    }, t.getDefinition = function() {
        if (t._deleted) return t.getDropStmt();
        if (t._changed) {
            var i = t.columns.map(function(n) {
                    return "`" + n.name + "`" + (n.prefixLen ? "(" + n.prefixLen + ")" : "")
                }),
                u = n.temp ? "" : t.temp ? "ADD " : t.getDropStmt() + ", ADD ",
                r = t.using != "DEFAULT" && t.type != "FULLTEXT" ? " USING " + t.using : "";
            return u + (t.type == "PRIMARY" ? "PRIMARY KEY (" + i.join(",") + ")" + r : (t.type == "NORMAL" ? "" : t.type + " ") + "KEY `" + t.name + "`" + r + " (" + i.join(",") + ")")
        }
    }, t.updateColumnNames(), t.watchChanges(), t
}

function FKey(n, t) {
    return t || (t = {
        temp: !0,
        name: "fkey_" + String.random(10),
        columns: [],
        refDB: null,
        refTable: null,
        refColumns: null,
        onDelete: "RESTRICT",
        onUpdate: "RESTRICT"
    }), t.refDB || (t.refDB = n.getDB().name), t.parent = n, t.allDBs = n.getHost().children.map(function(n) {
        if (n.objType == "database") return n
    }), t.allRefTables = null, t.columns.map(function(n, i) {
        t.columns[i] = {
            selected: !0,
            name: n
        }
    }), t.refColumns && t.refColumns.map(function(n, i) {
        t.refColumns[i] = {
            name: n,
            selected: !0
        }
    }), t.loadColumns = function(i) {
        n.columns.map(function(n) {
            t.columns.findByProp("name", n.name) == -1 && t.columns.push({
                name: n.name
            })
        }), i()
    }, t.loadRefTables = function(i) {
        n.getHost().getChildByName(t.refDB).getTableNames(function(n) {
            t.allRefTables = n.map(function(n) {
                return {
                    label: n
                }
            }), i()
        })
    }, t.loadRefColumns = function(i) {
        var r = n.getHost().getChildByName(t.refDB);
        r.getTableColumnNames("`" + r.name + "`.`" + t.refTable + "`", function(n) {
            t.refColumns || (t.refColumns = []), n.map(function(n) {
                t.refColumns.findByProp("name", n) == -1 && t.refColumns.push({
                    name: n
                })
            }), i()
        })
    }, t.updateColumnNames = function() {
        t._set("columnNames", t.columns.map(function(n) {
            if (n.selected) return n.name
        }).join("<br />")), t._set("refColumnNames", t.refColumns ? t.refColumns.map(function(n) {
            if (n.selected) return n.name
        }).join("<br />") : "")
    }, t.getDropStmt = function() {
        return "DROP FOREIGN KEY `" + t.prevValue("name") + "`"
    }, t.getDefinition = function() {
        if (t._deleted) return t.getDropStmt();
        if (t._changed && t.columns.length && t.refColumns) {
            var i = t.columns.map(function(n) {
                    if (n.selected) return "`" + n.name + "`"
                }),
                r = t.refColumns.map(function(n) {
                    if (n.selected) return "`" + n.name + "`"
                }),
                u = t.refDB != n.getDB().name ? "`" + t.refDB + "`." : "";
            return (n.temp ? "" : t.temp ? "ADD " : t.getDropStmt() + ", ADD ") + "CONSTRAINT `" + t.name + "` FOREIGN KEY (" + i.join(",") + ") REFERENCES " + u + "`" + t.refTable + "` (" + r.join(",") + ") ON DELETE " + t.onDelete + " ON UPDATE " + t.onUpdate
        }
    }, t.updateColumnNames(), t.watchChanges(function(n) {
        n == "refDB" ? t.refTable = t.allRefTables = t.refColumns = null : n == "refTable" && (t.refColumns = null), t.updateColumnNames()
    }), t
}

function Table(n, t) {
    var i = new BaseItem(n, t || GetNewName("new_table_", n.children));
    return t || (i.temp = !0), i.objType = "table", i.icon = IMG_TABLE, i.engine = i.getHost().defEngine, i.rowFormat = "DEFAULT", i.packKeys = "DEFAULT", i.checksum = 0, i.delayKeyWrite = 0, i.avgRowLen = 0, i.minRows = 0, i.maxRows = 0, i.autoInc = 0, i.charset = "", i.collation = "", i.comment = "", i.columns = [], i.indices = [], i.fkeys = [], i.totalColumns = 0, i.watchChanges(), i.load = function(n) {
        i.temp || (i.undoChanges(), i.sendQuery("SHOW CREATE TABLE " + i.getFullName(), function(t) {
            var r, f, e, u;
            for (i.charset = i.collation = "", r = ParseTable(t.getResult(0)[0][1], !1), i.columns = [], r.columns.map(function(n) {
                var t = new Column(i, n);
                t._index = i.columns.length, i.columns.push(t)
            }), r.indices.map(function(n, t) {
                r.indices[t] = new Index(i, n)
            }), r.fkeys.map(function(n, t) {
                r.fkeys[t] = new FKey(i, n)
            }), f = ["engine", "default_charset", "collate", "checksum", "delay_key_write", "avg_row_length", "min_rows", "max_rows", "pack_keys", "row_format", "comment", "auto_increment"], e = ["engine", "charset", "collation", "checksum", "delayKeyWrite", "avgRowLen", "minRows", "maxRows", "packKeys", "rowFormat", "comment", "autoInc"], u = 0; u < f.length; u++) r[f[u]] !== null && r[f[u]] !== undefined ? i[e[u]] = r[f[u]] : e[u] == "autoInc" && (i[e[u]] = 1);
            i.checksum = parseInt(i.checksum), i.delayKeyWrite = parseInt(i.delayKeyWrite), i.rowFormat === null && (i.rowFormat = "DEFAULT"), i.packKeys = i.packKeys === null ? "DEFAULT" : parseInt(i.packKeys) ? "YES" : "NO", i.charset || (i.charset = i.getDB().charset), i.collation || (i.collation = i.getHost().getDefaultCollation(i.charset)), i.indices = r.indices, i.fkeys = r.fkeys, i.totalColumns = i.columns.length, i.confirmChanges(), n && n()
        }))
    }, i.save = function(n, t) {
        var r = i.getDefinition();
        r && (t && (r = "SET @DBN_FKC=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0; " + r + "; SET FOREIGN_KEY_CHECKS=@DBN_FKC"), i.sendQuery(r, function() {
            i.temp = !1, i.load(n)
        }))
    }, i.getDefinition = function() {
        var u = [(i.temp ? "CREATE" : "ALTER") + " TABLE `" + i.name + "`"],
            n = [],
            t, r;
        return (i.propChanged("engine") && n.push("ENGINE " + i.engine), i.engine == "MyISAM" && (i.propChanged("avgRowLen") && n.push("AVG_ROW_LENGTH " + i.avgRowLen), i.propChanged("checksum") && n.push("CHECKSUM " + i.checksum), i.propChanged("packKeys") && n.push("PACK_KEYS " + (i.packKeys == "Default" ? i.packKeys : i.packKeys == "Yes" ? 1 : 0)), i.propChanged("delayKeyWrite") && n.push("DELAY_KEY_WRITE " + i.delayKeyWrite)), i.propChanged("autoInc") && n.push("AUTO_INCREMENT " + i.autoInc), i.propChanged("maxRows") && n.push("MAX_ROWS " + i.maxRows), i.propChanged("minRows") && n.push("MIN_ROWS " + i.minRows), i.propChanged("rowFormat") && n.push("ROW_FORMAT " + i.rowFormat), i.propChanged("charset") && n.push("CHARACTER SET " + (i.charset ? "'" + i.charset + "'" : "DEFAULT")), i.propChanged("collation") && i.charset && n.push("COLLATE '" + (i.collation || i.getHost().getDefaultCollation(i.charset)) + "'"), i.propChanged("comment") && n.push("COMMENT '" + ("" + i.comment).SQLEscape() + "'"), t = [], t.push2(i.columns.map(function(n) {
            if (n._deleted) return n.getDefinition()
        }).join(",\n")), t.push2(i.columns.map(function(n) {
            if (!n._deleted) return n.getDefinition()
        }).join(",\n")), t.push2(i.indices.map(function(n) {
            return n.getDefinition()
        }).join(",\n")), t.push2(i.fkeys.map(function(n) {
            return n.getDefinition()
        }).join(",\n")), n = n.join(" "), t = t.join(",\n"), i.temp) ? "CREATE TABLE `" + i.name + "` (" + t + ") " + n : (r = n ? t ? n + ",\n" + t : n : t || "", r ? "ALTER TABLE `" + i.name + "` " + r : "")
    }, i.getColumnNames = function(n) {
        if (i.columns.length) {
            n(i.columns.map(function(n) {
                return n.name
            }));
            return
        }
        i.getDB().getTableColumnNames(i.name, n)
    }, i.getContextMenuItems = function() {
        if (i.temp) return [{
            label: RES.obj_doesnt_exist,
            disabled: !0
        }];
        return [{
            label: "Edit",
            icon: IMG_TABLE_DESIGN,
            auto: !0
        }, {
            label: "Use in Query",
            children: [{
                label: "Select"
            }, {
                label: "Insert"
            }, {
                label: "Update"
            }, {
                label: "Delete"
            }],
            icon: IMG_QUERY
        }, null, {
            label: "Count Records",
            icon: IMG_TABLE_COUNT
        }, {
            label: "Find Dependencies",
            icon: IMG_TABLE_RELATIONSHIP
        }, null, {
            label: "Rename",
            icon: IMG_RENAME
        }, {
            label: "Duplicate",
            icon: IMG_DUPLICATE
        }, null, {
            label: "Table Lock",
            children: [{
                label: "READ"
            }, {
                label: "READ LOCAL"
            }, {
                label: "WRITE"
            }, {
                label: "LOW_PRIORITY WRITE"
            }],
            icon: IMG_LOCK
        }, {
            label: "Truncate",
            icon: IMG_BIN
        }, null, {
            label: "Copy Column Names",
            children: [{
                label: "Separated By Commas",
                copy: "copy1"
            }, {
                label: "Separated By Commas + Table Name",
                copy: "copy2"
            }, {
                label: "Separated By Line Feed",
                copy: "copy3"
            }],
            icon: IMG_COPY
        }, null, {
            label: "Export Data",
            icon: IMG_EXPORT
        }, {
            label: "Import Data",
            icon: IMG_IMPORT
        }, null, {
            label: "Drop",
            icon: IMG_TABLE_DELETE
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "edit":
                OpenWindow(FillerTableDesign, i);
                break;
            case "count records":
                i.sendQuery("SELECT COUNT(*) FROM " + i.getFullName(), function(n) {
                    Alert('Table contains <b style="font-size:17px">' + n.data[0][0] + "<\/b> record" + (n.data[0][0] == 1 ? "" : "s"), "Record Count")
                });
                break;
            case "find dependencies":
                new PopupDependencies(i);
                break;
            case "select":
                OpenWindow(FillerQuery, i.getDB(), "SELECT *$$ FROM " + i.getFullName(), !0);
                break;
            case "insert":
                OpenWindow(FillerQuery, i.getDB(), "INSERT INTO " + i.getFullName() + " ($$) VALUES ()", !0);
                break;
            case "update":
                OpenWindow(FillerQuery, i.getDB(), "UPDATE " + i.getFullName() + " SET $$ WHERE ", !0);
                break;
            case "delete":
                OpenWindow(FillerQuery, i.getDB(), "DELETE FROM " + i.getFullName() + " WHERE $$", !0);
                break;
            case "truncate":
                YesNoDialog("Delete all records from table `" + i.name + "`?", i.truncate);
                break;
            case "rename":
                i.rename();
                break;
            case "duplicate":
                i.duplicate();
                break;
            case "drop":
                i.getDB().drop(i);
                break;
            case "read":
            case "read local":
            case "write":
            case "low_priority write":
                i.sendQuery("LOCK TABLES " + i.getFullName() + n.label, function() {
                    Alert(RES.completed_successfully, "LOCK " + n.label)
                });
                break;
            case "export data":
                new PopupExportData(i, "SELECT * FROM `" + i.name + "`");
                break;
            case "import data":
                new PopupImportData(i);
                break;
            default:
                if (n.copy) {
                    var t, r;
                    n.copy == "copy1" || n.copy == "copy3" ? (t = n.copy == "copy1" ? ", " : "\n", r = function(n) {
                        return "`" + n + "`"
                    }) : (t = ", ", r = function(n) {
                        return "`" + i.name + "`.`" + n + "`"
                    }), i.getColumnNames(function(n) {
                        SetClipboard(n.map(r).join(t))
                    })
                }
        }
    }, i.rename = function() {
        i.getDB().renameTable(i)
    }, i.duplicate = function() {
        Confirm(RES.duplicate_enter_new_name, "Duplicate table `" + i.name + "`", i.name + "_copy", function(n) {
            var t = ["CREATE TABLE `" + n + "` LIKE `" + i.name + "`"];
            i.$("chkDup").checked && t.push("INSERT INTO `" + n + "` SELECT * FROM `" + i.name + "`"), i.sendQuery(t, function() {
                i.getDB().reloadChildren("table", n)
            })
        }, !1, '<label><input id="' + i._("chkDup") + '" type="checkbox" style="margin:5px" />Copy data<\/label> ')
    }, i.checkChanged = function() {
        var t, n, r;
        if (i._changed || i.columns.length != i.totalColumns) return !0;
        for (t = [i.columns, i.indices, i.fkeys], n = 0; n < t.length; n++)
            for (r = 0; r < t[n].length; r++)
                if (t[n][r]._changed || t[n][r].temp) return !0
    }, i.truncate = function() {
        i.sendQuery("TRUNCATE " + i.getFullName())
    }, i
}

function Trigger(n, t) {
    typeof t != "string" && t || (t = [t || GetNewName("new_trigger_", n.children), "INSERT", "", "BEGIN\n\t\nEND\n", "AFTER", null, null, "CURRENT_USER"], t.temp = !0);
    var i = new BaseItem(n, t[0]);
    return i.getLabel = function() {
        return i.name + (i.table ? " (" + i.table + ")" : "")
    }, i.objType = "trigger", i.icon = IMG_TRIGGER, i.action = t[1], i.table = t[2], i.code = t[3].replace(/\r\n/g, "\n"), i.timing = t[4], i.definer = t[7], t.temp && i._set("temp", !0), i.getContextMenuItems = function() {
        return i.temp ? [{
            label: RES.obj_doesnt_exist,
            disabled: !0
        }] : [{
            label: "Edit",
            auto: 1,
            icon: IMG_TRIGGER_EDIT
        }, null, {
            label: "Drop",
            icon: IMG_TRIGGER_DELETE
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "edit":
                OpenWindow(FillerTrigger, i);
                break;
            case "drop":
                i.getDB().drop(i)
        }
    }, i.getDefinition = function(n) {
        return "CREATE " + (i.definer ? "DEFINER=" + i.formatDefiner() : "") + " TRIGGER `" + (n ? n : i.name) + "` " + i.timing + " " + i.action + " ON `" + i.table + "` FOR EACH ROW " + i.code
    }, i.save = function(n) {
        function t() {
            i.temp = !1, i.confirmChanges(), i.dispatchChange(), n && n()
        }
        i.temp ? i.sendQuery(i.getDefinition(), t) : i.getDB().dropCreate(i, !1, t)
    }, i.watchChanges(), i
}

function View(n, t) {
    var i = new BaseItem(n, t || GetNewName("new_view_", n.children));
    return i.objType = "view", i.icon = IMG_VIEW, i.algorithm = "UNDEFINED", i.definer = "CURRENT_USER", i.sqlSecurity = "DEFINER", i.checkOption = "NONE", i.code = "SELECT * FROM ", i.getContextMenuItems = function() {
        return i.temp ? [{
            label: RES.obj_doesnt_exist,
            disabled: !0
        }] : [{
            label: "Edit",
            auto: 1,
            icon: IMG_VIEW_EDIT
        }, null, {
            label: "Use in Query",
            children: [{
                label: "Select"
            }, {
                label: "Insert"
            }, {
                label: "Update"
            }, {
                label: "Delete"
            }],
            icon: IMG_QUERY
        }, null, {
            label: "Rename",
            icon: IMG_RENAME
        }, {
            label: "Duplicate",
            icon: IMG_DUPLICATE
        }, null, {
            label: "Export Data",
            icon: IMG_EXPORT
        }, null, {
            label: "Drop",
            icon: IMG_VIEW_DELETE
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "edit":
                OpenWindow(FillerView, i);
                break;
            case "drop":
                i.getDB().drop(i);
                break;
            case "duplicate":
                i.duplicate();
                break;
            case "rename":
                i.rename();
                break;
            case "select":
                OpenWindow(FillerQuery, i.getDB(), "SELECT *$$ FROM " + i.getFullName(), !0);
                break;
            case "insert":
                OpenWindow(FillerQuery, i.getDB(), "INSERT INTO " + i.getFullName() + " ($$) VALUES ()", !0);
                break;
            case "update":
                OpenWindow(FillerQuery, i.getDB(), "UPDATE " + i.getFullName() + " SET ($$) WHERE ", !0);
                break;
            case "delete":
                OpenWindow(FillerQuery, i.getDB(), "DELETE FROM " + i.getFullName() + " WHERE $$", !0);
                break;
            case "export data":
                new PopupExportData(i, "SELECT * FROM `" + i.name + "`")
        }
    }, i.load = function(n) {
        i.temp || i.sendQuery("SHOW CREATE VIEW " + i.getFullName(), function(t) {
            var r = ParseView(t.getResult(0)[0][1]);
            i.algorithm = r.algorithm || "UNDEFINED", i.definer = r.definer, i.sqlSecurity = r.sqlSecurity, i.checkOption = r.checkOption || "NONE", i.sendReq("data.php", {
                action: "format_sql",
                sql: r.code
            }, function(t) {
                i.code = t.result, n && n()
            })
        })
    }, i.save = function(n) {
        var t = "CREATE OR REPLACE ALGORITHM=" + i.algorithm + " DEFINER=" + i.formatDefiner() + " SQL SECURITY " + i.sqlSecurity + " VIEW " + i.getFullName() + " AS " + i.code + (i.checkOption == "NONE" ? "" : " WITH " + i.checkOption + " CHECK OPTION");
        i.sendQuery(t, function() {
            i.temp = !1, i.confirmChanges(), i.dispatchChange(), n && n()
        })
    }, i.rename = function() {
        i.getDB().renameTable(i)
    }, i.duplicate = function() {
        Confirm(RES.duplicate_enter_new_name, "Duplicate View `" + i.name + "`", i.name + "_copy", function(n) {
            i.showCreate(function(t) {
                t = t.replace(new RegExp("view `" + i.name + "`", "i"), "view `" + n + "`"), i.sendQuery(t, function() {
                    i.getDB().reloadChildren(i.objType, n)
                })
            })
        })
    }, i.watchChanges(), i
}

function Func(n, t) {
    var i = new Proc(n, t || GetNewName("new_func_", n.children));
    return i.objType = "function", i.icon = IMG_FUNCTION, i.returnColumn = "INT(10)", i
}

function Proc(n, t) {
    var i = new BaseItem(n, t || GetNewName("new_proc_", n.children));
    return i.objType = "procedure", i.icon = IMG_PROCEDURE, i.definer = "CURRENT_USER", i.code = "BEGIN\n\nEND", i.deterministic = "NOT DETERMINISTIC", i.dataAccess = "CONTAINS SQL", i.comment = "", i.sqlSecurity = "DEFINER", i.params = [], i.launchValues = [], i.getContextMenuItems = function() {
        return i.temp ? [{
            label: RES.obj_doesnt_exist,
            disabled: !0
        }] : [{
            label: "Edit",
            auto: 1,
            icon: eval("IMG_" + i.objType.toUpperCase() + "_EDIT")
        }, {
            label: "Run in Query Editor",
            icon: IMG_QUERY_RUN
        }, null, {
            label: "Duplicate",
            icon: IMG_DUPLICATE
        }, null, {
            label: "Drop",
            icon: eval("IMG_" + i.objType.toUpperCase() + "_DELETE")
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "edit":
                OpenWindow(FillerProc, i);
                break;
            case "run in query editor":
                OpenWindow(FillerProc, i, !0);
                break;
            case "duplicate":
                i.duplicate();
                break;
            case "drop":
                i.getDB().drop(i)
        }
    }, i.load = function(n) {
        if (i.temp) {
            n && n();
            return
        }
        i.sendQuery("SELECT `param_list`,`returns`,`body`,`sql_data_access`,`is_deterministic`,`security_type`,`definer` FROM `mysql`.`proc` WHERE `db`='" + i.getDB().name + "' AND `name`='" + i.name + "'", function(t) {
            var h, u, o, f, r, s, e;
            if (!t.data.length) {
                Alert("Failed to read the details of the " + i.objType);
                return
            }
            if (t = t.data[0], i.params = [], h = t[0].trim().replace(/[\n\r\t]/g, "").replace(/\((\d+), (\d+)\)/g, "($1,$2)").replace(/\x20{2,}/g, " "), h) {
                for (u = h.split(/, (|IN|OUT|INOUT)/i), o = [], r = 0; r < u.length; r++)(f = u[r], f) && (f = f.toUpperCase(), f == "IN" || f == "OUT" || f == "INOUT" ? (o.push(u[r] + u[r + 1]), r++) : o.push(u[r]));
                for (u = o, r = 0; r < u.length; r++) s = u[r].trim(), i.objType == "procedure" && s.search(/^(IN|OUT|INOUT)/i) > -1 ? e = s.split2(" ", 3) : (e = s.split2(" ", 2), e.splice(0, 0, "IN")), i.params.push({
                    name: e[1].replace(/`/g, ""),
                    direction: e[0].toUpperCase(),
                    type: e[2].toUpperCase()
                })
            }
            i.returnColumn = t[1].toUpperCase(), i.code = t[2], i.dataAccess = t[3].replace(/_/g, " "), i.deterministic = (t[4] == "NO" ? "NOT " : "") + "DETERMINISTIC", i.sqlSecurity = t[5], i.definer = t[6], i.params.map(function(n) {
                n.watchChanges()
            }), i.confirmChanges(), n && n()
        })
    }, i.getDefinition = function(n) {
        var t = "CREATE DEFINER=" + i.formatDefiner() + " " + i.objType.toUpperCase() + " `" + (n ? n : i.name) + "` (",
            r = i.params.map(function(n) {
                if (!n._deleted) return i.objType == "function" ? n.name + " " + n.type : n.direction + " " + n.name + " " + n.type
            });
        return t += r.join(", ") + ")\n", i.objType == "function" && (t += "\tRETURNS " + i.returnColumn + "\n"), t + ("\t" + i.deterministic + "\n\t" + i.dataAccess + "\n\tSQL SECURITY " + i.sqlSecurity + "\n\tCOMMENT '" + i.comment.replace(/\x27/g, "\\'") + "'\n" + i.code)
    }, i.save = function(n) {
        i.getDB().dropCreate(i, !0, function() {
            i.temp = !1, i.confirmChanges(), i.getDB().sortChildren(), i.dispatchLabelChanged(), i.load(n)
        })
    }, i.duplicate = function() {
        Confirm(RES.duplicate_enter_new_name, "Duplicate Proc `" + i.name + "`", i.name + "_copy", function(n) {
            i.showCreate(function(t) {
                t = t.replace(new RegExp("(procedure|function) `" + i.name + "`", "i"), "$1 `" + n + "`"), i.sendQuery(t, function() {
                    i.getDB().reloadChildren(i.objType, n)
                })
            })
        })
    }, i.watchChanges(), i
}

function TreeGroup(n, t, i, r, u) {
    var f = new BaseItem(n, t + "s");
    return f.icon = eval("IMG_" + t.toUpperCase()), f.open = !1, f.children = i, f.objType = "group", f.createChild = function() {
        var n = t.toLowerCase();
        Confirm("Enter a name for the new " + n, "New " + t, GetNewName("new_" + n + "_", f.children), function(n) {
            if (n = n.trim(), n) {
                var t = new r(f, n);
                t.temp = !0, f.children.push(t), f.dispatchChange(), OpenWindow(u, t), t.dispatchChange()
            }
        })
    }, f.getContextMenuItems = function() {
        return [{
            label: "Create New " + t,
            icon: eval("IMG_" + t.toUpperCase() + "_ADD")
        }, null, {
            label: "Refresh",
            icon: IMG_REFRESH
        }]
    }, f.contextMenuHandler = function(t) {
        t.label.toLowerCase().startWith("create") ? f.createChild() : n.reloadChildren(f, null)
    }, f
}

function Database(n, t) {
    var i = new BaseItem(n, t),
        u, f, e, o, s, r;
    return i.objType = "database", i.getIcon = function() {
        return i.open ? IMG_DATABASE_OPEN : IMG_DATABASE
    }, i.charset = "", i.collation = "", i.open = !1, i.children = "", i.getFullName = function() {
        return "`" + i.name + "`"
    }, i.dropCreate = function(n, t, r) {
        var u, f, e;
        if (n.temp) {
            i.sendQuery(n.getDefinition(), r);
            return
        }
        u = n.objType.toUpperCase(), f = ["DROP " + u + " `" + n.prevValue("name") + "`", n.getDefinition()], t && (e = "_dbn_" + String.random(15), f.splice(0, 0, n.getDefinition(e), "DROP " + u + " `" + e + "`")), i.sendQuery(f, r)
    }, i.getContextMenuItems = function() {
        return i.open ? [{
            label: "Query Editor",
            icon: IMG_QUERY
        }, {
            label: "Visual Query Builder",
            disabled: 1
        }, null, {
            label: "Create New...",
            children: [{
                label: "Table",
                icon: IMG_TABLE_ADD
            }, {
                label: "View",
                icon: IMG_VIEW_ADD
            }, {
                label: "Procedure",
                icon: IMG_PROCEDURE_ADD
            }, {
                label: "Function",
                icon: IMG_FUNCTION_ADD
            }, {
                label: "Event",
                icon: IMG_EVENT_ADD
            }, {
                label: "Trigger",
                icon: IMG_TRIGGER_ADD
            }],
            icon: IMG_ADD
        }, null, {
            label: "Table Services",
            children: [{
                label: "Analyze Tables"
            }, {
                label: "Optimize Tables"
            }, {
                label: "Check Tables"
            }, {
                label: "Repair Tables"
            }],
            icon: IMG_TABLE_SERVICE
        }, {
            label: "Flush...",
            children: [{
                label: "Hosts"
            }, {
                label: "Logs"
            }, {
                label: "Privileges"
            }, {
                label: "Tables"
            }, {
                label: "Status"
            }],
            icon: IMG_THUMB_UP
        }, {
            label: "Unlock Tables",
            icon: IMG_LOCK_OPEN
        }, null, {
            label: "Export to Script",
            icon: IMG_DATABASE_SAVE
        }, {
            label: "Compare to...",
            icon: IMG_COMPARE
        }, null, {
            label: "Drop",
            icon: IMG_DATABASE_DELETE
        }, {
            label: "Drop Multiple Objects",
            icon: IMG_CANCEL
        }, null, {
            label: "Details",
            icon: IMG_INFO
        }, {
            label: "Properties",
            icon: IMG_DATABASE_GEAR
        }, null, {
            label: "Refresh",
            icon: IMG_REFRESH
        }, {
            label: "Close",
            icon: IMG_DISCONNECT
        }] : [{
            label: "Open",
            auto: 1,
            icon: IMG_DATABASE_CONNECT
        }, null, {
            label: "Export to Script",
            icon: IMG_DATABASE_SAVE
        }, {
            label: "Compare to...",
            icon: IMG_COMPARE
        }, null, {
            label: "Drop",
            icon: IMG_DATABASE_DELETE
        }]
    }, i.contextMenuHandler = function(n) {
        var t, h = n.label.toLowerCase();
        switch (h) {
            case "open":
                i.load();
                break;
            case "close":
                CloseAllWindows(i, !1, i.close);
                break;
            case "details":
                OpenWindow(FillerDatabaseInfo, i);
                break;
            case "properties":
                OpenWindow(FillerDatabase, i);
                break;
            case "query editor":
                OpenWindow(FillerQuery, i, "", !0);
                break;
            case "hosts":
            case "logs":
            case "privileges":
            case "tables":
            case "status":
                t = "FLUSH " + n.label.toUpperCase();
            case "unlock tables":
                t || (t = "UNLOCK TABLES"), i.sendQuery(t, function() {
                    Alert(RES.completed_successfully, t)
                });
                break;
            case "table":
                u.createChild();
                break;
            case "view":
                f.createChild();
                break;
            case "procedure":
                e.createChild();
                break;
            case "function":
                o.createChild();
                break;
            case "event":
                s.createChild();
                break;
            case "trigger":
                r.createChild();
                break;
            case "drop multiple objects":
                new PopupDelSelected(i);
                break;
            case "drop":
                i.drop(i);
                break;
            case "refresh":
                i.reloadChildren();
                break;
            case "compare / syncronize":
                OpenWindow(FillerCompare, i);
                break;
            case "export to script":
                new PopupExportDB(i);
                break;
            case "compare to...":
                OpenWindow(FillerCompare, i, null, !0);
                break;
            default:
                (h.startWith("analyze") || h.startWith("optimize") || h.startWith("check") || h.startWith("repair")) && OpenWindow(FillerTableServices, i, n.label.split(" ")[0])
        }
    }, i.getTableColumnNames = function(n, t) {
        i.sendQuery("SHOW COLUMNS FROM " + n, function(n) {
            t(n.data.map(function(n) {
                return n[0]
            }))
        })
    }, i.getTableColumnData = function(n, t) {
        i.sendQuery("SELECT * FROM " + n + " LIMIT 0", function(n) {
            t(n.fields)
        })
    }, i.getChild = function(n, t) {
        var r = i.getGroupByObjType(n);
        if (r) return r.getChildByName(t)
    }, i.getGroupByObjType = function(n) {
        return n = n.substr(0, 4).toLowerCase(), {
            tabl: u,
            view: f,
            func: o,
            proc: e,
            even: s,
            trig: r
        } [n]
    }, i.getTableNames = function(t) {
        i.sendQuery("SHOW " + (n.supportViews ? "FULL " : "") + "TABLES FROM `" + i.name + "`", function(i) {
            t(i.data.map(function(t) {
                if (!n.supportViews || t[1] != "VIEW") return t[0]
            }))
        })
    }, i.sortChildren = function() {
        u.sortChildren(), f.sortChildren(), e.sortChildren(), o.sortChildren(), s.sortChildren(), r.sortChildren()
    }, i.renameTable = function(n) {
        function t(t) {
            n.name = t, i.sortChildren(), n.dispatchLabelChanged()
        }
        Confirm(RES.rename_enter_new_name, "Rename " + n.objType + " `" + n.name + "`", n.name, function(r) {
            n.temp ? t(r) : i.sendQuery("RENAME TABLE " + n.getFullName() + " TO " + r, function() {
                t(r)
            })
        })
    }, i.load = function(n) {
        i.open ? i.reloadChildren(null, null, n) : (u = new TreeGroup(i, "Table", [], Table, FillerTableDesign), f = new TreeGroup(i, "View", [], View, FillerView), e = new TreeGroup(i, "Procedure", [], Proc, FillerProc), o = new TreeGroup(i, "Function", [], Func, FillerProc), s = new TreeGroup(i, "Event", [], Event, FillerEvent), r = new TreeGroup(i, "Trigger", [], Trigger, FillerTrigger), i.tables = u.children, i.views = f.children, i.procs = e.children, i.funcs = o.children, i.events = s.children, i.trigs = r.children, i.sendQuery("SELECT @@character_set_database, @@collation_database", function(t) {
            t = t.data[0];
            var r = i.getHost();
            i.charset = t[0], i.collation = t[1], i.reloadChildren(null, null, n)
        }))
    }, i.reloadChildren = function(t, h, c) {
        i.sendQuery("SHOW TABLE STATUS FROM `" + i.name + "`; " + (n.supportProcs ? "SHOW PROCEDURE STATUS WHERE `db`='" + i.name + "'; SHOW FUNCTION STATUS WHERE `db`='" + i.name + "'; " : "SELECT ''; ") + (n.supportEvents ? "SHOW EVENTS FROM `" + i.name + "`; " : 'SELECT ""; ') + (n.supportTriggers ? "SHOW TRIGGERS FROM `" + i.name + "`; " : 'SELECT ""; '), function(l) {
            var v, y, p;
            if (i.children = [u], a = l.getResult(0), v = a.map(function(n) {
                return n[1] ? n[0] : undefined
            }), v && (u.removeOldChildren(v), v.map(function(n) {
                u.createNewChild(Table, n)
            })), n.supportViews && (y = a.map(function(n) {
                return n[1] ? undefined : n[0]
            }), y && (f.removeOldChildren(y), y.map(function(n) {
                f.createNewChild(View, n)
            })), i.children.push(f)), n.supportProcs && (a = l.getResult(1), a && (a = a.map(function(n) {
                return n[1]
            }), e.removeOldChildren(a), a.map(function(n) {
                e.createNewChild(Proc, n)
            })), i.children.push(e), a = l.getResult(2), a && (a = a.map(function(n) {
                return n[1]
            }), o.removeOldChildren(a), a.map(function(n) {
                o.createNewChild(Func, n)
            })), i.children.push(o)), n.supportEvents && (a = l.getResult(3), a && (a = a.map(function(n) {
                return n[1]
            }), s.removeOldChildren(a), a.map(function(n) {
                s.createNewChild(Event, n)
            })), i.children.push(s)), n.supportTriggers && (a = l.getResult(4), a && (p = a.map(function(n) {
                return n[0]
            }), r.removeOldChildren(p), a.map(function(n) {
                r.getChildByName(n[0]) || r.createNewChild(Trigger, n)
            })), i.children.push(r)), i.open = !0, i.sortChildren(), h) {
                if (typeof h == "string" && (h = i.getChild(t, h)), h) {
                    h.dispatchChange();
                    return
                }
            } else t ? t.dispatchChange() : i.dispatchChange();
            c && c()
        })
    }, i.save = function(n) {
        i.charset || (i.charset = i.getHost().charset), i.collation || (i.collation = i.getHost().getDefaultCollation(i.charset)), i.sendQuery("ALTER DATABASE `" + t + "` CHARACTER SET '" + i.charset + "' COLLATE '" + i.collation + "'", function() {
            i.confirmChanges(), i.dispatchChange(), n && n()
        })
    }, i.close = function() {
        i.destroy(!0), i.tables = i.views = i.procs = i.funcs = i.events = i.trigs = null, i.open = !1, i.children = "", i.dispatchChange()
    }, i.checkChanged = function() {
        if (i._changed) return !0
    }, i.drop = function(n) {
        if (n.temp) {
            n.parent.children.removeAll(n), n.parent.dispatchChange(), n.destroy(), CloseAllWindows(n, !0);
            return
        }
        YesNoDialog("Drop " + n.objType + " `" + n.name + "`?", function() {
            i.sendQuery("DROP " + n.objType.toUpperCase() + " `" + n.name + "`", function() {
                CloseAllWindows(n, !0), n.objType == "database" ? n.parent.reloadDBs() : i.reloadChildren(null, i.getGroupByObjType(n.objType))
            })
        })
    }, i.iterateChildren = function(n) {
        i.children.map(function(t) {
            if (t.children) return t.children.map(n)
        })
    }, i.watchChanges(), i
}

function Host(n, t) {
    var i = new BaseItem(n, t.label),
        r, u;
    return i.objType = "host", i.getIcon = function() {
        return i.connected ? IMG_SERVER_CONNECTED : IMG_SERVER
    }, i.engines = [], i.charsets = [], i.charset = "", i.collation = "", i.version = "", i.defEngine = "InnoDB", i.users = [{
        label: "CURRENT_USER"
    }], i.currentUser = "", i.children = "", i.connected = !1, i.tempPasswd = "", i.selectedChild = null, i.savePasswd = !0, i.keepAlive = !1, i.favourites = new FavouritesGroup(i, "Favorite Queries"), i.myScripts = new ScriptGroup(i, "Session Uploads"), i.checkVersion = function(n) {
        var t = i.version.replace(/\W+$/, "").split(".").map(function(n) {
                return parseInt(n)
            }),
            r = n.split(".").map(function(n) {
                return parseInt(n)
            });
        return t[0] > r[0] || t[0] == r[0] && t[1] > r[1] || t[0] == r[0] && t[1] == r[1] && t[2] >= r[2]
    }, i.update = function(n) {
        i.cid = n.cid, i.label = i.name = n.label, i.host = n.host, i.port = (n.port ? n.port : 3306) + "", i.uname = n.uname, i.passwd = n.passwd, i.savePasswd = i.passwd !== null, i.keepAlive = n.keepAlive || !1, i.connected && i.startKeepAlive()
    }, i.getContextMenuItems = function() {
        return i.connected ? [{
            label: "Create Database",
            icon: IMG_DATABASE_ADD
        }, null, {
            label: "Server Management",
            children: [{
                label: "Process List",
                tab: 0
            }, {
                label: "Server Variables",
                tab: 1
            }, {
                label: "Status Information",
                tab: 2
            }],
            icon: IMG_SERVER_EDIT
        }, {
            label: "User Management",
            children: [{
                label: "User Manager",
                icon: IMG_GROUP
            }, {
                label: "Export Users",
                icon: IMG_GROUP_GO
            }],
            icon: IMG_GROUP
        }, null, {
            label: "Query Editor",
            icon: IMG_QUERY
        }, null, {
            label: "Execute SQL Script",
            icon: IMG_SCRIPT_ADD
        }, null, {
            label: "Refresh",
            icon: IMG_REFRESH
        }, {
            label: "Disconnect",
            icon: IMG_DISCONNECT
        }] : [{
            label: "Connect",
            auto: 1,
            icon: IMG_CONNECT
        }, null, {
            label: "Manage Hosts",
            icon: IMG_SERVER_EDIT
        }]
    }, i.contextMenuHandler = function(n) {
        switch (n.label.toLowerCase()) {
            case "connect":
                i.load();
                break;
            case "disconnect":
                CloseAllWindows(i, !1, i.disconnect);
                break;
            case "process list":
            case "server variables":
            case "status information":
                OpenWindow(FillerHostManagement, i, n.tab);
                break;
            case "refresh":
                i.reloadDBs();
                break;
            case "create database":
                Confirm("New database name:", "Create Database", GetNewName("new_database_", i.children), function(n) {
                    i.sendQuery("CREATE DATABASE `" + n + "`", function() {
                        i.reloadDBs(null, n)
                    })
                });
                break;
            case "manage hosts":
                new PopupAppSettings(APP, 0);
                break;
            case "execute sql script":
                i.uploadScript();
                break;
            case "query editor":
                OpenWindow(FillerQuery, i, "", !0);
                break;
            case "user manager":
                OpenWindow(FillerUserManager, i);
                break;
            case "export users":
                OpenWindow(FillerExportUsers, i)
        }
    }, i.getDefaultCollation = function(n) {
        var t = i.charsets.findByProp("label", n);
        return i.charsets[t].defCollation.label
    }, i.getCollations = function(n) {
        var t = i.charsets.findByProp("label", n || i.charset);
        return t > -1 ? i.charsets[t].collations : null
    }, i.getCharsetForCollation = function(n) {
        for (var r = i.charsets, u, t = 0; t < r.length; t++)
            if (u = r[t].collations.findByProp("label", n), u > -1) return r[t].label
    }, i.loadUsers = function(n) {
        i.users.length = 1, i.sendQuery("SELECT `User`,`Host` FROM `mysql`.`user` ORDER BY `User`,`Host`", function(t) {
            t.data.map(function(n) {
                i.users.push({
                    label: n[0] + "@" + n[1],
                    user: n[0],
                    host: n[1]
                })
            }), n && n()
        }, null, 0, !1, !1, function(t) {
            return n && n(), t.error.search(/select command denied/i) > -1 ? !0 : void 0
        })
    }, i.reloadDBs = function(n, t, r, u) {
        function f(n) {
            var f = n.map(function(n) {
                    if (u || !(APP.hideSysDBs && ["mysql", "performance_schema", "information_schema"].contains(n[0]))) return n[0]
                }),
                e;
            i.children && i.children.splice(0, 2), i.removeOldChildren(f), f.map(function(n) {
                i.createNewChild(Database, n)
            }), i.sortChildren(), i.children.splice(0, 0, i.myScripts, i.favourites), t && (e = i.getChildByName(t)), (e || i).dispatchChange(), r && r()
        }
        if (n) {
            f(n);
            return
        }
        i.sendQuery("SHOW DATABASES", function(n) {
            f(n.getResult(0))
        })
    }, i.load = function(n) {
        if (i.connected) {
            n();
            return
        }
        i.passwd === null ? Confirm("Enter password for user `" + i.uname + "`", "Host Password", i.tempPasswd, function(t) {
            i.tempPasswd = t, i.sendReq("data.php", {
                action: "set_temp_passwd",
                cid: i.cid,
                passwd: t
            }, function() {
                i._load(n)
            }, null, null, !0)
        }, !0) : i._load(n)
    }, i._load = function(n) {
        i.sendQuery("SHOW DATABASES; SHOW CHARACTER SET; SHOW COLLATION; SHOW ENGINES; SELECT @@character_set_server, @@collation_server; SELECT VERSION(); SELECT CURRENT_USER", function(t) {
            var r, c, s, e, h, o, l, u, f, a;
            for (r = t.getResult(1), c = t.getResult(2), i.charsets = [], s = 0; s < r.length; s++) {
                for (e = r[s], h = {
                    label: e[0],
                    tooltip: e[1],
                    maxlen: e[3],
                    collations: []
                }, u = 0; u < c.length; u++) o = c[u], e[0] == o[1] && (l = {
                    id: o[2],
                    label: o[0]
                }, o[3] && (h.defCollation = l), h.collations.push(l));
                i.charsets.push(h)
            }
            for (i.charsets.sortProp("label"), r = t.getResult(3), i.engines = [], u = 0; u < r.length; u++)(f = r[u], f[1] != "NO") && (a = ENGINES[f[0].toLowerCase()], a && (f[2] = a), r[u], i.engines.push({
                label: f[0],
                tooltip: f[2]
            }), f[1] == "DEFAULT" && (i.defEngine = f[0]));
            i.engines.sortProp("label"), r = t.getResult(4), i.charset = r[0][0], i.collation = r[0][1], r = t.getResult(5), i.version = r[0][0].replace(/[^0-9\.]/g, ""), r = t.getResult(6), i.currentUser = r[0][0], i.supportProcs = i.checkVersion("5.0.0"), i.supportViews = i.checkVersion("5.0.1"), i.supportTriggers = i.checkVersion("5.0.2"), i.supportEvents = i.checkVersion("5.1.6"), i.children = [], i.reloadDBs(t.getResult(0), null, function() {
                i.loadUsers(function() {
                    i.connected = !0, i.dispatchChange(), n && n(), i.startKeepAlive()
                })
            })
        })
    }, i.stopKeepAlive = function() {
        r && clearTimeout(r)
    }, i.startKeepAlive = function() {
        i.stopKeepAlive(), i.keepAlive && (r = setInterval(function() {
            i.sendReq("data.php", {
                cid: i.cid,
                action: "ping"
            }, function(n) {
                n.error && (i.connected && Alert(n.error), i.stopKeepAlive())
            }, i.stopKeepAlive, 0, !1, !0)
        }, 15e3))
    }, i.disconnect = function() {
        i.stopKeepAlive(), i.destroy(!0), i.connected = !1, i.children = "", i.dispatchChange()
    }, u = i.destroy, i.destroy = function(n) {
        i.stopKeepAlive(), i.children && i.children.splice(0, 2), n || (i.favourites.destroy(), i.myScripts.destroy()), u(n)
    }, i.uploadScript = function() {
        new UploadDialog(RES.upload_sql_script, function(n) {
            Confirm(RES.enter_script_name + ":", RES.script_name, GetNewName("script_", i.children[0].children), function(t) {
                var r = new Script(i.myScripts, t, n);
                i.myScripts.addScript(r), r.dispatchChange(), r.run()
            })
        }, APP.hostInfo.maxFileSize, RES.warn_file_post_size)
    }, t && i.update(t), i.watchChanges(), i
}

function App() {
    var n = new BaseItem(null, "DbNinja");
    return n.objType = "app", n.children = [], n.phpEncodings = [], CONFIG_OPTS.copyTo(n), n.updateConfig = function(t) {
        CONFIG_OPTS.getKeys().map(function(i) {
            n[i] = t[i] !== undefined ? t[i] : CONFIG_OPTS[i]
        });
        var i = [].concat(n.children);
        n.children.length = 0, t.hosts.map(function(t) {
            for (var u, r = 0; r < i.length; r++)
                if (i[r] && t.cid == i[r].cid) {
                    i[r].update(t), n.children.push(i[r]), i[r] = null;
                    return
                } u = new Host(n, t), n.children.push(u), t.queries && u.favourites.update(t.queries)
        }), i.map(function(n) {
            n && (CloseAllWindows(n, !0), n.destroy())
        }), n.dispatchChange(), n.dispatchEvent("configUpdated")
    }, n.load = function(t) {
        n.sendReq("data.php", {
            action: "load_config"
        }, function(i) {
            n.updateConfig(i), n.sendReq("data.php", {
                action: "server_info"
            }, function(i) {
                i.time *= 1e3, i.maxFileSize = Math.min(InBytes(i.upload_max_filesize), InBytes(i.post_max_size)) - 1024, n.hostInfo = i, n.loadTime = (new Date).getTime(), t && t()
            })
        })
    }, n.relogin = function(t) {
        var i = new LoginDialog(sessionStorage.getItem("uname") || "", function(r, u) {
            var u = SHA1(u);
            sessionStorage.setItem("uname", r), sessionStorage.setItem("passwd", u), HTTPComm.encryptKey = "", HTTPComm.decryptKey = u, n.sendReq("data.php?action=auth", "uname=" + encodeURIComponent(r) + "&passwd=" + SHA1(u), function(r) {
                if (r.error) {
                    Alert(r.error, "Error");
                    return
                }
                i.close(), HTTPComm.decryptKey = "", n.updateConfig(r), t && t()
            })
        })
    }, n.getServerTime = function() {
        var t = new Date(n.hostInfo.time + ((new Date).getTime() - n.loadTime)).toISOString();
        return t.substr(0, 10) + " " + t.substr(11, 8)
    }, n.save = function(t, i, r) {
        var u = i || n.clone(CONFIG_OPTS.getKeys());
        u.passwd = i && i.newPasswd ? SHA1(i.newPasswd) : "", delete u.newPasswd, u.hosts = t || n.children.map(function(n) {
            var t = n.clone(CONFIG_OPTS_HOST);
            return t.queries = n.favourites ? n.favourites.cloneChildren() : [], t
        }), n.sendReq("data.php", {
            action: "save_config",
            config: u
        }, function(t) {
            n.confirmChanges(), n.children.map(function(n) {
                n.confirmChanges()
            }), n.updateConfig(t), r && r()
        }, null, null, !0)
    }, n.checkChanged = function() {
        if (n._changed) return !0;
        for (var t = 0; t < n.children.length; t++)
            if (n.children[t]._changed) return !0
    }, n.about = function() {
        Alert('<div style="text-align:center;font-weight:bold"><img src="images/logo.png" style="vertical-align:-12px" onclick="if(event.altKey)Storage.dump()" /> v' + VERSION + '<br /><br />Copyright &copy; 2008-2017 Vayer Software Ltd., All rights reserved.<br /><\/div><p style="text-align:justify"><b>Warning:<\/b> This software is protected by copyright laws and international treaties. Unauthorized reproduction or distribution of this software, or any portion of it, may result in severe civil and criminal penalties, and will be prosecuted to the maximum extent possible under the law.<\/p><p><b>For information visit us at:<\/b> ' + MakeLink(DBNINJAWS, [DBNINJAWS], "_blank", 0) + '<\/p><div><b>Special thanks goes out to:<\/b><div style="line-height:17px;padding:5px 0 5px 10px">Marijn Haverbeke for the great ' + MakeLink("CodeMirror", ["www", ".codemirror.", "net"], "_blank", 0) + " editor<br />Mark James for the beautiful " + MakeLink("Silk Icons", ["www", ".famfamfam.", "com"], "_blank", 0) + "<br /><\/div><\/div>", "About", 370)
    }, n.watchChanges(), n
}

function BaseItem(n, t) {
    var i = Storage.store(this, "** BaseItem: " + t);
    return i.parent = n, i.name = t, i.getLabel = function() {
        return i.name
    }, i.getFullName = function(n) {
        var t = i.getDB(),
            r;
        if (t) return (r = "`" + (n ? t.prevValue("name") : t.name) + "`", t == this) ? r : r + ".`" + (n ? i.prevValue("name") : i.name) + "`"
    }, i.getParent = function(n) {
        for (var t = i;;) {
            if (t.objType == n) return t;
            if (!t.parent) return null;
            t = t.parent
        }
    }, i.getApp = function() {
        return i.getParent("app")
    }, i.getHost = function() {
        return i.getParent("host")
    }, i.getDB = function() {
        return i.getParent("database")
    }, i.dispatchLabelChanged = function() {
        i.dispatchEvent("labelChanged"), APP.dispatchEvent("change", {
            target: i
        })
    }, i.getBreadcrumbs = function() {
        var t = [],
            n = i;
        do n.objType != "group" && n.objType != "app" && t.splice(0, 0, n.objType.capitalize() + ": " + n.name), n = n.parent; while (n);
        return t.join("\n")
    }, i.getCreateSQL = function() {
        var n = "SHOW CREATE " + i.objType.toUpperCase() + " " + i.getFullName(1),
            t = ["function", "procedure", "trigger"].contains(i.objType) ? 2 : i.objType == "event" ? 3 : 1;
        return [n, t]
    }, i.showCreate = function(n) {
        var t = i.getCreateSQL();
        i.sendQuery(t[0], function(i) {
            var r = i.getResult(0)[0][t[1]];
            r === null ? Alert(RES.object_code_unavailable) : n(r)
        })
    }, i.sendQuery = function(n, t, r, u, f, e, o, s) {
        var h, c, l;
        LogSQL(n), h = i.getHost(), h.stopKeepAlive(), c = i.getDB(), l = {
            action: "query",
            cid: h.cid,
            db: c ? c.name + "" : "",
            query: n,
            params: r || [],
            flags: u || 0,
            toFile: f || !1,
            limited: e || !1
        }, i.sendReq("data.php", l, function(n) {
            h.startKeepAlive(), t && t(n.results ? new QueryResult(n) : n)
        }, o, APP.reqTimeout * 1e3 || 0, !1, s || !1)
    }, i.sendReq = function(n, t, r, u, f, e, o) {
        HTTPComm.send(n, t, function(o) {
            typeof o == "object" && o.error ? o.error == "session" ? (APP.relogin(function() {
                i.sendReq(n, t, r, u, f, e)
            }), u && u("Session Error")) : u && u(o) || Alert(o.error, "Error") : r && r(o)
        }, function(n) {
            n == "timeout" ? n = RES.request_timeout : n == "term" && (n = RES.request_failed), u && u(n) || Alert(n, "Error")
        }, f, e || APP.encrypt, o)
    }, i.removeOldChildren = function(n) {
        for (var t = 0; t < i.children.length; t++) i.children[t].temp || n.indexOf(i.children[t].name) != -1 || (i.children[t].destroy(), i.children.splice(t, 1), t--)
    }, i.getChildByName = function(n) {
        n = n.replace(/^`|`$/g, "");
        for (var t = 0; t < i.children.length; t++)
            if (i.children[t].name == n) return i.children[t]
    }, i.createNewChild = function(n, t) {
        i.children.findByProp("name", t) == -1 && i.children.push(new n(i, t))
    }, i.sortChildren = function() {
        i.children.sortProp("name")
    }, i.hasOffspring = function(n) {
        if (!i.children) return !1;
        if (i.children.contains(n)) return !0;
        for (var t = 0; t < i.children.length; t++)
            if (i.children[t].hasOffspring(n)) return !0
    }, i.destroy = function(n) {
        i.children && i.children.length && i.children.map(function(n) {
            n.destroy()
        }), n || Storage.dispose(i)
    }, i.dispatchChange = function() {
        var n = {
            target: i
        };
        i != APP && i.dispatchEvent("change", n), APP.dispatchEvent("change", n)
    }, i.formatDefiner = function() {
        if (i.definer.toUpperCase() == "CURRENT_USER") return i.definer;
        if (!i.definer) return "";
        if (i.definer.indexOf("'@'") > -1) return i.definer;
        var n = i.definer.split("@");
        return "'" + n[0] + "'@'" + n[1] + "'"
    }, i
}

function GetNewName(n, t, i) {
    var u = 0,
        e = new RegExp("^" + n + "(\\d+)", "i"),
        r, f;
    for (i || (i = "name"), r = 0; r < t.length; r++) f = t[r][i].match(e), f && (u = Math.max(u, parseInt(f[1])));
    return n + (u + 1)
}

function $$(n) {
    return typeof n == "string" ? document.getElementById(n) : n
}

function $target(n) {
    return n.srcElement || n.target
}

function Hash() {
    var t = 0,
        n = {};
    this.add = function(i, r) {
        i.__hashId = ++t, n[i.__hashId] = r
    }, this.del = function(t) {
        if (t.__hashId) {
            var i = n[t.__hashId];
            return delete n[t.__hashId], i
        }
    }, this.get = function(t) {
        if (t.__hashId) return n[t.__hashId]
    }
}

function LOG() {}

function ClassFactory(n, t, i, r, u) {
    this.create = function() {
        return new n(t, i, r, u)
    }
}

function GetMousePosition(n) {
    return document.all ? [n.clientX + document.body.scrollLeft, n.clientY + document.body.scrollTop] : [n.pageX, n.pageY]
}

function DiveToElem(n, t, i, r) {
    while (n) {
        if (n == t || i && !DiveToElem(n, t)) return !0;
        r && r(n), n = i ? n.offsetParent : n.parentNode
    }
}

function GetTextWidth(n) {
    var t = $$("__textMeasure__");
    return t || (t = CreateElem("div"), t.style.fontFamily = "monospace", t.style.position = "absolute", t.style.top = "-1000px"), t.innerHTML = n, t.clientWidth
}

function DiveToAttribute(n, t, i) {
    while (n) {
        var r = n.getAttribute ? n.getAttribute(t) : undefined;
        if (r != undefined && (!i || i && r == i)) return [n, r];
        n = n.parentNode
    }
}

function ElemsToArray(n) {
    for (var i = [], t = 0; t < n.length; t++) i.push(n[t]);
    return i
}

function Labelize() {
    for (var t = [], i = Array.isArray(arguments[0]) ? arguments[0] : arguments, n = 0; n < i.length; n++) t.push({
        label: i[n]
    });
    return t
}

function ScrollToView(n, t, i, r) {
    var u, f, e, o;
    i || (i = 0), u = 0, f = 0, DiveToElem(n, t, !0, function(n) {
        f += n.offsetTop, u += n.offsetLeft
    }), e = t.getBoundingClientRect(), o = n.getBoundingClientRect(), (!r || r & 1) && (t.scrollLeft + e.width < u + o.width ? t.scrollLeft = o.width >= e.width ? u : u + o.width - e.width + i : t.scrollLeft >= u && (t.scrollLeft = u - i)), (!r || r & 2) && (t.scrollTop + e.height < f + o.height ? t.scrollTop = o.height >= e.height ? f : f + o.height - e.height + i : t.scrollTop > f && (t.scrollTop = f - i))
}

function GetOffset(n) {
    var t = n.getBoundingClientRect();
    return [t.left, t.top, t.width, t.height]
}

function GetScrollWidth() {
    var n = CreateElem("div"),
        t;
    return n.style.width = "100px", n.style.overflowY = "scroll", t = 100 - n.clientWidth, RemoveNode(n), t
}

function DisableElem(n, t, i) {
    (n = $$(n), n) && (n.style.opacity = t ? i ? i : .8 : 1, n.disabled = t ? "disabled" : "")
}

function RemoveNode(n) {
    n = $$(n), n && n.parentNode && n.parentNode.removeChild(n)
}

function GetByClassName(n, t) {
    t || (t = document);
    for (var r = t.getElementsByTagName("*"), u = [], i = 0; i < r.length;)(" " + (r[i]["class"] || r[i].className) + " ").indexOf(" " + n + " ") > -1 && u.push(r[i]), i++;
    return u
}

function StopPropagation(n) {
    n.cancelBubble = !0, n.stopPropagation && n.stopPropagation()
}

function GetStyle(n, t) {
    return n.currentStyle ? n.currentStyle[t] : window.getComputedStyle ? window.getComputedStyle(n, null)[t] : void 0
}

function MoveIntoView(n) {
    var i = n.getBoundingClientRect(),
        r = i.right - document.body.clientWidth - document.body.scrollLeft + 5,
        t;
    r > 0 && (n.style.left = parseInt(n.style.left) - r + "px"), t = i.bottom - document.body.clientHeight + 5, t > 0 && (n.style.top = parseInt(n.style.top) - t + "px")
}

function CreateElem(n, t) {
    var i = document.createElement(n);
    return t || (t = document.body), t.appendChild(i), i
}

function EscapeHtml(n) {
    return String(n).replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;").replace(/\//g, "&#x2F;")
}

function TextContent(n) {
    return "textContent" in n ? n.textContent : n.innerText
}

function MakeURL(n, t) {
    return (t ? "" : location.protocol + "//") + n.join("")
}

function MakeLink(n, t, i, r) {
    return '<a href="' + MakeURL(t, r) + '"' + (i ? ' target="' + i + '"' : "") + ">" + n + "<\/a>"
}

function CallLater(n) {
    setTimeout(n, 0)
}

function InBytes(n) {
    var t = parseInt(n.substr(0, n.length - 1)),
        i = n.substr(n.length - 1).toUpperCase();
    switch (i) {
        case "P":
            t *= 1024;
        case "T":
            t *= 1024;
        case "G":
            t *= 1024;
        case "M":
            t *= 1024;
        case "K":
            t *= 1024
    }
    return t
}

function AddResizeCallback(n) {
    for (var t = 0; t < __ResizeCallbacks.length; t++)
        if (__ResizeCallbacks[t] == n) return;
    __ResizeCallbacks.push(n)
}

function RemoveResizeCallback(n) {
    var i, t;
    do
        for (i = !1, t = 0; t < __ResizeCallbacks.length; t++)
            if (__ResizeCallbacks[t] == n) {
                __ResizeCallbacks.splice(t, 1), i = !0;
                break
            } while (i)
}

function HandleResize() {
    for (var n = 0; n < __ResizeCallbacks.length; n++) __ResizeCallbacks[n]()
}

function AddEvent(n, t, i, r) {
    var f = __EventCallbacks.length,
        u;
    return __EventCallbacks.push([n, t, i]), u = r ? function(r) {
        i(r) || (n.removeEventListener ? n.removeEventListener(t, arguments.callee, !1) : n.detachEvent(t, arguments.callee))
    } : i, n.addEventListener ? n.addEventListener(t, u, !1) : n.attachEvent(t, u), f
}

function RemoveEvent(n) {
    var t = __EventCallbacks[n];
    t && (t[0].removeEventListener ? t[0].removeEventListener(t[1], t[2], !1) : t[0].detachEvent(t[1], t[2]), delete __EventCallbacks[n])
}

function RemoveEvent2(n, t, i) {
    for (var u, r = 0; r < __EventCallbacks.length; r++) u = __EventCallbacks[r], u && u[0] == n && u[1] == t && u[2] == i && RemoveEvent(r)
}

function RemoveEvents(n) {
    n.map(RemoveEvent)
}

function PrintEvents() {
    var n = [];
    __EventCallbacks.map(function(t) {
        t && n.push(t[1])
    }), alert(n.join("\n"))
}

function DispatchMouseDown() {
    var n;
    document.createEvent ? (n = document.createEvent("MouseEvent"), n.initMouseEvent("mousedown", !0, !0, window, 0, 0, 0, 0, 0, !1, !1, !1, !1, 0, null), document.body.dispatchEvent(n)) : document.createEventObject && (n = document.createEventObject(window.event), n.button = 1, document.body.fireEvent("onmousedown", n))
}

function FillerCompare(n) {
    function s(n, t) {
        n.innerHTML = '<div style="background-image:url(' + IMG_SERVER_CONNECTED + ')" class="item">' + t.parent.name + '<\/div><div style="background-image:url(' + IMG_DATABASE_OPEN + ')" class="item">' + t.name + "<\/div>", n.style.backgroundColor = "#fafafa"
    }

    function h(n) {
        n.getDB().open && n.getHost().connected && APP.children.contains(n.getHost()) ? OpenWindow(FillerTableDesign, n) : Alert("Can't continue, one of this object's parents has been closed or deleted.")
    }
    var i = new FillerBase(n),
        r, u, f, o, e;
    return i.getLabel = function() {
        return "Compare Databases"
    }, i.fill = function(u) {
        function e(n, r) {
            var e = f.data[r],
                u;
            return e.objType == "table" && e.equal === !1 ? (u = IMG_PENCIL, t = "Open table design editor") : (u = n ? IMG_LEFT : IMG_RIGHT, t = "Copy object from " + (n ? "RIGHT" : "LEFT") + " to " + (n ? "LEFT" : "RIGHT")), '<div class="compareResultsButt" title="' + t + '" style="background-image:url(' + u + ')" onclick="' + i._var + ".copyObj(" + n + "," + r + ')"><\/div>'
        }

        function o(n, t, i) {
            var r = n[t];
            return '<div style="color:' + (r.leftName && r.rightName && r.equal ? "green" : r.equal === undefined ? "black" : "red") + '">' + (r[i.dataField] || "") + "<\/div>"
        }
        u.innerHTML = '<div class="buttons" data-sticky="515,,10,">\t<button id="' + i._("btnWork") + '" onclick="' + i._var + '.work()" style="background-image:url(' + IMG_COMPARE + ')">Compare<\/button><\/div><div class="compareRadios" data-sticky="10,,12,">\t<label style="float:left"><input id="' + i._("chkTbles") + '" type="checkbox" checked="checked" onclick="' + i._var + '.updateButtons()" />Tables<\/label>\t<label id="' + i._("lblViews") + '"><input id="' + i._("chkViews") + '" type="checkbox" checked="checked" onclick="' + i._var + '.updateButtons()" />Views<\/label>\t<label id="' + i._("lblProcs") + '"><input id="' + i._("chkProcs") + '" type="checkbox" checked="checked" onclick="' + i._var + '.updateButtons()" />Procs<\/label>\t<label id="' + i._("lblFuncs") + '"><input id="' + i._("chkFuncs") + '" type="checkbox" checked="checked" onclick="' + i._var + '.updateButtons()" />Funcs<\/label>\t<label id="' + i._("lblEvnts") + '"><input id="' + i._("chkEvnts") + '" type="checkbox" checked="checked" onclick="' + i._var + '.updateButtons()" />Events<\/label>\t<label id="' + i._("lblTrgrs") + '"><input id="' + i._("chkTrgrs") + '" type="checkbox" checked="checked" onclick="' + i._var + '.updateButtons()" />Triggers<\/label><\/div><div id="' + i._("phDb1") + '" data-sticky="5,,45,:290" data-dropzone="1" class="compareDbDropzone roundTop roundBottom"><div class="dropText">Drag and drop the 1st database here<\/div><\/div><div id="' + i._("phDb2") + '" data-sticky="317,,45,:275" data-dropzone="1" class="compareDbDropzone roundTop roundBottom"><div class="dropText">Drag and drop the 2nd database here<\/div><\/div><div id="' + i._("phGrid") + '" data-sticky="5,,100,5:600"><\/div>', f = new DataGrid(i.$("phGrid"), {
            selectable: !0,
            resizable: !1,
            editable: !1,
            scrollbars: "vertical",
            scrollToView: !1
        }), f.create([{
            title: "Type",
            dataField: "type",
            width: 70,
            selectable: !1,
            renderer: function(n, t) {
                var i = n[t].objType;
                return '<div style="background-image:url(' + n[t].icon + ');background-repeat:no-repeat;background-position:left center;padding-left:20px">' + (i == "procedure" ? "proc" : i == "function" ? "func" : i).capitalize() + "<\/div>"
            }
        }, {
            title: "Name",
            dataField: "leftName",
            width: 198,
            selectable: !1,
            renderer: o
        }, {
            width: 25,
            align: "center",
            selectable: !1,
            renderer: function(n, t) {
                if (!n[t].leftName && n[t].rightName || n[t].equal === !1) return e(1, t)
            }
        }, {
            width: 25,
            align: "center",
            selectable: !1,
            renderer: function(n, t) {
                return n[t].leftName && n[t].rightName ? n[t].equal === undefined ? "?" : "<div " + (n[t].equal ? "" : 'class="compareResultsButt" title="Show differencies" onclick="' + i._var + ".previewObjs(" + t + ')"') + ' style="font-weight:bold;font-size:15px;color:' + (n[t].equal ? "green" : "red") + '">' + (n[t].equal ? "=" : "&#8800;") + "<\/div>" : ""
            }
        }, {
            width: 25,
            align: "center",
            selectable: !1,
            renderer: function(n, t) {
                if (n[t].leftName && !n[t].rightName || n[t].equal === !1) return e(0, t)
            }
        }, {
            title: "Name",
            dataField: "rightName",
            width: 255,
            selectable: !1,
            renderer: o
        }]), i._addToDeathList(f), n && (r = n, s(i.$("phDb1"), r)), i.updateButtons()
    }, i.show = function() {
        TREE.enableDrag(["database"], function() {
            i.$("phDb1").style.border = "1px dashed red", i.$("phDb2").style.border = "1px dashed red"
        }, function(n) {
            i.$("phDb1").style.border = "1px solid #adadad", i.$("phDb2").style.border = "1px solid #adadad";
            var t;
            n == i.$("phDb1") ? t = r = TREE.selectedItem : n == i.$("phDb2") && (t = u = TREE.selectedItem), t && s(n, t), i.updateButtons()
        })
    }, i.copyObj = function(n, t) {
        function o(t, r) {
            function u() {
                e.sendQuery(t, function() {
                    l()
                })
            }
            if (i.objType == "table" && r) {
                h(n ? i.leftObj : i.rightObj);
                return
            }
            r ? YesNoDialog("Drop the old object and create new one?<br />You may want to create a backup of the old object first.", function() {
                e.sendQuery("DROP " + i.objType.toUpperCase() + " `" + i[n ? "rightName" : "leftName"] + "`", u)
            }) : u()
        }

        function l() {
            i[n ? "leftName" : "rightName"] = i[n ? "rightName" : "leftName"], i[n ? "leftStruct" : "rightStruct"] = i[n ? "rightStruct" : "leftStruct"], i.equal = !0, f.refreshRow(), e.reloadChildren()
        }
        var i = f.data[t],
            c = n ? u : r,
            e = n ? r : u,
            s = i[n ? "rightStruct" : "leftStruct"];
        s ? o(s, !0) : c.getChild(i.objType, i[n ? "rightName" : "leftName"]).showCreate(o)
    }, i.previewObjs = function(n) {
        var t = f.data[n];
        new PopupCompareObjects(t.leftObj, t.leftStruct, t.rightObj, t.rightStruct, "Object Comparison")
    }, i.updateButtons = function() {
        e = [], i.$("chkTbles").checked && e.push("table"), i.$("chkViews").checked && e.push("view"), i.$("chkProcs").checked && e.push("procedure"), i.$("chkFuncs").checked && e.push("function"), i.$("chkEvnts").checked && e.push("event"), i.$("chkTrgrs").checked && e.push("trigger"), DisableElem(i._("btnWork"), !r || !u || !e.length)
    }, i.work = function() {
        function i() {
            o = [], e.map(function(n) {
                var t = {};
                r.getGroupByObjType(n).children.map(function(i) {
                    t[i.name] = {
                        leftObj: i
                    };
                    var r = u.getChild(n, i.name);
                    r && (t[i.name].rightObj = r)
                }), u.getGroupByObjType(n).children.map(function(n) {
                    t[n.name] || (t[n.name] = {
                        rightObj: n
                    })
                }), t.getKeys(!0).map(function(i) {
                    var u = t[i];
                    u.objType = n, u.icon = r.getGroupByObjType(n).icon, u.leftObj && (u.leftName = u.leftObj.name), u.rightObj && (u.rightName = u.rightObj.name), o.push(u)
                })
            }), f.setData(o);
            var i = [],
                s = [],
                n = [],
                t = o.map(function(n) {
                    if (n.leftName && n.rightName) return n
                });
            t.length && (t.map(function(t) {
                var r = t.leftObj.getCreateSQL();
                i.push(r[0]), s.push(t.rightObj.getCreateSQL()[0]), n.push(r[1])
            }), r.sendQuery(i.join(";"), function(i) {
                u.sendQuery(s.join(";"), function(r) {
                    t.map(function(t, u) {
                        i.selectResult(u), r.selectResult(u), t.leftStruct = i.data[0][n[u]], t.rightStruct = r.data[0][n[u]], t.equal = t.leftStruct == t.rightStruct, f.refreshRow(o.indexOf(t))
                    })
                })
            }))
        }
        var n = r.getHost(),
            t = u.getHost();
        if (!n.connected || !t.connected) {
            Alert("Please make sure the host" + (n == t ? " is" : "s are") + " connected.");
            return
        }
        r.load(function() {
            u.load(i)
        })
    }, i.hide = function() {
        TREE.disableDrag()
    }, i.close = function() {
        TREE.disableDrag(), CloseWindow(i)
    }, i
}

function FillerExportUsers(n) {
    var t = new FillerBase(n),
        r, i = [],
        u = !1,
        f = !0,
        e = !0;
    return t.getLabel = function() {
        return "Export Users: " + n.name
    }, t.fill = function(n) {
        function o(n) {
            n == 0 ? (u = !u, i.map(function(n) {
                n.withDrop = u
            })) : n == 1 ? (f = !f, i.map(function(n) {
                n.withCreate = f
            })) : n == 2 && (e = !e, i.map(function(n) {
                n.withGrants = e
            })), t.updateButtons()
        }
        n.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button id="' + t._("btnWork1") + '" onclick="' + t._var + '.work(true)" style="background-image:url(' + IMG_GROUP_GO + ')">Export to File<\/button>\t<button id="' + t._("btnWork2") + '" onclick="' + t._var + '.work(false)" style="background-image:url(' + IMG_GROUP_GO + ')">Export to Clipboard<\/button><\/div><div id="' + t._("phExpGrid") + '" data-sticky="5,,40,5:500"><\/div>', r = new DataGrid(t.$("phExpGrid"), {
            selectable: !0,
            resizable: !1,
            editable: !1,
            scrollbars: "vertical",
            scrollToView: !1,
            onEditSave: function() {
                t.updateButtons()
            }
        }), r.create([{
            title: "",
            dataField: "withDrop",
            width: 75,
            headerRenderer: function() {
                return i.length ? '<div style="cursor:default"><div style="float:left;width:18px">' + DataGridCheckBoxRenderer([
                    [u]
                ], 0, {
                    dataField: 0
                }) + "<\/div>Drop<\/div>" : "Drop"
            },
            renderer: function(n, t, i) {
                return DataGridCheckBoxRenderer(n, t, i)
            },
            onClick: DataGridCheckBoxClickHandler,
            onHeaderClick: o
        }, {
            title: "",
            dataField: "withCreate",
            width: 75,
            headerRenderer: function() {
                return i.length ? '<div style="cursor:default"><div style="float:left;width:20px">' + DataGridCheckBoxRenderer([
                    [f]
                ], 0, {
                    dataField: 0
                }) + "<\/div>Create<\/div>" : "Create"
            },
            renderer: function(n, t, i) {
                return DataGridCheckBoxRenderer(n, t, i)
            },
            onClick: DataGridCheckBoxClickHandler,
            onHeaderClick: o
        }, {
            title: "",
            dataField: "withGrants",
            width: 75,
            headerRenderer: function() {
                return i.length && i.map(function(n) {
                    if (!n.withDrop || n.withCreate) return !0
                }).length ? '<div style="cursor:default"><div style="float:left;width:20px">' + DataGridCheckBoxRenderer([
                    [e]
                ], 0, {
                    dataField: 0
                }) + "<\/div>Grants<\/div>" : "Grants"
            },
            renderer: function(n, t, i) {
                if (!n[t].withDrop || n[t].withCreate) return DataGridCheckBoxRenderer(n, t, i)
            },
            onClick: DataGridCheckBoxClickHandler,
            onHeaderClick: o
        }, {
            title: "User",
            dataField: "user",
            width: 137
        }, {
            title: "Host",
            dataField: "host",
            width: 137
        }]), t._addToDeathList(r), t.updateButtons(), t.loadUsers()
    }, t.loadUsers = function() {
        n.sendQuery("SELECT `user`,`host` FROM `mysql`.`user`", function(n) {
            var o = [];
            n.data.map(function(n) {
                o.push({
                    withDrop: u,
                    withCreate: f,
                    withGrants: e,
                    user: n[0],
                    host: n[1]
                })
            }), r.setData(i = o), t.updateButtons()
        }, null, 0, !1, !1, function(n) {
            if (n.error.search(/select command denied/i) > -1) return Alert(RES.user_select_denied, "Notice"), !0
        })
    }, t.updateButtons = function() {
        var n = 0,
            o = 0,
            s = 0,
            h;
        i.map(function(t) {
            t.withDrop && n++, t.withCreate && o++, t.withGrants && s++
        }), u = n == i.length, f = o == i.length, e = s == i.length, r.createHeaders(), r.refreshData(!0), h = !n && !o && !s, DisableElem(t._("btnWork1"), h), DisableElem(t._("btnWork2"), h)
    }, t.work = function(t) {
        n.sendReq("data.php", {
            action: "plugin",
            plugin: "export_users",
            users: i,
            cid: n.cid,
            to_file: t
        }, function(n) {
            n.file ? DownloadFile(n.file, n.alias) : n.result && SetClipboard(n.result)
        }, function(n) {
            Alert(n)
        })
    }, t.close = function() {
        CloseWindow(t)
    }, t
}

function FillerUserManager(n) {
    function b(t) {
        l = {
            host: [],
            database: [],
            table: [],
            procedure: []
        }, n.sendQuery("SHOW PRIVILEGES", function(n) {
            var i = l;
            n.data.map(function(n) {
                if (!/grant|proxy|usage/i.test(n[0])) {
                    var t = n[0].toUpperCase();
                    i.host.push(t), /server/i.test(n[1]) && t != "EVENT" || i.database.push(t), /tables/i.test(n[1]) && i.table.push(t), /procedures/i.test(n[1]) && i.procedure.push(t)
                }
            }), i.host.push("GRANT"), i.database.push("GRANT"), i.table.push("GRANT"), i.procedure.push("GRANT"), i["function"] = i.procedure, t && t()
        })
    }

    function e() {
        var n = i.selectedItem;
        v = n && (h.length || n._changed || n.temp), DisableElem(t.$("btnDel"), !n), DisableElem(t.$("btnClone"), !n || v), DisableElem(t.$("btnAddDB"), !n), DisableElem(t.$("btnRefresh"), !n || n.temp), DisableElem(t.$("btnSave"), !n || !v), n && !n.temp ? t.show() : t.hide()
    }

    function c(n, i, r, f) {
        var v = [],
            e = l[n],
            c = u.length,
            h, o, a, s;
        for (r[0] == "ALL PRIVILEGES" && (r = e.slice(0, e.length - (r[1] == "GRANT" ? 0 : 1))), h = 0; h < e.length; h++) o = e[h], v.push('<div style="min-width:170px;float:left;line-height:18px"><label' + (o == "GRANT" ? ' style="color:#cc2222"' : "") + '><input type="checkbox" ' + (r.contains(o) ? 'checked="checked" ' : "") + 'onclick="' + t._var + ".checkGrant(" + c + ",'" + o + "', this.checked)\" />" + o.replace(/temporary/i, "TEMP") + "<\/label><\/div>");
        return a = t._("grantChkAll" + c + "_"), s = {
            label: '<label><input id="' + a + '" type="checkbox" onclick="if(' + t._var + ".checkAllGrants(" + c + ',this.checked))StopPropagation(event)"' + (r.length == e.length ? 'checked="checked"' : "") + "  />" + (n == "host" ? "Global Privileges" : n.capitalize() + ": " + (n == "database" ? i.replace(/\.\*$/, "") : i)) + "<\/label>",
            obj: i,
            type: n,
            grants: f ? [] : r,
            add: f ? r : [],
            del: [],
            allChkId: a,
            content: v.join("\n") + '<div style="clear:both"><\/div>'
        }, f && (s._open = s._temp = !0), u.push(s), s
    }

    function y() {
        u.length == 1 && (u[0]._open = !0), o.create(u)
    }

    function w(n) {
        $$(n.allChkId).checked = n.grants.length + n.add.length - n.del.length - (n.add.contains("USAGE") ? 1 : 0) == l[n.type].length
    }

    function a() {
        var t = [],
            n = r,
            i = "'" + n[0] + "'" + (n[1] ? "@'" + n[1] + "'" : ""),
            o, f;
        n.temp ? t.push("CREATE USER " + i + (n[2] ? " IDENTIFIED BY " + (n[2].substr(0, 1) == "*" && n[2].length == 41 ? "PASSWORD " : "") + "'" + n[2] + "'" : "")) : (n.propChanged("0") || n.propChanged("1") ? t.push("RENAME USER " + s + " TO " + i) : i = s, n.propChanged("2") && (o = n[2].replace(/'/g, "''"), t.push("SET PASSWORD FOR " + i + (n[2].substr(0, 1) == "*" && n[2].length == 41 ? " = '" + o + "'" : " = PASSWORD('" + o + "')")))), u.map(function(n) {
            var u = ["table", "function", "procedure"].contains(n.type) ? n.type.toUpperCase() + " " : "",
                r, f;
            n._temp || (r = n.del.slice(0), r.length && (r.removeAll("GRANT") && r.push("GRANT OPTION"), t.push("REVOKE " + r.join(", ") + " ON " + u + n.obj + " FROM " + i))), r = n.add.slice(0), r.length && (f = r.removeAll("GRANT"), t.push("GRANT " + (r.length ? r.join(", ") : "USAGE") + " ON " + u + n.obj + " TO " + i + (f ? " WITH GRANT OPTION" : "")))
        }), f = [], n.propChanged("3") && f.push("MAX_QUERIES_PER_HOUR " + n[3]), n.propChanged("4") && f.push("MAX_UPDATES_PER_HOUR " + n[4]), n.propChanged("5") && f.push("MAX_CONNECTIONS_PER_HOUR " + n[5]), n.propChanged("6") && f.push("MAX_USER_CONNECTIONS " + n[6]), f.length && t.push("GRANT USAGE ON *.* TO " + i + " WITH " + f.join(" ")), h = t, e()
    }

    function p(n, u) {
        if (v) return YesNoDialog("Current user account has been changed. Save it first?", function() {
            t.save(n, u)
        }, function() {
            r.temp ? (f.removeAll(r), i.refreshData()) : (r.undoChanges(), r.unwatchChanges(), i.refreshRow()), h.length = 0, e(), n && n()
        }, !0), !0
    }
    var t = new FillerBase(n),
        i, o, l, f = [],
        u = [],
        r, s, h = [],
        v;
    return t.label = "User Manager:" + n.name, t.fill = function(r) {
        t.__fill(r, [540]).innerHTML = '<div class="buttons" data-sticky="0,0,5,">\t<button id="' + t._("btnAdd") + '" onclick="' + t._var + '.addUser()" style="background-image:url(' + IMG_USER_ADD + ')">Add User<\/button>\t<button id="' + t._("btnClone") + '" onclick="' + t._var + '.cloneUser()" style="background-image:url(' + IMG_USER_GO + ')">Clone User<\/button>\t<button id="' + t._("btnDel") + '" onclick="' + t._var + '.delUser()" style="background-image:url(' + IMG_USER_DELETE + ')">Delete User<\/button>\t<button onclick="' + t._var + '.openExport()" style="background-image:url(' + IMG_GROUP_GO + ');margin-left:20px">Export Users<\/button><\/div><div id="' + t._("phGrid1") + '" data-sticky="0,,40,:730,160"><\/div><div class="buttons" data-sticky="0,0,205,">\t<button id="' + t._("btnRefresh") + '" onclick="' + t._var + '.handleUserSelect()" style="background-image:url(' + IMG_REFRESH + ')">Reload User\'s Grants<\/button>\t<button id="' + t._("btnAddDB") + '" onclick="' + t._var + '.addDB()" style="background-image:url(' + IMG_DATABASE_ADD + ')">Add Database (wildcards)<\/button>\t<span style="position:relative;top:2px;left:20px"><img src="' + IMG_INFO + '" style="vertical-align:-3px" /> To add an object, drag it from the tree into the area bellow<\/span><\/div><div id="' + t._("phGrant") + '" data-sticky="0,,240,0:730" data-dropzone="1" class="border"><\/div>', i = new DataGrid(t.$("phGrid1"), {
            selectable: !0,
            scrollbars: "vertical",
            scrollToView: "vertical",
            onSelect: t.handleUserSelect,
            onEditBeginning: function(n) {
                var t = n.editedDataField;
                if (n.editedRecord._deleted || t == "lenOrValues" && n.editedValue === null || (t == "charset" || t == "collation") && !n.editedRecord.withCharset) return !1
            },
            onEditSave: function(t, i) {
                var u = t.editedRecord,
                    r = t.editedDataField,
                    f = t.editedRowIndex;
                if (r) {
                    if (i = "" + i.trim(), r == "0" && !i) return;
                    r != "1" || i || (i = "%"), r == "2" && i && n.sendQuery("SELECT PASSWORD('" + i.replace(/'/g, "''") + "')", function(n) {
                        u._set(r, n.data[0][0]), t.refreshRow(f)
                    }), u._set(r, i)
                }
                a(), e()
            }
        }), i.create([{
            title: "Name",
            dataField: "0",
            width: 120,
            editable: !0,
            maxLength: 16
        }, {
            title: "Host",
            dataField: "1",
            width: 120,
            editable: !0,
            maxLength: 60
        }, {
            title: "Password",
            dataField: "2",
            width: 115,
            editable: !0,
            renderer: function(n, t) {
                return n[t][2] ? n[t][2] : '<div style="color:red">No Password<\/div>'
            }
        }, {
            title: "Queries/Hour",
            dataField: "3",
            width: 90,
            editable: !0,
            align: "right",
            editor: new ClassFactory(DataGridNumberEditor, i, 0)
        }, {
            title: "Updates/Hour",
            dataField: "4",
            width: 90,
            editable: !0,
            align: "right",
            editor: new ClassFactory(DataGridNumberEditor, i, 0)
        }, {
            title: "Conns/Hour",
            dataField: "5",
            width: 85,
            editable: !0,
            align: "right",
            editor: new ClassFactory(DataGridNumberEditor, i, 0)
        }, {
            title: "Simul.Conns",
            dataField: "6",
            width: 90,
            editable: !0,
            align: "right",
            editor: new ClassFactory(DataGridNumberEditor, i, 0)
        }]), o = new ListContainer(t.$("phGrant")), t._addToDeathList([i, o]), e(), b(t.loadUsers)
    }, t.openExport = function() {
        OpenWindow(FillerExportUsers, n)
    }, t.loadUsers = function(t) {
        n.sendQuery("SELECT `user`,`host`,`password`,`max_questions`,`max_updates`,`max_connections`,`max_user_connections` FROM `mysql`.`user`", function(n) {
            i.setData(f = n.data), e(), t && t()
        }, null, 0, !1, !1, function(n) {
            return t && t(), n.error.search(/select command denied/i) > -1 ? (Alert(RES.user_select_denied, "Notice"), !0) : void 0
        })
    }, t.handleUserSelect = function(f) {
        if (p(function() {
            i.selectItem(f), t.handleUserSelect(f)
        }, r != f)) {
            i.selectItem(r);
            return
        }(f || (f = i.selectedItem), r = f, s = "'" + f[0] + "'" + (f[1] ? "@'" + f[1] + "'" : ""), f.watchChanges(), h.length = 0, u = [], f.temp && c("host", "*.*", ["USAGE"], !0), y(), e(), f.temp) || n.sendQuery("SHOW GRANTS FOR " + s, function(n) {
            var t = /GRANT (.+?) ON( PROCEDURE| FUNCTION)* (.+?) TO '/i;
            n.data.map(function(n) {
                var u = n[0].match(t),
                    e;
                if (u) {
                    var i = u[3],
                        f = u[2],
                        r = u[1].toUpperCase().replace(/, /g, ",").split(",");
                    if (r.removeAll("USAGE"), r.removeAll("PROXY"), n[0].indexOf("WITH GRANT OPTION") > -1 && r.push("GRANT"), i == "*.*") {
                        c("host", i, r);
                        return
                    }
                    e = i.split("`.`"), u = i.replace(/\.\*$/, ""), e.length == 1 ? c("database", i, r) : e.length == 2 ? f ? (f = f.trim().toLowerCase(), c(f, i, r)) : c("table", i, r) : e.length == 3 && c("column", i, r)
                }
            }), y(), i.focus(1)
        })
    }, t.checkAllGrants = function(n, i) {
        var f, r;
        for (l[u[n].type].map(function(r) {
            t.checkGrant(n, r, i)
        }), f = o.getContentElem(n).getElementsByTagName("input"), r = 0; r < f.length; r++) f[r].checked = i ? !0 : !1;
        return w(u[n]), a(), o.isOpen(n)
    }, t.checkGrant = function(n, t, i, r) {
        var f = u[n],
            e = f.grants.contains(t);
        f.add.removeAll(t), f.del.removeAll(t), e && !i ? f.del.push(t) : !e && i && f.add.push(t), r || (w(f), a())
    }, t.addUser = function() {
        if (!p(t.addUser)) {
            var n = {
                "0": GetNewName("new_user_", f, "0"),
                "1": "localhost",
                "2": "",
                "3": 0,
                "4": 0,
                "5": 0,
                "6": 0,
                temp: !0
            };
            f.push(n), i.refreshData(), i.selectItem(n), t.handleUserSelect(n), a(), e()
        }
    }, t.cloneUser = function() {
        n.sendQuery("SHOW GRANTS FOR " + s, function(r) {
            var u = [],
                e = GetNewName("clone_", f, "0");
            r.data.map(function(n) {
                u.push(n[0].replace(/'.+?'@('.+?')/, "'" + e + "'@$1"))
            }), n.sendQuery(u, function() {
                t.loadUsers(function() {
                    for (var n = 0; n < f.length; n++)
                        if (f[n][0] == e) {
                            i.selectItem(f[n]), i.scrollRowToView(n, !0), t.handleUserSelect(f[n]);
                            break
                        }
                })
            })
        })
    }, t.delUser = function() {
        YesNoDialog("Delete user " + s + "?", function() {
            if (r.temp) {
                f.removeAll(r), i.refreshData(), o.clear(), e();
                return
            }
            n.sendQuery(["REVOKE ALL PRIVILEGES, GRANT OPTION FROM " + s, "DROP USER " + s], function() {
                t.loadUsers(), o.clear(), e()
            })
        })
    }, t.addDB = function() {
        Confirm("Database name with wildcards (% and _)", "Enter DB Name", "", function(n) {
            (n = n.trim()) && t.addObj({
                getFullName: function() {
                    return "`" + n.replace(/`/g, "") + "`"
                },
                objType: "database"
            })
        })
    }, t.addObj = function(n) {
        var t, i, r, f;
        if (n) {
            if (t = n.getFullName(), n.objType == "database" && (t = t.replace(/_/g, "\\_").replace(/%/g, "\\%") + ".*"), i = u.findByProp("obj", t), i > -1) {
                o.isOpen(i) || o.open(i);
                return
            }
            r = n.objType == "table" || n.objType == "database" ? "SELECT" : "EXECUTE", f = c(n.objType, t, [r], !0), a(), y()
        }
    }, t.save = function(i, u) {
        if (!h.length) {
            i && i();
            return
        }
        n.sendQuery(["USE `mysql`"].concat(h), function() {
            h.length = 0, r.unwatchChanges(), delete r.temp, e(), u || t.handleUserSelect(r), i && i()
        })
    }, t.show = function() {
        if (r) {
            var n = t.$("phGrant");
            TREE.enableDrag(["database", "table", "procedure", "function"], function() {
                n.style.border = "2px dashed red", ValidateLayout(n)
            }, function(i) {
                n.style.border = "1px solid #adadad", ValidateLayout(n), i == t.$("phGrant") && t.addObj(TREE.selectedItem)
            })
        }
    }, t.hide = function() {
        TREE.disableDrag()
    }, t.canClose = function() {
        return !0
    }, t.close = function() {
        p(function() {
            CloseWindow(t)
        }, !0) || (TREE.disableDrag(), CloseWindow(t))
    }, t
}

function FillerProc(n, t) {
    function u() {
        var f = n.params.map(function(n) {
                if (n.temp || n._changed) return !0
            }),
            u = !n.name || !n._changed && f.length == 0,
            t;
        DisableElem(i._("btnSave"), u), DisableElem(i._("btnLaunch"), n.temp || !u), t = r.selectedItem, DisableElem(i._("btnParamDel"), !t), i.$("btnParamDel").innerHTML = (t && t._deleted ? "Restore" : "Delete") + " Param", DisableElem(i._("btnParamUp"), !t || r.selectedIndex == 0, .5), DisableElem(i._("btnParamDown"), !t || r.selectedIndex >= n.params.length - 1, .5)
    }

    function h() {
        r.setData(n.params), e.fill(n.code), s.selectLabel(n.definer), o(), u(), e.focus()
    }

    function o(t) {
        n.params.map(function(n, i) {
            t ? n._set("_index", i) : n._index = i
        })
    }

    function c() {
        var u, r, t, i;
        for (n.launchValues = [], u = [(n.objType == "function" ? "SELECT" : "CALL") + " `" + n.name + "`("], r = [], t = 0; t < f.length; t++) {
            if (i = f[t], i === null) {
                n.launchValues[t] = null, r.push("NULL");
                continue
            }
            n.launchValues[t] = i.value, r.push(i.tagName ? "'" + i.value.trim().replace(/\'/g, "\\'") + "'" : i.value)
        }
        f = null, u.push(r.join(",")), OpenWindow(FillerQuery, n.getDB(), {
            query: u.join("") + ")",
            forceRun: !0
        }, !0)
    }
    var i = new FillerBase(n),
        r, e, s, f = [];
    return i.getLabel = function() {
        return "Proc: " + n.name
    }, i.fill = function(f, o) {
        var c, l;
        if (!n.temp && !o) {
            n.load(function() {
                i.fill(f, !0), ValidateLayout(f)
            });
            return
        }
        c = new TabNav(i.__fill(f, [540]), [{
            label: "Editor",
            fill: function(t) {
                var r = n.objType == "function",
                    f = '<div class="buttons" data-sticky="285,,10,">\t<button onclick="' + i._var + '.addParam()" style="background-image:url(' + IMG_ADD + ')">Add Param<\/button>\t<button id="' + i._("btnParamDel") + '" onclick="' + i._var + '.delParam()" style="width:115px;background-image:url(' + IMG_DELETE + ')">Delete Param<\/button>\t<button id="' + i._("btnParamUp") + '" class="roundButton" style="margin-left:5px;background-image:url(' + IMG_UP + ')" onclick="' + i._var + '.moveParamRow(1)"><\/button>\t<button id="' + i._("btnParamDown") + '" class="roundButton" style="background-image:url(' + IMG_DOWN + ')" onclick="' + i._var + '.moveParamRow(0)"><\/button>\t<button id="' + i._("btnLaunch") + '" onclick="' + i._var + '.launch()" style="margin-left:80px;width:70px;background-image:url(' + IMG_PLAY + ')">Run<\/button><\/div><div id="' + i._("phGrid") + '" data-sticky="286,,50,:440,' + (r ? 91 : 129) + '"><\/div><table data-sticky="10,,10," cellpadding="5"><tr><td>Name<\/td><td><input id="' + i._("txtProcName") + '" type="text" style="width:165px" onkeyup="' + i._var + '.setName()" oncut="' + i._var + '.setName()" onpaste="' + i._var + '.setName()" /><\/td><\/tr><tr><td>Type<\/td><td id="' + i._("phCmbType") + '"><\/td><\/tr><tr><td>Data Access<\/td><td id="' + i._("phCmbAccess") + '"><\/td><\/tr><tr><td>Security<\/td><td id="' + i._("phCmbSecurity") + '"><\/td><\/tr><tr><td>Definer<\/td><td id="' + i._("phCmbDefiner") + '"><\/td><\/tr><\/table><div id="' + i._("phCode") + '" data-sticky="5,5,190,5"><\/div>';
                r && (f += '<table data-sticky="285,,149," cellpadding="5"><tr><td>Return Column<\/td><td><input id="' + i._("txtRetCol") + '" type="text" style="width:300px" onkeyup="' + i._var + '.setRetCol()" oncut="' + i._var + '.setRetCol()" onpaste="' + i._var + '.setRetCol()" /><\/td><\/tr><\/table>'), t.innerHTML = f, ValidateLayout(t);
                var c = n.getHost(),
                    e = new Combo(i.$("phCmbType"), [{
                        label: "NOT DETERMINISTIC",
                        tooltip: "Does not always produce the same result for the same input parameters. (Default)"
                    }, {
                        label: "DETERMINISTIC",
                        tooltip: "Always produce the same result for the same input parameters."
                    }], 170, n.deterministic, function(t) {
                        n._set("deterministic", t.label), u()
                    }),
                    o = new Combo(i.$("phCmbAccess"), [{
                        label: "CONTAINS SQL",
                        tooltip: "Indicates that the routine does not contain statements that read or write data. (Default)"
                    }, {
                        label: "NO SQL",
                        tooltip: "Indicates that the routine contains no SQL statements."
                    }, {
                        label: "READS SQL DATA",
                        tooltip: "Indicates that the routine contains statements that read data (for example, SELECT), but not statements that write data."
                    }, {
                        label: "MODIFIES SQL DATA",
                        tooltip: "Indicates that the routine contains statements that write data (for example, INSERT or DELETE)."
                    }], 170, n.dataAccess, function(t) {
                        n._set("dataAccess", t.label), u()
                    }),
                    h = new Combo(i.$("phCmbSecurity"), [{
                        label: "DEFINER",
                        tooltip: "Use definer's account when checking access privileges for the view when a statement is executed that references the procedure/function. (Default)"
                    }, {
                        label: "INVOKER",
                        tooltip: "Use invoker's account when checking access privileges for the view when a statement is executed that references the procedure/function."
                    }], 170, n.sqlSecurity, function(t) {
                        n._set("sqlSecurity", t.label), u()
                    });
                s = CreateDefinersCombo(i._("phCmbDefiner"), 170, n, function(t) {
                    n._set("definer", t.label), u()
                }), r && (i.$("txtRetCol").value = n.returnColumn), i.$("txtProcName").value = n.name, i._addToDeathList([e, o, h, s])
            }
        }, new DDLTab(n)], function() {}), c.selectIndex(0), r = new DataGrid(i.$("phGrid"), {
            minColumnWidth: 50,
            selectable: !0,
            resizable: !1,
            editable: !0,
            scrollbars: "vertical",
            scrollToView: "vertical",
            onSelect: function() {
                u()
            },
            onEditBeginning: function(n) {
                if (n.selectedItem._deleted) return !1
            },
            onEditSave: function(n, t) {
                n.editedRecord._set(n.editedDataField, t), u()
            }
        }), l = n.objType == "function" ? [{
            title: "Argument",
            dataField: "name",
            width: 160,
            editable: !0
        }, {
            title: "Data Type",
            dataField: "type",
            width: 280,
            editable: !0
        }] : [{
            title: "Argument",
            dataField: "name",
            width: 160,
            editable: !0
        }, {
            title: "Type",
            dataField: "direction",
            width: 45,
            editable: !0,
            editor: new ClassFactory(DataGridSelectEditor, r, Labelize("IN", "OUT", "INOUT"))
        }, {
            title: "Data Type",
            dataField: "type",
            width: 240,
            editable: !0
        }], r.create(l), e = new CodeEditor(i.$("phCode"), {
            onChange: function() {
                n._set("code", e.getValue()), u()
            }
        }), i._addToDeathList([r, c, e]), h(), t && i.launch()
    }, i.setName = function() {
        n._set("name", i.$("txtProcName").value), u()
    }, i.setRetCol = function() {
        n._set("returnColumn", i.$("txtRetCol").value), u()
    }, i.addParam = function() {
        var t = {
            name: GetNewName("param_", n.params),
            direction: "IN",
            type: "INT",
            temp: !0
        };
        n.params.push(t), r.refreshData(), r.selectItem(t), o(), u()
    }, i.delParam = function() {
        var t = r.selectedItem;
        n.temp || t.temp ? (n.params._splice(r.selectedIndex, 1), t = null) : t._deleted ? t._delete("_deleted") : t._set("_deleted", !0), r.refreshData(), t && r.selectItem(t), o(), u()
    }, i.moveParamRow = function(n) {
        var t = r.moveRow(n);
        t && o(!t.temp && !r.selectedItem.temp), u()
    }, i.launch = function() {
        var i, t;
        if (!n.params.length) {
            c();
            return
        }
        i = ['<table cellpadding="5">'], n.params.map(function(t, r) {
            var u = n.launchValues[r];
            i.push('<tr><td style="text-align:right">' + (r + 1) + ".<\/td><td>" + t.name + '<\/td><td id="phRunArg' + r + '"><\/td><td style="width:90px">\t<label><input id="chkRunArg' + r + '" type="checkbox" ' + (u === null || u === undefined ? 'checked="checked"' : "") + ' onclick="" />NULL<\/label><\/td><\/tr>')
        }), t = new Dialog, t.show(i.join("") + "<\/table>", [{
            label: "Run",
            img: IMG_ACCEPT,
            action: function() {
                for (var n = 0; n < f.length; n++) $$("chkRunArg" + n).checked && (f[n] = null);
                t.close(), c()
            }
        }, {
            label: "Cancel",
            action: function() {
                t.close(), f = null
            },
            img: IMG_CANCEL,
            onEscape: 1
        }], "Run " + n.objType.capitalize(), 800, 485), f = [], n.params.map(function(t, i) {
            var r;
            /tinyint|smallint|mediumint|int|bigint|real|float|double|decimal|dec|numeric|fixed|serial/i.test(t.type) ? (r = new NumInput($$("phRunArg" + i), n.launchValues[i] || 0, 100, function() {
                $$("chkRunArg" + i).checked = ""
            }), r.allowDot = !0, f.push(r)) : (r = "txtArg" + i, $$("phRunArg" + i).innerHTML = '<input id="' + r + '" type="text" style="width:200px" onkeypress="$$(\'chkRunArg' + i + "').checked=''\" onpaste=\"$$('chkRunArg" + i + "').checked=''\"/>", $$(r).value = n.launchValues[i] || "", f.push($$(r)))
        })
    }, i.save = function(t) {
        n.save(function() {
            h(), t && t()
        })
    }, i.close = function() {
        n.temp && n.getDB().drop(n), CloseWindow(i)
    }, i
}

function FillerTrigger(n) {
    function i() {
        DisableElem(t._("btnSave"), !n._changed || !n.name.trim() || !n.table)
    }
    var t = new FillerBase(n),
        r;
    return t.getLabel = function() {
        return "Trigger: " + n.name
    }, t.setName = function() {
        n._set("name", t.$("txtTrgName").value), i()
    }, t.fill = function(u) {
        var f = new TabNav(t.__fill(u, []), [{
            label: "Editor",
            fill: function(u) {
                u.innerHTML = '<table data-sticky="10,,10," cellpadding="5"><tr><td>Name<\/td><td><input id="' + t._("txtTrgName") + '" type="text" style="width:220px" onkeyup="' + t._var + '.setName()" onpaste="' + t._var + '.setName()" oncut="' + t._var + '.setName()" /><\/td><td>&nbsp;&nbsp;&nbsp;Definer<\/td><td id="' + t._("phDefiner") + '" colspan="3"><\/td><\/tr><tr><td>Table<\/td><td id="' + t._("phTable") + '"><\/td><td>&nbsp;&nbsp;&nbsp;Timing<\/td><td id="' + t._("phTiming") + '"><\/td><td>&nbsp;&nbsp;&nbsp;Event<\/td><td id="' + t._("phEvent") + '"><\/td><\/tr><\/table><div id="' + t._("phCode") + '" data-sticky="5,5,90,5"><\/div>', ValidateLayout(u);
                var f = new Combo(t.$("phTable"), function() {
                        return n.getDB().tables
                    }, 224, n.table, function(t) {
                        n._set("table", t.name), i()
                    }),
                    e = new Combo(t.$("phTiming"), [{
                        label: "BEFORE"
                    }, {
                        label: "AFTER"
                    }], 120, n.timing, function(t) {
                        n._set("timing", t.label), i()
                    }),
                    o = new Combo(t.$("phEvent"), [{
                        label: "INSERT"
                    }, {
                        label: "UPDATE"
                    }, {
                        label: "DELETE"
                    }], 120, n.action, function(t) {
                        n._set("action", t.label), i()
                    }),
                    s = CreateDefinersCombo(t._("phDefiner"), 200, n, function(t) {
                        n._set("definer", t.label), i()
                    });
                r = new CodeEditor(t.$("phCode"), {
                    onChange: function() {
                        n._set("code", r.getValue()), i()
                    }
                }), r.fill(n.code), t.$("txtTrgName").value = n.name, t._addToDeathList([f, e, o, s, r])
            }
        }, new DDLTab(n)], function() {});
        f.selectIndex(0), t._addToDeathList(f)
    }, t.save = function(r) {
        n.save(function() {
            i(), t.updateLabels(), r && r()
        })
    }, t.close = function() {
        n.temp && n.getDB().drop(n), CloseWindow(t)
    }, i(), t
}

function FillerView(n) {
    function r() {
        DisableElem(t._("btnSave"), !n._changed)
    }
    var t = new FillerBase(n),
        i, u, f = !1;
    return t.addSubjectEventListener("labelChanged", function() {
        t.$("phViewName").innerHTML = n.name
    }), t.getLabel = function() {
        return "View: " + n.name
    }, t.fill = function(e, o) {
        if (!n.temp && !o) {
            n.load(function() {
                t.fill(e, !0), ValidateLayout(e)
            });
            return
        }
        var s = new TabNav(t.__fill(e, []), [{
            label: "Data",
            extraSpace: 5,
            fill: function(i) {
                u = new FillerQuery(n), u.fill(i), t._addToDeathList(u)
            }
        }, {
            label: "Editor",
            fill: function(u) {
                u.innerHTML = '<table data-sticky="10,,5," cellpadding="5"><tr><td>Name<\/td><td style="white-space:nowrap" colspan="3">\t<b id="' + t._("phViewName") + '">' + n.name + '<\/b>\t<div class="buttons" style="display:inline">&nbsp;&nbsp;&nbsp;\t\t<button style="background-image:url(' + IMG_RENAME + ')" onclick="' + t._var + '.subject.rename()">Rename<\/button>\t<\/div><\/td><\/tr><tr><td>Algorithm<\/td><td id="' + t._("phCmbAlgo") + '"><\/td><td>&nbsp;&nbsp;&nbsp;Check Option<\/td><td id="' + t._("phCmbChkOpt") + '"><\/td><\/tr><tr><td>Security<\/td><td id="' + t._("phCmbSecurity") + '"><\/td><td>&nbsp;&nbsp;&nbsp;Definer<\/td><td id="' + t._("phCmbDefiner") + '"><\/td><\/tr><\/table><div id="' + t._("phCode") + '" data-sticky="5,5,115,5"><\/div>', ValidateLayout(u);
                var h = n.getHost(),
                    f = new Combo(t.$("phCmbAlgo"), [{
                        label: "UNDEFINED",
                        tooltip: "MySQL chooses which algorithm to use. It prefers MERGE over TEMPTABLE if possible, because MERGE is usually more efficient and because a view cannot be updatable if a temporary table is used. (Default)"
                    }, {
                        label: "MERGE",
                        tooltip: "The text of a statement that refers to the view and the view definition are merged such that parts of the view definition replace corresponding parts of the statement."
                    }, {
                        label: "TEMPTABLE",
                        tooltip: "Locks can be released on underlying tables after the temporary table has been created and before it is used to finish processing the statement. This might result in quicker lock release than the MERGE algorithm so that other clients that use the view are not blocked as long."
                    }], 130, n.algorithm, function(t) {
                        n._set("algorithm", t.label), r()
                    }),
                    e = new Combo(t.$("phCmbChkOpt"), [{
                        label: "NONE",
                        tooltip: "No CHECK OPTION flag. (Default)"
                    }, {
                        label: "CASCADED",
                        tooltip: "When updating records, causes the checks for underlying views to be evaluated as well."
                    }, {
                        label: "LOCAL",
                        tooltip: "When updating records, restricts the CHECK OPTION only to the view being defined."
                    }], 130, n.checkOption, function(t) {
                        n._set("checkOption", t.label), r()
                    }),
                    o = new Combo(t.$("phCmbSecurity"), [{
                        label: "DEFINER",
                        tooltip: "Use definer's account when checking access privileges for the view when a statement is executed that references the procedure/function. (Default)"
                    }, {
                        label: "INVOKER",
                        tooltip: "Use invoker's account when checking access privileges for the view when a statement is executed that references the procedure/function."
                    }], 130, n.sqlSecurity, function(t) {
                        n._set("sqlSecurity", t.label), r()
                    }),
                    s = CreateDefinersCombo(t._("phCmbDefiner"), 200, n, function(t) {
                        n._set("definer", t.label), r()
                    });
                i = new CodeEditor(t.$("phCode"), {
                    onChange: function() {
                        n._set("code", i.getValue()), r()
                    }
                }), i.fill(n.code), t._addToDeathList([f, e, o, s])
            }
        }, new DDLTab(n)], function(t, i) {
            i != 0 || f || n.temp || (u.refresh(null), f = !0)
        });
        s.selectIndex(n.temp || APP.tableAction == 0 ? 1 : 0), t._addToDeathList([s, i])
    }, t.save = function(t) {
        n.save(function() {
            n.load(function() {
                i.fill(n.code), i.focus(), t && t()
            }), r()
        })
    }, t.close = function() {
        n.temp && n.getDB().drop(n), CloseWindow(t)
    }, t
}

function FillerDatabase(n) {
    function i() {
        DisableElem(t._("btnSave"), !n.checkChanged())
    }
    var t = new FillerBase(n);
    return t.getLabel = function() {
        return "DB: " + n.name
    }, t.fill = function(r) {
        var u = new TabNav(t.__fill(r, []), [{
            label: "Properties",
            fill: function(r) {
                r.innerHTML = '<table data-sticky="10,,15," cellpadding="5"><tr><td>Default Charset<\/td><td id="' + t._("phCmbCharset") + '"><\/td><\/tr><tr><td>Default Collation<\/td><td id="' + t._("phCmbCollation") + '"><\/td><\/tr><\/table>', ValidateLayout(r);
                var u = n.getHost(),
                    e = new Combo(t.$("phCmbCharset"), [{
                        label: "Default",
                        defCollation: {
                            label: ""
                        }
                    }].concat(u.charsets), 150, n.charset, function(t) {
                        n._set("charset", t.label == "Default" ? "" : t.label), n._set("collation", t.defCollation.label), f.setData(t.collations, t.defCollation.label), i()
                    }),
                    f = new Combo(t.$("phCmbCollation"), u.getCollations(n.charset), 150, n.collation, function(t) {
                        n._set("collation", t.label), i()
                    }, "Default");
                t._addToDeathList([e, f])
            }
        }, new DDLTab(n)], function() {});
        u.selectIndex(0), t._addToDeathList(u)
    }, t.save = function() {
        n.save(function() {
            CloseWindow(t)
        })
    }, t.close = function() {
        n.undoChanges(), CloseWindow(t)
    }, t
}

function FillerDatabaseInfo(n) {
    var t = new FillerBase(n),
        i;
    return t.getLabel = function() {
        return "Details: " + n.name
    }, t.fill = function(r) {
        r.innerHTML = '<div class="buttons" data-sticky="5,,5,">\t<button style="background-image:url(' + IMG_REFRESH + ')" onclick="' + t._var + '.refresh()">Refresh<\/button><\/div><div id="' + t._("phGrid") + '" data-sticky="0,0,39,0"><\/div>', i = new DataGrid(t.$("phGrid"), {
            selectable: !0,
            onRowDoubleClick: function(t) {
                var i = n.getChild(t[0], t[1]);
                i && (TREE.foldUnfold(n, !0), TREE.foldUnfold(n.getGroupByObjType(t[0]), !0), TREE.selectItem(i))
            }
        });
        var u = [{
            title: "Obj Type",
            dataField: "0",
            width: 75,
            selectable: !1,
            renderer: function(n, t) {
                var n = {
                    icon: {
                        table: IMG_TABLE,
                        view: IMG_VIEW,
                        event: IMG_EVENT,
                        proc: IMG_PROCEDURE,
                        func: IMG_FUNCTION,
                        trigger: IMG_TRIGGER
                    } [n[t][0]],
                    objType: n[t][0]
                };
                return GetIconWithLabel(n)
            }
        }, {
            title: "Name",
            dataField: "1",
            width: 170,
            selectable: !1
        }, {
            title: "Rows",
            dataField: "2",
            width: 100,
            selectable: !1,
            renderer: DataGridGaugeRenderer
        }, {
            title: "Size",
            dataField: "3",
            width: 100,
            selectable: !1,
            renderer: function(n, t, i) {
                return DataGridGaugeRenderer(n, t, i, " KB")
            }
        }, {
            title: "Created",
            dataField: "4",
            width: 130,
            selectable: !1
        }, {
            title: "Updated",
            dataField: "5",
            width: 130,
            selectable: !1
        }, {
            title: "Engine",
            dataField: "6",
            width: 100,
            selectable: !1
        }, {
            title: "Comment",
            dataField: "7",
            width: 250,
            selectable: !1
        }];
        i.create(u), t._addToDeathList(i), t.refresh()
    }, t.refresh = function() {
        var t = n.getHost(),
            r = ["SHOW TABLE STATUS FROM `" + n.name + "`"];
        r = r.concat(t.supportProcs ? ['SHOW FUNCTION STATUS WHERE `Db`="' + n.name + '"', 'SHOW PROCEDURE STATUS WHERE `Db`="' + n.name + '"'] : ["SELECT 1", "SELECT 1"]), r.push(t.supportTriggers ? "SHOW TRIGGERS FROM `" + n.name + "`" : "SELECT 1"), r.push(t.supportEvents ? "SHOW EVENTS FROM `" + n.name + "`" : "SELECT 1"), n.sendQuery(r.join(";"), function(n) {
            var u = [],
                f = [],
                r;
            n.selectResult(0), r = n.getDataFromFields(["Name", "Rows", "Data_length", "Create_time", "Update_time", "Engine"]), r.map(function(n) {
                n[2] && (n[2] = Number(n[2]) / 1e3), n.splice(0, 0, n[5] ? "table" : "view"), n[6] ? u.push(n) : f.push(n)
            }), u = u.concat(f), t.supportProcs && (n.selectResult(1), r = n.getDataFromFields(["Name", "", "", "Created", "Modified", "", "Comment"]), r.map(function(n) {
                n.splice(0, 0, "func")
            }), u = u.concat(r), n.selectResult(2), r = n.getDataFromFields(["Name", "", "", "Created", "Modified", "", "Comment"]), r.map(function(n) {
                n.splice(0, 0, "proc")
            }), u = u.concat(r)), t.supportTriggers && (n.selectResult(3), r = n.getDataFromFields(["Trigger", "", "", "Created", "", "", ""]), r.map(function(n) {
                n.splice(0, 0, "trigger")
            }), u = u.concat(r)), t.supportEvents && (n.selectResult(4), r = n.getDataFromFields(["Name", "", "", "", "", "", ""]), r.map(function(n) {
                n.splice(0, 0, "event")
            }), u = u.concat(r)), i.setData(u)
        })
    }, t.close = function() {
        CloseWindow(t)
    }, t
}

function FillerHostManagement(n, t) {
    function o() {
        DisableElem(i._("btnKill"), !r.selectedItem)
    }
    var i = new FillerBase(n),
        u, r, f, e, s;
    return i.getLabel = function() {
        return "Management: " + n.name
    }, i.fill = function(h) {
        u = new TabNav(i.__fill(h), [{
            label: "Process List",
            fill: function(n) {
                n.innerHTML = '<div class="buttons" data-sticky="5,,5,">\t<button style="background-image:url(' + IMG_REFRESH + ')" onclick="' + i._var + '.refresh(0)">Refresh<\/button>\t<button id="' + i._("btnKill") + '" style="background-image:url(' + IMG_DELETE + ')" onclick="' + i._var + '.killProcess()">Kill Process<\/button><\/div><label data-sticky="230,,10,"><input id="' + i._("chkFull") + '" type="checkbox" onclick="' + i._var + '.refresh(0)" checked="checked" />Limit the Info field to 100 characters<\/label><div id="' + i._("phGrid1") + '" data-sticky="0,0,39,0"><\/div>', r = new DataGrid(i.$("phGrid1"), {
                    selectable: !0,
                    onSelect: o
                });
                r.create([{
                    title: "Id",
                    dataField: "0",
                    width: 50,
                    selectable: !1
                }, {
                    title: "User",
                    dataField: "1",
                    width: 100,
                    selectable: !1
                }, {
                    title: "Host",
                    dataField: "2",
                    width: 120,
                    selectable: !1
                }, {
                    title: "Database",
                    dataField: "3",
                    width: 120,
                    selectable: !1
                }, {
                    title: "Command",
                    dataField: "4",
                    width: 150,
                    selectable: !1
                }, {
                    title: "Time",
                    dataField: "5",
                    width: 80,
                    selectable: !1
                }, {
                    title: "State",
                    dataField: "6",
                    width: 80,
                    selectable: !1
                }, {
                    title: "Info",
                    dataField: "7",
                    width: 200,
                    selectable: !1
                }]), i._addToDeathList(r)
            }
        }, {
            label: "System Variables",
            fill: function(t) {
                t.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button style="background-image:url(' + IMG_REFRESH + ')" onclick="' + i._var + '.refresh(1)">Refresh<\/button>\t<div data-sticky="100,,8,">\t\t<label><input id="' + i._("rdoMng") + '" name="' + i._("rdoMng") + '" tabindex="0" type="radio" checked="checked" onclick="' + i._var + '.refresh(1)" />Session<\/label>&nbsp;&nbsp;\t\t<label><input name="' + i._("rdoMng") + '" tabindex="0" type="radio" onclick="' + i._var + '.refresh(1)" />Global<\/label>\t<\/div><\/div><div id="' + i._("phGrid2") + '" data-sticky="0,0,39,0"><\/div>', f = new DataGrid(i.$("phGrid2"), {
                    selectable: !0,
                    onEditBeginning: function(n) {
                        s = n.editedValue
                    },
                    onEditSave: function(t, r) {
                        if (r != s) {
                            t.editedRecord[t.editedDataField] = r;
                            var f = "SET " + (i.$("rdoMng").checked ? "SESSION" : "GLOBAL") + " " + t.editedRecord[0] + "=?";
                            n.sendQuery(f, function(n) {
                                if (n.error) {
                                    Alert(n.error);
                                    return
                                }
                                i.refresh(u.selectedIndex)
                            }, [{
                                data: r,
                                type: isNaN(r) ? "s" : "i"
                            }])
                        }
                    }
                });
                f.create([{
                    title: "Name",
                    dataField: "0",
                    width: 250,
                    selectable: !1
                }, {
                    title: "Value",
                    dataField: "1",
                    width: 400,
                    selectable: !0
                }]), i._addToDeathList(f)
            }
        }, {
            label: "Status Information",
            fill: function(n) {
                n.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button style="background-image:url(' + IMG_REFRESH + ')" onclick="' + i._var + '.refresh(2)">Refresh<\/button>\t<div data-sticky="100,,8,">\t\t<label><input id="' + i._("rdoStat") + '" name="' + i._("rdoStat") + '" tabindex="0" type="radio" checked="checked" onclick="' + i._var + '.refresh(2)" />Session<\/label>&nbsp;&nbsp;\t\t<label><input name="' + i._("rdoStat") + '" tabindex="0" type="radio" onclick="' + i._var + '.refresh(2)" />Global<\/label>\t<\/div><\/div><div id="' + i._("phGrid3") + '" data-sticky="0,0,39,0"><\/div>', e = new DataGrid(i.$("phGrid3"), {
                    selectable: !0,
                    editable: !1
                });
                e.create([{
                    title: "Name",
                    dataField: "0",
                    width: 250,
                    selectable: !1
                }, {
                    title: "Value",
                    dataField: "1",
                    width: 400,
                    selectable: !1
                }]), i._addToDeathList(e)
            }
        }], function(n, t) {
            i.refresh(t)
        }), u.selectIndex(t), i._addToDeathList(u), o()
    }, i.reopen = function(n, t) {
        t !== undefined && u.selectIndex(t)
    }, i.refresh = function(t) {
        var h = [(i.$("chkFull").checked ? "" : "FULL ") + "PROCESSLIST", "VARIABLES", "STATUS"],
            c = [r, f, e],
            s = [null, i._("rdoMng"), i._("rdoStat")],
            u = h[t];
        s[t] && (u = ($$(s[t]).checked ? "SESSION " : "GLOBAL ") + u), n.sendQuery("SHOW " + u, function(n) {
            c[t].setData(n.getResult(0)), o()
        })
    }, i.killProcess = function() {
        var t = r.selectedItem[0];
        r.unselectAll(), o(), n.sendQuery("KILL " + t, function() {
            i.refresh(0), Alert("Connection has been killed.")
        })
    }, i.close = function() {
        CloseWindow(i)
    }, i
}

function DDLTab(n) {
    var t = Storage.store(this, "DDLTab"),
        i;
    t.label = "DDL", t.fill = function(n) {
        n.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button onclick="' + t._var + '.show()" style="background-image:url(' + IMG_REFRESH + ')">Refresh<\/button><\/div><div id="' + t._("phTblDDL") + '" data-sticky="5,5,40,5"><\/div>'
    }, t.show = function() {
        if (n.temp) {
            t.$("phTblDDL").innerHTML = '<div style="padding:10px">Code is available only for objects that exist in the database<\/div>';
            return
        }
        i || (i = new CodeEditor(t.$("phTblDDL"), {
            readOnly: !0
        })), n.showCreate(function(n) {
            i.fill(n)
        })
    }, t.destroy = function() {
        i && i.destroy(), Storage.dispose(t)
    }
}

function FillerBase(n) {
    var t = Storage.store(this, "FillerBase"),
        i = [],
        r = [];
    return t.ph = null, t.contextMenu = !0, t.getlabel = function() {
        return n ? n.getLabel ? n.getLabel() : n.label : ""
    }, t.addSubjectEventListener = function(n, r) {
        i.push([n, r]), t.subject.attachEventListener(n, r)
    }, t.updateLabels = function() {
        t.dispatchEvent("change")
    }, t.__fill = function(n, i, r, u) {
        return t.ph = n, i && (i[0] || (i[0] = 400), i[1] || (i[1] = 5)), n.innerHTML = '<div data-sticky="5,5,0,5"><div id="' + t._("baseMain") + '" data-sticky="0,0,0,0"><\/div>' + (i ? '<div id="' + t._("baseButtons") + '" data-sticky="' + i[0] + ",," + i[1] + ',">' + (r || '<div class="buttons">\t<button id="' + t._("btnSave") + '" style="width:90px;background-image:url(' + IMG_ACCEPT + ')" disabled="disabled" onclick="' + t._var + '.save()">Save (F2)<\/button>\t<button style="width:90px;background-image:url(' + IMG_CANCEL + ')" onclick="' + t._var + '.__close()">Close (F9)<\/button>' + (u || "") + "<\/div>") + "<\/div>" : "") + "<\/div>", t.$("baseMain")
    }, t.canClose = function() {
        var n = t.$("btnSave");
        return !n || n.disabled
    }, t.__close = function() {
        t.canClose() ? t.close() : t.save ? YesNoDialog(RES.save_changes, function() {
            t.save(t.close)
        }, t.close, !0) : YesNoDialog(RES.discard_changes, t.close)
    }, t.__handleKeyDown = function(n) {
        var i = t.$("btnSave");
        n.keyCode == 113 && i && !i.disabled ? t.save() : n.keyCode == 120 && t.__close()
    }, t.handleKeyDown = function(n) {
        t.__handleKeyDown(n)
    }, t.setInterval = function(n, t) {
        n(t), r.push(setInterval(n, t))
    }, t.updateSubject = function(n) {
        while (i.length) {
            var r = i.shift();
            t.subject.detachEventListener(r[0], r[1])
        }
        return t.subject = n, n && (n.getBreadcrumbs && (t.tooltip = n.getBreadcrumbs()), t.addSubjectEventListener("labelChanged", t.updateLabels)), n
    }, t.destroy = function() {
        while (r.length) clearInterval(r.shift());
        t.updateSubject(null), Storage.dispose(t)
    }, t.show = function() {}, t.hide = function() {}, t.updateSubject(n), t
}

function FillerWelcome(n) {
    var t = new FillerBase(n);
    return t.getLabel = function() {
        return "Welcome!"
    }, t.fill = function(n) {
        n.innerHTML = '<div id="' + t._("phWelcome") + '" data-sticky="0,,0,0" style="width:335px;border-right:1px solid #eaeaea"><\/div><iframe id="' + t._("ifrWelcome") + '" data-sticky="333,0,0,0" src="about:blank" frameborder="0"><\/iframe>', t.show(), setTimeout(function() {
            t.$("ifrWelcome").src = MakeURL([DBNINJAWS, "/services/welcome.php?v=" + VERSION + "&u=" + UID + (typeof __wel == "undefined" ? "&w=1" : "")]), __wel = !0
        }, 500)
    }, t.show = function() {
        var n = APP.hostInfo;
        t.$("phWelcome").innerHTML = '<div class="frame" data-sticky="15,15,40,"><div class="frameTitle">Environment Info<\/div><table class="tblWelcome"><tr><td>DbNinja version<\/td><td><b>' + VERSION + "<\/b><\/td><\/tr><tr><td>Platform<\/td><td><b>" + n.os + "<\/b><\/td><\/tr><tr><td>PHP version<\/td><td><b>" + n.phpVersion + "<\/b><\/td><\/tr><tr><td>File uploads<\/td><td><b>" + (n.file_uploads ? "Supported" : "Disabled") + "<\/b><\/tr><\/tr><tr><td>Multibyte encoding<\/td><td><b>" + (n.encodings ? "Supported" : "Disabled") + "<\/b><\/tr><\/tr><tr><td>Memory limit<\/td><td><b>" + n.memory_limit + "<\/b><\/td><\/tr><tr><td>Post max. size<\/td><td><b>" + n.post_max_size + "<\/b><\/td><\/tr><tr><td>Upload max. size<\/td><td><b>" + n.upload_max_filesize + '<\/b><\/td><\/tr><\/table><\/div><div class="frame" data-sticky="15,15,295,"><div class="frameTitle">DbNinja Settings<\/div><table class="tblWelcome"><tr><td style="width:140px">Connection encryption<\/td><td><b>' + (APP.encrypt ? "Enabled" : "Disabled") + "<\/b><\/td><\/tr><tr><td>Query timeout<\/td><td><b>" + APP.reqTimeout + " seconds<\/b><\/td><\/tr><tr><td>Query result limits<\/td><td><b>" + APP.queryMaxDataSize + "MB / " + APP.queryMaxRows + " rows<\/b><\/td><\/tr><tr><td>Query result max cell size<\/td><td><b>" + APP.queryMaxCellSize + " bytes<\/b><\/td<\/tr><tr><td>Query result page size<\/td><td><b>" + APP.queryPageSize + "<\/b><\/td><\/tr><\/table><\/div>", ValidateLayout(t.$("phWelcome"))
    }, t.close = function() {
        CloseWindow(t)
    }, t
}

function FillerEvent(n) {
    function i() {
        DisableElem(t._("btnSave"), !n.temp && !n._changed)
    }
    var t = new FillerBase(n),
        e, o, f, u, r;
    return t.getLabel = function() {
        return "Event:" + n.name
    }, t.handleChange = function() {
        var r = t.$("rdoOnce").checked;
        DisableElem(t._("inpExecAt"), !r), u.setDisabled(r), f.setDisabled(r), DisableElem(t._("chkStarts"), r), DisableElem(t._("chkEnds"), r), DisableElem(t._("inpStarts"), r), DisableElem(t._("inpEnds"), r), DisableElem(t._("inpStarts"), r || !t.$("chkStarts").checked), DisableElem(t._("inpEnds"), r || !t.$("chkEnds").checked), n._set("preserve", t.$("chkPreserve").checked ? !1 : !0), n._set("selRdo", r ? 1 : 2), r ? n._set("executeAt", t.$("inpExecAt").value) : (n._set("starts", t.$("chkStarts").checked ? t.$("inpStarts").value.trim() : ""), n._set("ends", t.$("chkEnds").checked ? t.$("inpEnds").value.trim() : "")), i()
    }, t.setName = function() {
        n._set("name", t.$("txtEventName").value), i()
    }, t.fill = function(s, h) {
        if (!h && !n.temp) {
            n.load(function() {
                t.fill(s, !0), ValidateLayout(s)
            });
            return
        }
        t.elem = t.__fill(s, [400]);
        var c = new TabNav(t.elem, [{
            label: "Editor",
            fill: function(s) {
                s.innerHTML = '<table data-sticky="10,,10," cellpadding="5"><tr><td style="width:50px">Name<\/td><td><input id="' + t._("txtEventName") + '" type="text" style="width:196px" onkeyup="' + t._var + '.setName()" oncut="' + t._var + '.setName()" onpaste="' + t._var + '.setName()" /><\/td><\/tr><tr><td>Definer<\/td><td id="' + t._("phDefiner") + '"><\/td><\/tr><tr><td>State<\/td><td id="' + t._("phState") + '"><\/td><\/tr><tr><td><\/td>\t<td style="height:30px"><label onclick="' + t._var + '.handleChange()" title=""><input id="' + t._("chkPreserve") + '" type="checkbox" />Drop on Completion<\/label><\/td><\/tr><\/table><table data-sticky="300,,10," cellpadding="5"><tr><td><label onclick="' + t._var + ".handleChange();$$('" + t._("inpExecAt") + '\').focus()" title=""><input id="' + t._("rdoOnce") + '" type="radio" name="' + t._("eventType") + '" />Once at<\/label><\/td><td colspan="2"><input id="' + t._("inpExecAt") + '" type="text" style="width:200px" onkeyup="' + t._var + '.handleChange()" oncut="' + t._var + '.handleChange()" onpaste="' + t._var + '.handleChange()" /><\/td><\/tr><tr><td colspan="3" style="padding:2px"><\/td><\/tr><tr><td><label onclick="' + t._var + '.handleChange()" title=""><input id="' + t._("rdoInterval") + '" type="radio" name="' + t._("eventType") + '" />Every<\/label><\/td><td id="' + t._("phIntervalValue") + '"><\/td><td id="' + t._("phIntervalField") + '" style="padding-left:0"><\/td><\/tr><tr><td><label onclick="' + t._var + ".handleChange();$$('" + t._("inpStarts") + '\').focus()" title=""><input id="' + t._("chkStarts") + '" type="checkbox" />Starts at<\/label><\/td><td colspan="2"><input id="' + t._("inpStarts") + '" type="text" style="width:200px" onkeyup="' + t._var + '.handleChange()" oncut="' + t._var + '.handleChange()" onpaste="' + t._var + '.handleChange()" /><\/td><\/tr><tr><td><label onclick="' + t._var + ".handleChange();$$('" + t._("inpEnds") + '\').focus()" title=""><input id="' + t._("chkEnds") + '" type="checkbox" />Ends at<\/label><\/td><td colspan="2"><input id="' + t._("inpEnds") + '" type="text" style="width:200px" onkeyup="' + t._var + '.handleChange()" oncut="' + t._var + '.handleChange()" onpaste="' + t._var + '.handleChange()" /><\/td><\/tr><\/table><div id="' + t._("phCode") + '" data-sticky="5,5,165,5"><\/div>', ValidateLayout(s);
                var h = Labelize("YEAR", "QUARTER", "MONTH", "DAY", "HOUR", "MINUTE", "WEEK", "SECOND", "YEAR_MONTH", "DAY_HOUR", "DAY_MINUTE", "DAY_SECOND", "HOUR_MINUTE", "HOUR_SECOND", "MINUTE_SECOND");
                e = CreateDefinersCombo(t._("phDefiner"), 200, n, function(t) {
                    n._set("definer", t.label), i()
                }), o = new Combo(t.$("phState"), Labelize("ENABLED", "DISABLED", "DISABLED ON SLAVE"), 200, n.state, function(t) {
                    n._set("state", t.label), i()
                }), f = new Combo(t.$("phIntervalField"), h, 130, n.intervalField, function(t) {
                    n._set("intervalField", t.label), i()
                }), u = new NumInput(t.$("phIntervalValue"), n.intervalValue, 65, function(t) {
                    n._set("intervalValue", t), i()
                }), u.minimum = 1, r = new CodeEditor(t.$("phCode"), {
                    onChange: function() {
                        n._set("code", r.getValue()), i()
                    }
                }), r.fill(n.code), t.$("rdoOnce").checked = n.executeAt ? "checked" : null, t.$("rdoInterval").checked = n.executeAt ? null : "checked", t.$("txtEventName").value = n.name, t.$("chkStarts").checked = n.starts ? "checked" : null, t.$("chkEnds").checked = n.ends ? "checked" : null, t.$("inpExecAt").value = n.executeAt, t.$("inpStarts").value = n.starts, t.$("inpEnds").value = n.ends, t.$("chkPreserve").checked = n.preserve ? "" : "checked", t.handleChange(), r.setCursor(1, 0), r.focus(), t._addToDeathList([e, o, f, u, r])
            }
        }, new DDLTab(n)], function() {});
        t._addToDeathList(c), c.selectIndex(0)
    }, t.save = function(r) {
        n.save(function() {
            i(), t.updateLabels(), r && r()
        })
    }, t.close = function() {
        n.temp && n.getDB().drop(n), CloseWindow(t)
    }, t
}

function FillerTableDesign(n) {
    function g() {
        var i = n.engine != "MyISAM";
        e.setDisabled(i), a.setDisabled(i), DisableElem(t._("phChecksum"), i), DisableElem(t._("phDelayed"), i), DisableElem(t._("chkChecksum"), i), DisableElem(t._("chkDelayed"), i), n.engine == "InnoDB" ? (t.$("phFKeyMsg").innerHTML = RES.constraint_unique_name, DisableElem(t._("btnFKeyAdd"), 0)) : (t.$("phFKeyMsg").innerHTML = RES.foreign_keys_no_support, DisableElem(t._("btnFKeyAdd"), 1))
    }

    function w() {
        e.setValue(n.avgRowLen, !0), s.setValue(n.minRows, !0), h.setValue(n.maxRows, !0), c.setValue(n.autoInc || 1, !0), v.select(n.charset), y.select(n.rowFormat, !0), a.select(n.packKeys, !0), p.select(n.engine, !0), t.$("chkChecksum").checked = n.checksum ? "checked" : "", t.$("chkDelayed").checked = n.delayKeyWrite ? "checked" : "", t.$("txtComment").value = n.comment, g(), r.setData(n.columns), f.setData(n.indices), i.setData(n.fkeys), u(0), u(1), u(2)
    }

    function u(u) {
        var o = !n.checkChanged() || !n.columns.length,
            e;
        DisableElem(t._("btnSave"), o), DisableElem(t._("chkFK"), o), u == 0 ? (e = r.selectedItem, DisableElem(t._("btnInsCol"), !e), DisableElem(t._("btnColDel"), !e), DisableElem(t._("btnColUp"), !e || r.selectedIndex == 0, .5), DisableElem(t._("btnColDown"), !e || r.selectedIndex >= n.columns.length - 1, .5), t.$("btnColDel").innerHTML = (e && e._deleted ? "Restore" : "Delete") + " Column") : u == 1 ? (e = f.selectedItem, DisableElem(t._("btnIndDel"), !e), t.$("btnIndDel").innerHTML = (e && e._deleted ? "Restore" : "Delete") + " Index") : u == 2 && (e = i.selectedItem, DisableElem(t._("btnFKeyDel"), !e), t.$("btnFKeyDel").innerHTML = (e && e._deleted ? "Restore" : "Delete") + " Foreign Key")
    }

    function b(t) {
        n.columns.map(function(n, i) {
            t ? n._set("_index", i) : n._index = i
        })
    }
    var t = new FillerBase(n),
        r, f, i, e, s, h, c, v, l, y, a, p, o, k = !1,
        d = !1;
    return t.getLabel = function() {
        return "Table:" + n.name
    }, t.handleChkBoxChange = function() {
        n._set("checksum", t.$("chkChecksum").checked ? 1 : 0), n._set("delayKeyWrite", t.$("chkDelayed").checked ? 1 : 0)
    }, t.moveColumnRow = function(n) {
        var t = r.moveRow(n);
        t && b(!t.temp && !r.selectedItem.temp), u(0)
    }, t.addSubjectEventListener("change", function() {
        u()
    }), t.addSubjectEventListener("labelChanged", function() {
        t.$("phTblName").innerHTML = n.name
    }), t.fill = function(b) {
        var tt = t.__fill(b, [450], null, '<label style="margin:5px 0 0 10px;position:absolute"><input id="' + t._("chkFK") + '" type="checkbox" /> Disable foreign key checks when saving<\/label>'),
            nt;
        tt.style.minWidth = "600px", nt = new TabNav(tt, [{
            label: "Data",
            extraSpace: 5,
            fill: function(i) {
                o = new FillerQuery(n), o.fill(i), t._addToDeathList(o)
            }
        }, {
            label: "Properties",
            fill: function(i) {
                i.innerHTML = '<table data-sticky="10,,5," cellpadding="5"><tr><td style="width:100px">Name<\/td><td style="white-space:nowrap">\t<b id="' + t._("phTblName") + '">' + n.name + '<\/b>\t<div class="buttons" style="display:inline">&nbsp;&nbsp;&nbsp;\t\t<button style="background-image:url(' + IMG_RENAME + ')" onclick="' + t._var + '.subject.rename()">Rename<\/button>\t<\/div><\/td><\/tr><tr><td>Character Set<\/td><td id="' + t._("phCmbCharset") + '"><\/td><\/tr><tr><td>Collation<\/td><td id="' + t._("phCmbCollation") + '"><\/td><\/tr><\/table><table data-sticky="10,,130," cellpadding="5"><tr>\t<td style="width:100px">Engine<\/td><td id="' + t._("phCmbEngine") + '"><\/td>\t<td style="width:30px"><\/td>\t<td style="width:100px">Row Format<\/td><td id="' + t._("phCmbRowFormat") + '"><\/td><\/tr><tr>\t<td>Avg. Row Length<\/td><td id="' + t._("phNumAvgRowLen") + '" title="An approximation of the average row length for your table. You need to set this only for large tables with variable-size rows."><\/td>\t<td><\/td>\t<td>Min. Rows<\/td><td id="' + t._("phNumMinRows") + '" title="The minimum number of rows you plan to store in the table. This is not a hard limit, but rather a hint to the storage engine that the table must be able to store at least this many rows."><\/td><\/tr><tr>\t<td>Auto Inc. Value<\/td><td id="' + t._("phNumAutoInc") + '"><\/td>\t<td><\/td>\t<td>Max. Rows<\/td><td id="' + t._("phNumMaxRows") + '" title="The maximum number of rows you plan to store in the table. This is not a hard limit, but rather a hint to the storage engine that the table must be able to store at least this many rows."><\/td><\/tr><tr>\t<td>Pack Keys<\/td><td id="' + t._("phCmbPackKeys") + '"><\/td>\t<td><\/td>\t<td colspan="2">\t\t<label id="' + t._("phChecksum") + '" onclick="' + t._var + '.handleChkBoxChange()" title="Select this if you want MySQL to maintain a live checksum for all rows. This makes the table a little slower to update, but also makes it easier to find corrupted tables">\t\t\t<input id="' + t._("chkChecksum") + '" type="checkbox" />Checksum<\/label>&nbsp;&nbsp;&nbsp;&nbsp;\t\t<label id="' + t._("phDelayed") + '" onclick="' + t._var + '.handleChkBoxChange()" title="Delayed key writing causes key buffers not to be flushed between writes for MyISAM tables.">\t\t\t<input id="' + t._("chkDelayed") + '" type="checkbox" />Delay Key Writes<\/label>\t<\/td><\/tr><\/table><table data-sticky="10,,280," cellpadding="5"><tr>\t<td style="width:100px;vertical-align:top">Comment<\/td>\t<td><textarea id="' + t._("txtComment") + '" rows="5" cols="85" onkeyup="' + t._var + ".subject._set('comment',value)\"><\/textarea><\/td><\/tr><\/table>", ValidateLayout(i), e = new NumInput(t.$("phNumAvgRowLen"), 0, 80, function(t) {
                    n._set("avgRowLen", t)
                }), s = new NumInput(t.$("phNumMinRows"), 0, 80, function(t) {
                    n._set("minRows", t)
                }), h = new NumInput(t.$("phNumMaxRows"), 0, 80, function(t) {
                    n._set("maxRows", t)
                }), c = new NumInput(t.$("phNumAutoInc"), 0, 80, function(t) {
                    n._set("autoInc", t)
                }), e.minimum = 0, s.minimum = 0, h.minimum = 0, c.minimum = 0;
                var r = n.getHost();
                v = new Combo(t.$("phCmbCharset"), [{
                    label: "Default",
                    defCollation: {
                        label: ""
                    }
                }].concat(r.charsets), 150, null, function(t) {
                    n.charset != t.label ? (n._set("charset", t.label == "Default" ? "" : t.label), n._set("collation", t.defCollation.label), l.setData(t.collations, t.defCollation.label)) : l.setData(t.collations, n.collation)
                }, "Default"), l = new Combo(t.$("phCmbCollation"), [], 150, null, function(t) {
                    n._set("collation", t.label)
                }, ""), y = new Combo(t.$("phCmbRowFormat"), ROW_FORMATS, 130, null, function(t) {
                    n._set("rowFormat", t.label)
                }), a = new Combo(t.$("phCmbPackKeys"), PACK_KEYS, 150, null, function(t) {
                    n._set("packKeys", t.label)
                }), p = new Combo(t.$("phCmbEngine"), r.engines, 150, null, function(t) {
                    n._set("engine", t.label), g()
                }), t._addToDeathList([l, v, y, a, e, s, h, c, p])
            }
        }, {
            label: "Columns",
            fill: function(i) {
                i.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button onclick="' + t._var + '.addColumn()" style="background-image:url(' + IMG_ADD + ')">Add Column<\/button>\t<button id="' + t._("btnInsCol") + '" onclick="' + t._var + '.addColumn(1)" style="background-image:url(' + IMG_ADD + ')">Insert Column<\/button>\t<button id="' + t._("btnColDel") + '" onclick="' + t._var + '.delColumn()" style="width:120px;background-image:url(' + IMG_DELETE + ')">Delete Column<\/button>\t<button id="' + t._("btnColUp") + '" class="roundButton" onclick="' + t._var + '.moveColumnRow(true)" style="margin-left:30px;background-image:url(' + IMG_UP + ')"><\/button>\t<button id="' + t._("btnColDown") + '"class="roundButton"  onclick="' + t._var + '.moveColumnRow(false)" style="background-image:url(' + IMG_DOWN + ')" class="onlyIcon"><\/button><\/div><div id="' + t._("phTblColsGrid") + '" data-sticky="5,5,40,5"><\/div>', r = new DataGrid(t.$("phTblColsGrid"), {
                    selectable: !0,
                    onSelect: function() {
                        u(0)
                    },
                    onEditBeginning: function(n) {
                        var t = n.editedDataField;
                        if (n.editedRecord._deleted || t == "lenOrValues" && n.editedValue === null || (t == "charset" || t == "collation") && !n.editedRecord.withCharset) return !1
                    },
                    onEditSave: function(n, t) {
                        n.editedDataField && n.editedRecord._set(n.editedDataField, t), u(0)
                    }
                });
                var f = new ClassFactory(function(n) {
                    var t;
                    this.open = function() {
                        t = n.editedRecord.withValues || n.editedRecord.withLength2 ? new DataGridTextEditor(n) : new DataGridNumberEditor(n, 1), t.open(), this.__close = t.__close, this.close = t.close
                    }
                }, r);
                r.create([{
                    title: "Keys",
                    dataField: "key",
                    width: 40,
                    editable: !1,
                    selectable: !1,
                    align: "center",
                    renderer: function(t, i) {
                        for (var e = n.indices, c = t[i].name, o = ["", "", ""], f = 0, r, s, h, u = 0; u < e.length; u++) e[u].columns.findByProp("name", c) < 0 || (r = e[u].type.toLowerCase(), s = r == "primary" ? 0 : r == "unique" ? 1 : 2, o[s] || (o[s] = '<div style="background:url(images/icons/key_' + r + ".png) no-repeat center center;position:absolute;left:" + (f * 8 + 3) + "px;z-index:" + (3 - f) + ';width:18px;height:inherit" title="' + (r.substr(0, 1).toUpperCase() + r.substr(1)) + '">&nbsp;<\/div>', f++));
                        return h = o.join(""), h ? '<div style="height:20px;width:' + (5 + 10 * f) + 'px">' + h + "<\/div>" : ""
                    }
                }, {
                    title: "Name",
                    dataField: "name",
                    width: 120,
                    editable: !0
                }, {
                    title: "Data Type",
                    dataField: "type",
                    width: 100,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, r, DATA_TYPES, 180)
                }, {
                    title: "Length/Vals",
                    dataField: "lenOrValues",
                    width: 100,
                    editable: !0,
                    editor: f,
                    renderer: function(n, t) {
                        return n[t].withLength2 ? n[t].len2 : n[t].withLength ? n[t].len : n[t].withValues ? n[t].values : void 0
                    }
                }, {
                    title: "Unsigned",
                    dataField: "unsigned",
                    width: 65,
                    onClick: DataGridCheckBoxClickHandler,
                    renderer: function(n, t, i) {
                        if (n[t].isNumeric) return DataGridCheckBoxRenderer(n, t, i)
                    }
                }, {
                    title: "Zerofill",
                    dataField: "zeroFill",
                    width: 65,
                    onClick: DataGridCheckBoxClickHandler,
                    renderer: function(n, t, i) {
                        if (n[t].isNumeric) return DataGridCheckBoxRenderer(n, t, i)
                    }
                }, {
                    title: "Not NULL",
                    dataField: "notNull",
                    width: 65,
                    renderer: DataGridCheckBoxRenderer,
                    onClick: DataGridCheckBoxClickHandler
                }, {
                    title: "Default/Flags",
                    dataField: "defValue",
                    width: 145,
                    editable: !0,
                    editor: new ClassFactory(DataGridDefaultValueEditor, r),
                    renderer: function(n, t) {
                        var r, i = n[t];
                        if (i.autoInc && i.isNumeric) r = "AUTO_INCREMENT";
                        else if ((i.type == "TIMESTAMP" || i.type == "DATETIME") && i.defValue == "CURRENT_TIMESTAMP") r = "CURRENT_TIMESTAMP";
                        else if (i.defValue === null) r = "NULL";
                        else if (i.withNoDefault || !i.defValue) return "";
                        return r ? '<div style="color:blue">' + r + "<\/div>" : "'" + i.defValue + "'"
                    }
                }, {
                    title: "Charset",
                    dataField: "charset",
                    width: 70,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, r, [{
                        label: ""
                    }].concat(n.getHost().charsets)),
                    renderer: function(n, t, i) {
                        if (n[t].withCharset) return n[t][i.dataField]
                    }
                }, {
                    title: "Collation",
                    dataField: "collation",
                    width: 130,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, r, function(t) {
                        return n.getHost().getCollations(t.charset || n.charset || n.getDB().charset)
                    }),
                    renderer: function(n, t, i) {
                        if (n[t].withCharset) return n[t][i.dataField]
                    }
                }, {
                    title: "Comment",
                    dataField: "comment",
                    width: 150,
                    editable: !0
                }]), t._addToDeathList(r)
            }
        }, {
            label: "Indices",
            fill: function(n) {
                n.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button onclick="' + t._var + '.addIndex()" style="background-image:url(' + IMG_ADD + ')">Add Index<\/button>\t<button id="' + t._("btnIndDel") + '" onclick="' + t._var + '.delIndex()" style="width:110px;background-image:url(' + IMG_DELETE + ')">Delete Index<\/button><\/div><div id="' + t._("phTblIndGrid") + '" data-sticky="5,5,40,5"><\/div>', f = new DataGrid(t.$("phTblIndGrid"), {
                    selectable: !0,
                    onSelect: function() {
                        u(1)
                    },
                    onEditBeginning: function(n) {
                        var t = n.editedDataField;
                        if (t == "name" && n.editedRecord.type == "PRIMARY") return !1
                    },
                    onEditSave: function(n, t) {
                        n.editedDataField != "columnNames" && n.editedRecord._set(n.editedDataField, t), u(1)
                    }
                }), f.create([{
                    title: "Name",
                    dataField: "name",
                    width: 200,
                    editable: !0,
                    valign: "top"
                }, {
                    title: "Columns",
                    dataField: "columnNames",
                    width: 200,
                    editable: !0,
                    valign: "top",
                    renderer: function(n, t) {
                        return '<div style="line-height:inherit;color:inherit">' + n[t].columnNames + "<\/div>"
                    },
                    editor: new ClassFactory(DataGridIndexColumnsEditor, f, function(n) {
                        f.editedRecord.columns = n.map(function(n) {
                            if (n.selected) return n
                        }), f.editedRecord.updateColumnNames(), f.refreshRow(), u()
                    })
                }, {
                    title: "Type",
                    dataField: "type",
                    width: 100,
                    editable: !0,
                    valign: "top",
                    editor: new ClassFactory(DataGridSelectEditor, f, INDEX_TYPES, 110)
                }, {
                    title: "Using",
                    dataField: "using",
                    width: 100,
                    editable: !0,
                    valign: "top",
                    editor: new ClassFactory(DataGridSelectEditor, f, USING_TYPES, 110)
                }]), t._addToDeathList(f)
            }
        }, {
            label: "Foreign Keys",
            fill: function(n) {
                n.innerHTML = '<div class="buttons" data-sticky="5,0,5,">\t<button id="' + t._("btnFKeyAdd") + '" onclick="' + t._var + '.addFKey()" style="background-image:url(' + IMG_ADD + ')">Add Foreign Key<\/button>\t<button id="' + t._("btnFKeyDel") + '" onclick="' + t._var + '.delFKey()" style="width:140px;background-image:url(' + IMG_DELETE + ')">Delete Foreign Key<\/button>\t<div id="' + t._("phFKeyMsg") + '" data-sticky="310,,10," style="color:red"><\/div><\/div><div id="' + t._("phTblFkeyGrid") + '" data-sticky="5,5,40,5"><\/div>', i = new DataGrid(t.$("phTblFkeyGrid"), {
                    selectable: !0,
                    onSelect: function() {
                        u(2)
                    },
                    onEditBeginning: function(n) {
                        var t = n.editedDataField,
                            r = n.editedRecord;
                        return r._deleted || !r.refDB && (t == "refTable" || t == "refColumnNames") || !r.refTable && t == "refColumnNames" ? !1 : t == "columnNames" ? (r.loadColumns(i.openEditor), !1) : t == "refTable" ? (r.loadRefTables(i.openEditor), !1) : t == "refColumnNames" ? (r.loadRefColumns(i.openEditor), !1) : void 0
                    },
                    onEditSave: function(n, t) {
                        n.editedDataField != "columnNames" && (n.editedRecord._set(n.editedDataField, t), n.refreshRow(), u())
                    }
                });
                var r = [{
                    label: "RESTRICT",
                    tooltip: "Rejects the delete or update operation for the parent table."
                }, {
                    label: "CASCADE",
                    tooltip: "Delete or update the row from the parent table and automatically delete or update the matching rows in the child table."
                }, {
                    label: "SET NULL",
                    tooltip: "Delete or update the row from the parent table and set the foreign key column or columns in the child table to NULL. This is valid only if the foreign key columns do not have the NOT NULL qualifier specified."
                }];
                i.create([{
                    title: "Name",
                    dataField: "name",
                    width: 130,
                    editable: !0
                }, {
                    title: "Columns",
                    dataField: "columnNames",
                    width: 150,
                    editable: !0,
                    editor: new ClassFactory(DataGridColumnsSelectEditor, i, function() {
                        return i.editedRecord.columns
                    }, function() {
                        i.editedRecord.updateColumnNames(), i.refreshRow(), u()
                    })
                }, {
                    title: "Reference DB",
                    dataField: "refDB",
                    width: 130,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, i, function() {
                        return i.editedRecord.allDBs
                    })
                }, {
                    title: "Reference Table",
                    dataField: "refTable",
                    width: 130,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, i, function() {
                        return i.editedRecord.allRefTables
                    })
                }, {
                    title: "Foreign Columns",
                    dataField: "refColumnNames",
                    width: 150,
                    editable: !0,
                    editor: new ClassFactory(DataGridColumnsSelectEditor, i, function() {
                        return i.editedRecord.refColumns
                    }, function() {
                        i.editedRecord.updateColumnNames(), i.refreshRow(), u()
                    })
                }, {
                    title: "On Delete",
                    dataField: "onDelete",
                    width: 75,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, i, r)
                }, {
                    title: "On Update",
                    dataField: "onUpdate",
                    width: 75,
                    editable: !0,
                    editor: new ClassFactory(DataGridSelectEditor, i, r)
                }]), t._addToDeathList(i)
            }
        }, new DDLTab(n)], function(i, r) {
            r != 0 || k || n.temp ? r > 0 && !d && (n.load(w), d = !0) : (o.refresh(null), k = !0), t.$("baseButtons").style.display = r > 0 ? "block" : "none"
        }), t._addToDeathList(nt), n.temp ? (nt.selectIndex(1), w()) : nt.selectIndex(APP.tableAction == 1 ? 0 : 2)
    }, t.addColumn = function(t) {
        var i = new Column(n),
            f;
        t && r.selectedIndex >= 0 ? n.columns.splice(r.selectedIndex, 0, i) : n.columns.push(i), r.refreshData(), r.selectItem(i), b(), f = i._index, i._index = 0, i._set("_index", f), u(0)
    }, t.delColumn = function() {
        var t = r.selectedItem;
        n.temp || t.temp ? (n.columns._splice(r.selectedIndex, 1), t = null) : t._deleted ? t._delete("_deleted") : t._set("_deleted", !0), r.refreshData(), t && r.selectItem(t), b(), u(0)
    }, t.addIndex = function() {
        var t = new Index(n);
        n.indices.push(t), f.refreshData(), f.selectItem(t), u(1)
    }, t.delIndex = function() {
        var t = f.selectedItem;
        n.temp || t.temp ? (n.indices._splice(f.selectedIndex, 1), t = null) : t._deleted ? t._delete("_deleted") : t._set("_deleted", !0), f.refreshData(), t && f.selectItem(t), u(1)
    }, t.addFKey = function() {
        var t = new FKey(n);
        n.fkeys.push(t), i.refreshData(), i.selectItem(t), u(2)
    }, t.delFKey = function() {
        var t = i.selectedItem;
        n.temp || t.temp ? (n.fkeys._splice(i.selectedIndex, 1), t = null) : t._deleted ? t._delete("_deleted") : t._set("_deleted", !0), i.refreshData(), t && i.selectItem(t), u(2)
    }, t.save = function(i) {
        n.save(function() {
            w(), i && i()
        }, t.$("chkFK").checked)
    }, t.close = function() {
        n.temp ? n.getDB().drop(n) : o.close(), CloseWindow(t)
    }, t
}

function FillerQuery(n, t) {
    function w(n) {
        a = n, a ? (nt = 0, ft = n, document.body.focus(), tt = Alert('<div style="padding:15px;text-align:center">Query executed <span id="phQueryCnt" style="font-weight:bold;font-size:15px">0<\/span> times<\/div>', "Query Auto Repeat", 0, 0, function() {
            w(0)
        }, "Stop", !1, null, !1, !0), i.refresh()) : (clearTimeout(et), e.focus(), tt.close(), tt = null), h()
    }

    function h() {
        var n = a || o || s && s._changed,
            t = n || !u || !u.resultCount,
            h, y;
        u && u.resultCount && u.data.length != 0 ? (f ? (y = u.page * u.pageSize, h = "Records " + (y + 1) + "-" + (y + u.data.length)) : h = "Records " + (l + 1) + "-" + (l + u.data.length), h += " from " + u.rowCount) : h = "No Records", i.$("btnQueryTxtPage").innerHTML = h, DisableElem(i._("btnQueryDataBack"), t || u.resultIndex == 0, .4), DisableElem(i._("btnQueryDataFwd"), t || u.resultIndex == u.resultCount - 1, .4), DisableElem(i._("btnQueryPageBack"), t || f && u.page == 0 || !f && l == 0, .4), DisableElem(i._("btnQueryPageFwd"), t || f && u.page == u.pageCount - 1 || !f && l + u.data.length >= u.rowCount, .4), DisableElem(i._("btnQueryNewRec"), t || !c, .4), DisableElem(i._("btnQueryDelRec"), t || !c || !r.selectedItem, .4), DisableElem(i._("btnQueryRefr"), t || !i.lastGoodQuery, .4), DisableElem(i._("btnQueryApply"), a || !n || !u, .4), DisableElem(i._("btnQueryCancel"), a || !n || !u, .4), f && (n = n || !e.getValue().trim(), i.$("btnQueryTxtDataset").innerHTML = u && u.resultCount ? "Dataset " + (u.resultIndex + 1) + " / " + u.resultCount : "No Data", DisableElem(i._("btnQueryRun"), n, .4), DisableElem(i._("btnQueryFav"), n, .4), DisableElem(i._("btnQueryRef"), n, .4), DisableElem(i._("btnQueryExp"), n, .4), v.setDisabled(a))
    }

    function b(n) {
        var t = n.resultCount ? n.rowCount : n.affectedRows,
            r = t + " row" + (t > 1 ? "s" : "") + (n.resultCount ? " selected" : " affected") + (n.execTime ? " in " + n.execTime + " sec." : "");
        i.$("phStatus").innerHTML = r
    }

    function k(n, t, i, r, u) {
        var f;
        if (n !== undefined) {
            if (u == "where") {
                if (f = "`" + t.field + "`", n === null) i.push(f + " IS NULL");
                else if (n === "") i.push(f + '=""');
                else if (typeof n == "object")
                    if (n.action) {
                        if (n.action == "CURRENT_TIMESTAMP" || n.action == "NOW()") return;
                        n.action == "NULL" ? i.push(f + " IS NULL") : i.push(f + "=" + n.action)
                    } else n.hash && i.push("MD5(" + f + ')="' + n.hash + '"');
                else t.type == "number" || t.type == "bit" ? i.push(f + "=" + n) : i.push(f + '="' + n.toString().addslashes() + '"');
                return
            }
            f = u == "update" ? "`" + t.field + "`=" : "", n === null ? i.push(f + "NULL") : n === "" ? i.push(f + '""') : typeof n == "object" ? n.action ? i.push(f + n.action) : n.fid ? (i.push(f + "?"), r.push({
                type: t.binary ? "b" : "s",
                file: n.fid
            })) : n.hash && i.push(f + n.hash) : t.type == "number" || t.type == "bit" ? i.push(f + n) : i.push(f + '"' + n.toString().addslashes() + '"')
        }
    }

    function d(n) {
        var i = [],
            r = [],
            t = u.getUniqueKeyFields();
        return t || (t = u.fields), t.map(function(t) {
            t.table && !t.hash && k(n._changed ? n.prevValue(t.index) : n[t.index], t, i, r, "where")
        }), t.map(function(t) {
            t.table && t.hash && k(n._changed ? n.prevValue(t.index) : n[t.index], t, i, r, "where")
        }), [i, r]
    }

    function lt(t) {
        var e = [],
            f, o;
        u.fields.map(function(n) {
            n.table && e.push(n.field)
        }), f = d(t), o = f[0].length ? " WHERE " + f[0].join(" AND ") : "", n.sendQuery("SELECT `" + e.join("`,`") + "` FROM " + c + o + " LIMIT 2", function(n) {
            if (n.data.length != 1) {
                i.refresh(i.lastGoodQuery);
                return
            }
            u.fields.map(function(i, r) {
                i.table && (t[r] = n.data[0].shift())
            }), r.refreshRow(u.data.indexOf(t))
        }, f[1], QUERY_WITH_FIELD_DETAILS | QUERY_WITH_HASHING)
    }

    function it(t, i, r) {
        var f = d(t);
        n.sendQuery("SELECT `" + u.fields[i].field + "` FROM " + c + " WHERE " + f[0].join(" AND ") + " LIMIT 1", function(n) {
            n.file && r(n.file, n.alias)
        }, f[1], 0, !0)
    }

    function bt() {
        switch (APP.binCellAction) {
            case 0:
                at();
                break;
            case 1:
                vt();
                break;
            case 2:
                yt();
                break;
            case 3:
                g(1);
                break;
            case 4:
                g()
        }
    }

    function at() {
        new UploadDialog((u.fields[r.selectedField].binary ? "Binary" : "Text") + " Column File Upload", function(n) {
            r.selectedItem._set(r.selectedField, {
                label: "Uploaded",
                fid: n
            }), r.refreshRow(), h()
        }, APP.hostInfo.maxFileSize, RES.warn_file_post_size)
    }

    function vt() {
        it(r.selectedItem, r.selectedField, DownloadFile)
    }

    function yt() {
        it(r.selectedItem, r.selectedField, function(n) {
            var t = Alert("", "Image Preview", document.body.clientWidth - 80, document.body.clientHeight - 150);
            t.fill('<img src="data.php?action=imgview&file=' + n + '" onload="' + t._var + '.center()" />')
        })
    }

    function g(n) {
        it(r.selectedItem, r.selectedField, function(t) {
            var i = Alert('<iframe src="data.php?action=binview&file=' + t + (n ? "&hex=1" : "") + '" class="border" style="width:640px;height:390px"><\/iframe>', "Data Preview (Limited to 1MB)", 750, 500)
        })
    }

    function kt() {
        var t = s,
            a = [],
            e = [],
            f = [],
            v, l;
        o ? t._changed ? (t._changedProperties.map(function(n) {
            var i = n[0],
                r = u.fields[i];
            r.autoInc && t[i] === "" || (a.push("`" + r.field + "`"), k(t[i], r, e, f, !0, "insert"))
        }), n.sendQuery("INSERT INTO " + c + " (" + a.join(",") + ") VALUES (" + e.join(",") + ");", function(n) {
            t.confirmChanges(), o = !1, u.autoIncField != null && t[u.autoIncField.index] === undefined && (t[u.autoIncField.index] = n.lastInsertId), lt(t), h(), b(n)
        }, f, u.autoIncField != null ? QUERY_WITH_INSERT_ID : 0, !1, !1, function() {
            r.selectItem(t), i.updateCurrentRecord(!0), h()
        })) : (v = r.selectedItem, r.data.splice(r.data.indexOf(s), 1), r.refreshData(), r.selectItem(v), o = !1, i.updateCurrentRecord(!0)) : (t._changedProperties.map(function(n) {
            k(t[n[0]], u.fields[n[0]], e, f, "update")
        }), l = d(t), f = f.concat(l[1]), n.sendQuery("UPDATE " + c + " SET " + e.join(",") + " WHERE " + l[0].join(" AND ") + " LIMIT 1", function(n) {
            t.confirmChanges(), lt(t), h(), b(n)
        }, f, 0, !1, !1, function() {
            r.selectItem(t), i.updateCurrentRecord(!0), h()
        })), h()
    }

    function dt(t, o, s) {
        var h, c, v;
        (f ? h = t ? t.trim() : (e.getSelection() || e.getValue()).trim() : (c = y.map(function(n) {
            if (n) return n
        }).join(" AND "), c && (c = " WHERE " + c), h = "SELECT SQL_CALC_FOUND_ROWS * FROM " + n.getFullName() + c + st + " LIMIT " + l + "," + APP.queryPageSize), h) && (v = (new Date).getTime(), n.sendQuery(h, function(n) {
            var t;
            (u = n) && (n.warning && Alert(n.warning + "<br />Query limits can be changed in Settings window."), f || (u.results[0].rowCount = u.results[0].calcFoundRows), t = i.lastGoodQuery, i.lastGoodQuery = h, i.changeResult(0, !(f && t)), r.focus(), o || b(n), s && s()), a && (nt++, t = a * 1e3 - ((new Date).getTime() - v), et = setTimeout(function() {
                i.refresh()
            }, t > 0 ? t : 0), $$("phQueryCnt").innerHTML = nt)
        }, null, QUERY_WITH_FIELD_DETAILS | QUERY_WITH_HASHING | (f ? 0 : QUERY_CALC_FOUND_ROWS), !1, !0, function() {
            a && w(0)
        }))
    }

    function pt(n) {
        function d(n, t, i) {
            var r = "`" + u.fieldNames[i.dataField] + "`",
                e = y[i.dataField] ? [{
                    label: "Remove Filter",
                    icon: IMG_DELETE
                }, null] : [],
                f;
            return n && t > -1 && (f = n[t][i.dataField], f !== null && typeof f != "object" && (f = f.SQLEscape(), e = e.concat([{
                label: r + " = '" + f + "'",
                filter: 1
            }, {
                label: r + " != '" + f + "'",
                filter: 1
            }, {
                label: r + " > '" + f + "'",
                filter: 1
            }, {
                label: r + " < '" + f + "'",
                filter: 1
            }, {
                label: r + " >= '" + f + "'",
                filter: 1
            }, {
                label: r + " <= '" + f + "'",
                filter: 1
            }, {
                label: r + " LIKE '" + f + "%'",
                filter: 1
            }, {
                label: r + " LIKE '%" + f + "'",
                filter: 1
            }, {
                label: r + " LIKE '%" + f + "%'",
                filter: 1
            }])), e = e.concat([{
                label: r + " IS NULL",
                filter: 1
            }, {
                label: r + " IS NOT NULL",
                filter: 1
            }]), e.push(null)), e = e.concat([{
                label: r + " = '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " != '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " > '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " < '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " >= '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " <= '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " IN (...)",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " NOT IN (...)",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " LIKE '...'",
                icon: IMG_RENAME,
                filter: 2
            }, {
                label: r + " NOT LIKE '...'",
                icon: IMG_RENAME,
                filter: 2
            }]), e.map(function(n) {
                n && (n.col = i.dataField)
            }), e
        }
        var a = [],
            nt = u.data || [],
            t, v, e, w, b, tt, k;
        for (n = n && r.columns && r.columns.length == u.fields.length, wt = c = p = "", t = 0; t < u.fields.length; t++)
            if (v = u.fields[t], e = v.table, e)
                if (w = v.db, b = (w ? "`" + w + "`." : "") + "`" + e + "`", c && c != b) {
                    c = "", p = "";
                    break
                } else c = b, p = e;
        tt = [FIELD_FLAGS.PRI_KEY, FIELD_FLAGS.UNIQUE_KEY, FIELD_FLAGS.MULTIPLE_KEY], k = ["primary", "unique", "normal"], APP.showQueryRowNums && a.push({
            title: "#",
            width: 40,
            selectable: !1,
            editable: !1,
            sortable: !1,
            resizable: !1,
            align: "right",
            style: "background-color:#e8eaec",
            renderer: function(n, t) {
                var i = f ? u.page * u.pageSize : l;
                return i + t + 1
            }
        }), u.fields.map(function(t, e) {
            for (var v = [], b = t.flags, w, l, p, c = 0; c < 3; c++) b & tt[c] && v.push('<div style="background:url(images/icons/key_' + k[c] + "_tiny.png) no-repeat center center;position:absolute;left:" + v.length * 6 + "px;z-index:" + (3 - c) + ';width:12px; height:inherit" title="' + k[c] + '">&nbsp;<\/div>');
            w = v.length ? '<div style="position:relative">' + v.join("") + '<\/div><div style="margin-left:' + (v.length * 6 + 6) + 'px" title="' + t.type + '">' + t.fieldAlias + "<\/div>" : '<span title="' + t.type + '">' + t.fieldAlias + "<\/span>", n && r.columns ? l = r.columns[e].width : (l = Math.max(80, GetTextWidth(t.fieldAlias) + (v.length * 6 + 12), r.getBestColumnWidth(nt, e)), l > 350 && (l = 350), l += 10), p = null, p = t.type == "enum" ? new ClassFactory(DataGridSelectEditor, r, (t.values + "").split(",").map(function(n) {
                return {
                    label: n
                }
            })) : t.type == "number" ? new ClassFactory(DataGridNumberEditor, r, null, null, !0) : t.binary ? new ClassFactory(DataGridDblClickHandlingEditor, r, bt) : t.temporal ? new ClassFactory(DataGridTextEditor, r, t.type == "date" ? "YYYY-MM-DD" : t.type == "time" ? "HH:MM:SS" : "YYYY-MM-DD HH:MM:SS") : t.type == "bit" ? new ClassFactory(DataGridTextEditor, r) : new ClassFactory(function(n) {
                var t;
                this.open = function() {
                    t = new DataGridAdvTextEditor(n), n.editedValue && n.editedValue.hash && delete n.editedValue, t.__close__ = t.close, t.close = function(n) {
                        t.__close__($$(t.inpValue).value == "" ? !1 : n), t = null
                    }, this.close = t.close, this.__close = t.__close, t.open()
                }
            }, r), a.push({
                title: w,
                dataField: e,
                width: l,
                selectable: !0,
                editable: !!t.table,
                editor: p,
                sortable: !f,
                sortText: t.type != "number",
                headerRenderer: function(n) {
                    var t = n.title || "";
                    return y[n.dataField] ? '<div style="font-weight:bold;color:red">' + t + "<\/div>" : t
                },
                renderer: function(n, t, i) {
                    var r = n[t][i.dataField],
                        e = n[t]._changed && n[t].propChanged(i.dataField) ? "#990000" : "",
                        f = !1,
                        o = u.fields[i.dataField];
                    return (r === null ? (r = "NULL", f = !0) : r === undefined ? (r = "?", f = !0) : r === "" && o.autoInc ? (r = "AUTO", f = !0) : typeof r == "object" ? (r = r.label == "Large" ? "Size &gt; " + APP.queryMaxCellSize + " bytes" : r.label, f = !0) : o.type == "text" && (r = r.HTMLEntities().CRLF(), /^http(?:s){0,1}:\/\//.test(r) && (r = '<div onmousedown="if(event.ctrlKey){window.open(this.innerHTML,\'_blank\');event.stopPropagation()}" style="color:blue" title="Ctrl+Click to follow link">' + r + "<\/div>")), f || e) ? '<div style="color:' + (e || "blue") + '">' + (f ? "[" + r + "]" : r) + "<\/div>" : r
                },
                contextMenuItems: function(n, t, i) {
                    var y = f || o || s && s._changed;
                    if (t == -1) return y ? null : d(n, t, i);
                    var p = n[t][i.dataField],
                        e = u.fields[i.dataField],
                        c = e.type == "text" || e.type == "blob",
                        h = e.table,
                        w = r.selectedItems.length > 1,
                        v = e.type == "blob" || e.binary,
                        l = [{
                            label: "Delete Record" + (w ? "s" : ""),
                            disabled: !h || o,
                            icon: IMG_DELETE
                        }],
                        a = !h || e.type != "text" && e.type != "blob";
                    return w ? [{
                        label: "Copy Records to Clipboard",
                        icon: IMG_COPY
                    }, null].concat(l) : (l = [null].concat(l), [{
                        label: "Upload Value",
                        disabled: !h || !c,
                        icon: IMG_UPLOAD
                    }, {
                        label: "Download Value",
                        disabled: !h || o || !c,
                        icon: IMG_DOWNLOAD
                    }, null, {
                        label: "Filter",
                        disabled: y,
                        children: d(n, t, i),
                        icon: IMG_FILTER
                    }, null, {
                        label: "Preview As...",
                        children: [{
                            label: "Image",
                            disabled: !h || o || !v,
                            icon: IMG_PICTURE
                        }, {
                            label: "Binary",
                            disabled: !h || o || !v,
                            icon: IMG_BINARY
                        }, {
                            label: "Text",
                            disabled: !h || o || !c,
                            icon: IMG_TEXT
                        }],
                        disabled: !h || o || !(c || v),
                        icon: IMG_PREVIEW
                    }, null, {
                        label: "Copy to Clipboard...",
                        children: [{
                            label: "Copy Cell",
                            disabled: o || !p || typeof p == "object"
                        }, {
                            label: "Copy Record",
                            disabled: o
                        }],
                        icon: IMG_COPY
                    }, null, {
                        label: "Set to NULL",
                        action: "NULL",
                        disabled: !h || e.notNull
                    }, {
                        label: "Set to Empty String",
                        action: '""',
                        disabled: !h || !(e.type == "enum" || e.type == "set" || c)
                    }, null, {
                        label: "Set to Zero (0000-00-00)",
                        action: "0000-00-00",
                        disabled: !h || !e.temporal
                    }, {
                        label: "Set to NOW()",
                        action: "NOW()",
                        disabled: !h || !e.temporal
                    }, {
                        label: "Set to My Local Time",
                        disabled: !h || !e.temporal
                    }, null, {
                        label: "Set to SHA(...)",
                        action: "SHA",
                        disabled: a
                    }, {
                        label: "Set to MD5(...)",
                        action: "MD5",
                        disabled: a
                    }, null, {
                        label: "Set to SHA of Cell Value",
                        action: "SHA(" + e.field + ")",
                        disabled: a
                    }, {
                        label: "Set to MD5 of Cell Value",
                        action: "MD5(" + e.field + ")",
                        disabled: a
                    }].concat(l))
                },
                contextMenuHandler: function(n) {
                    switch (n.label.toLowerCase()) {
                        case "upload value":
                            at();
                            break;
                        case "download value":
                            vt();
                            break;
                        case "image":
                            yt();
                            break;
                        case "binary":
                            g(1);
                            break;
                        case "text":
                            g();
                            break;
                        case "set to my local time":
                            r.selectedItem._set(r.selectedField, (new Date).toMySQL()), r.refreshRow();
                            break;
                        case "delete record":
                        case "delete records":
                            i.delRec();
                            break;
                        case "copy cell":
                            SetClipboard(r.selectedItem[r.selectedField]);
                            break;
                        case "copy records to clipboard":
                        case "copy record":
                            var t = r.selectedItems.map(function(n) {
                                var t = n.map(function(n) {
                                    return n === null || n === undefined || typeof n == "object" ? "" : n
                                });
                                return t.join("\t")
                            });
                            SetClipboard(t.join("\r\n"));
                            break;
                        case "remove filter":
                            delete y[n.col], i.refresh();
                            break;
                        default:
                            n.action ? n.action == "SHA" || n.action == "MD5" ? Confirm("Value to calculate hash", n.action, "", function(t) {
                                r.selectedItem._set(r.selectedField, {
                                    label: n.action + "(...)",
                                    action: n.action + "('" + t.SQLEscape() + "')"
                                }), r.refreshRow(), h()
                            }) : (r.selectedItem._set(r.selectedField, {
                                label: n.action == '""' ? "Empty" : n.action,
                                action: n.action
                            }), r.refreshRow()) : n.filter && (n.filter == 1 ? (y[n.col] = n.label, i.refresh()) : Confirm(n.label, "Column Filter", "", function(t) {
                                y[n.col] = n.label.replace("...", t.SQLEscape()), i.refresh()
                            }))
                    }
                    h()
                }
            })
        }), r.create(a), r.setData(nt), r.addSortArrow(ht, ct), rt && (r.selectIndex(0), r.selectCell(0), i.updateCurrentRecord(!0), rt = !1), h()
    }
    var i = new FillerBase(n),
        r, e, v, s, l = 0,
        rt = !0,
        u = null,
        o = !1,
        ut = !1,
        a = 0,
        ft = 10,
        et, nt = 0,
        tt, wt, c, p, ot = "",
        st = "",
        ht = -1,
        ct = !1,
        y = [],
        f;
    return typeof t == "object" && (ut = t.forceRun, t = t.query), f = n.objType == "database" || n.objType == "host", i.lastGoodQuery = "", i.getLabel = function() {
        return (f ? "Query" : "Data") + ": " + n.name
    }, i.__handleVSplit = function(n) {
        __FillerQueryH1 = n
    }, i.fill = function(c) {
        var y = i.__fill(c),
            p = c.clientHeight - 98 - (f ? 25 : 0),
            a = __FillerQueryH1 < p ? __FillerQueryH1 : p,
            l;
        y.innerHTML = '<table class="buttons queryTopBar" data-sticky="0,,7,"><tr>' + (f ? '<td style="min-width:160px" id="' + i._("phDBs") + '"><\/td><td><button id="' + i._("btnQueryDataBack") + '" class="roundButton" style="background-image:url(images/icons/rec_fast_back.gif)" onclick="' + i._var + '.changeResult(-1)" title="Previous Dataset"><\/button><\/td><td><div id="' + i._("btnQueryTxtDataset") + '" style="min-width:80px" class="textBox"><\/div><\/td><td><button id="' + i._("btnQueryDataFwd") + '" class="roundButton" style="margin-right:7px;background-image:url(images/icons/rec_fast_forward.gif)" onclick="' + i._var + '.changeResult(1)" title="Next Dataset"><\/button><\/td>' : "") + '<td><button id="' + i._("btnQueryPageBack") + '" class="roundButton" style="background-image:url(images/icons/rec_fast_back.gif)" onclick="' + i._var + '.changePage(-1)" title="Previous Page"><\/button><\/td><td><div id="' + i._("btnQueryTxtPage") + '" style="min-width:150px" class="textBox" onclick="' + i._var + '.showPageSelector()" title="Click to select ' + (f ? "page" : "offset") + '"><\/div><\/td><td><button id="' + i._("btnQueryPageFwd") + '" class="roundButton" style="background-image:url(images/icons/rec_fast_forward.gif)" onclick="' + i._var + '.changePage(1)" title="Next Page"><\/button><\/td><td><button id="' + i._("btnQueryNewRec") + '" class="roundButton" style="margin-left:7px;background-image:url(images/icons/rec_new.gif)" onclick="' + i._var + '.newRec()" title="New Record (INS key)"><\/button><\/td><td><button id="' + i._("btnQueryDelRec") + '" class="roundButton" style="background-image:url(images/icons/rec_del.gif)" onclick="' + i._var + '.delRec()" title="Delete Record (DEL key)"><\/button><\/td><td><button id="' + i._("btnQueryRefr") + '" class="roundButton" style="margin-left:7px;background-image:url(images/icons/rec_refresh.gif)" onclick="' + i._var + ".refresh(" + i._var + '.lastGoodQuery)" title="Refresh Data"><\/button><\/td><td><button id="' + i._("btnQueryApply") + '" class="roundButton" style="background-image:url(images/icons/rec_apply.gif)" onclick="' + i._var + '.updateCurrentRecord()" title="Apply Changes"><\/button><\/td><td><button id="' + i._("btnQueryCancel") + '" class="roundButton" style="background-image:url(images/icons/rec_cancel.gif)" onclick="' + i._var + '.cancelUpdate()" title="Discard Changes"><\/button><\/td>' + (f ? '<td><button id="' + i._("btnQueryRun") + '" class="roundButton" style="margin-left:7px;background-image:url(images/icons/rec_forward.gif)" onclick="' + i._var + '.refresh()" title="Run Query (F2)"><\/button><\/td><td><button id="' + i._("btnQueryFav") + '" class="roundButton" style="margin-left:7px;background-image:url(' + IMG_FAVOURITES_ADD + ')" onclick="' + i._var + '.addToFav()" title="Add to Favorites"><\/button><\/td><td><button id="' + i._("btnQueryRef") + '" class="roundButton" style="background-image:url(' + IMG_CLOCK + ')" onclick="' + i._var + '.showAutoRefreshMenu()" title="Query Auto Repeat"><\/button><\/td>' : "") + '<td><button id="' + i._("btnQueryExp") + '" class="roundButton" style="' + (f ? "" : "margin-left:7px;") + "background-image:url(" + IMG_EXPORT + ')" onclick="' + i._var + '.export()" title="Export Data"><\/button><\/td><\/tr><\/table><div id="' + i._("phQueryData") + '" data-sticky="0,0,38,0">' + (f ? '\t<div id="' + i._("phQuery") + '" data-sticky="0,0,0," style="min-height:62px;height:' + a + 'px" data-dropzone="1">' + t + '<\/div>\t<div data-sticky="0,0,' + a + '," class="vSplitter" onmousedown="StartVSplitter(event,$$(\'' + i._("phQuery") + "'),this,$$('" + i._("phGrid") + "'),null," + i._var + '.__handleVSplit)"><\/div>' : "") + '\t<div id="' + i._("phGrid") + '" data-sticky="0,0,' + (f ? a + 5 + ",25" : "0,0") + '"><\/div>\t<div id="' + i._("phStatus") + '" data-sticky="0,0,,0" style="display:' + (f ? "" : "none") + ';height:24px;padding-left:3px;line-height:25px;border-top:none;background-color:#ffffe1;font-weight:bold" class="border"><\/div><\/div>', ValidateLayout(y), r = new DataGrid(i.$("phGrid"), {
            minColumnWidth: 50,
            selectable: !0,
            multiselect: !0,
            onEditSave: function(n, t) {
                n.editedRecord._set(n.editedDataField, t), h()
            },
            onBeforeSort: function(n, t) {
                if (!u || !u.rowCount || APP.showQueryRowNums && t.index == 0) return !1;
                if (o || s && s._changed) return Alert(RES.sort_unavailable), !1;
                if (!f) {
                    var r, e;
                    return n.sortColumnIndex != t.index ? (r = t.index, e = !1) : n.sortDescending == !0 ? r = -1 : (r = t.index, e = !0), ht = r, ct = e, st = r > -1 ? " ORDER BY `" + u.fieldNames[t.dataField] + "`" + (e ? " DESC" : "") : "", i.refresh(), !1
                }
            },
            onAfterSort: h,
            onSelect: function() {
                i.updateCurrentRecord(), h()
            }
        }), i._addToDeathList(r), f && (v = new Combo(i.$("phDBs"), function() {
            return n.getHost().children.map(function(n) {
                if (n.objType == "database") return n
            })
        }, 150, n.getDB(), i.setDefaultDB, RES.select_a_database), e = new CodeEditor(i.$("phQuery"), {
            lineNumbers: !1,
            onChange: function() {
                var n = e.getValue().trim();
                ot && n || h(), ot = n
            }
        }), l = t.indexOf("$$"), l > -1 && (t = t.replace("$$", "")), e.fill(t), l > -1 && e.setCursor(0, l), i._addToDeathList([v, e]), setTimeout(e.focus, 100)), ut && i.refresh(null), h()
    }, i.export = function() {
        f ? new PopupExportData(n.getDB() || n.getHost(), (e.getSelection() || e.getValue()).trim()) : n.contextMenuHandler({
            label: "Export Data"
        })
    }, i.showAutoRefreshMenu = function() {
        if (a) {
            w(0);
            return
        }
        Confirm("How often should this query run (in seconds)?", "Query Auto Repeat", ft, function(n) {
            var t = parseFloat(n);
            if (isNaN(t)) return alert("Please enter a number greater than zero"), !1;
            CallLater(function() {
                w(t)
            })
        })
    }, i.showPageSelector = function() {
        if (f && (!u || !u.pageCount)) {
            Alert("Please select some data first");
            return
        }
        Confirm("Go to page number (" + (u.pageSize || APP.queryPageSize) + " rows per page)", "Go to Page", (f ? u.page : parseInt(l / APP.queryPageSize)) + 1, function(n) {
            n = parseInt(n), !isNaN(n) && n > 0 && i.changePage(null, n - 1)
        })
    }, i.setDefaultDB = function(t) {
        typeof t == "string" && (t = n.getHost().getChildByName(t)), n = i.updateSubject(t), v.selectItem(t, !0), i.updateLabels()
    }, i.addToFav = function() {
        var t = new FavouriteQuery(n.getHost().favourites, "", (e.getSelection() || e.getValue()).trim(), v.selectedItem ? v.selectedItem.name : "");
        t.temp = !0, n.getHost().favourites.editQuery(t)
    }, i.updateCurrentRecord = function(n) {
        !n && s && (o || s._changed) && kt(), s = r.selectedItem, s && s.watchChanges()
    }, i.delRec = function(t) {
        var u = r.selectedItems.length;
        if (u) {
            if (!t) {
                YesNoDialog("Delete " + u + " record" + (u > 1 ? "s" : "") + " from table `" + p + "`?", function() {
                    i.delRec(!0)
                }, r.focus);
                return
            }
            var o = "DELETE FROM " + c + " WHERE ",
                f = [],
                e = [];
            r.selectedItems.map(function(n) {
                var t = d(n);
                f.push(o + t[0].join(" AND ") + " LIMIT 1"), e.push(t[1])
            }), n.sendQuery(f, function(n) {
                b(n), i.refresh(null, !0)
            }, e)
        }
    }, i.newRec = function() {
        if (c) {
            o = !0;
            var n = {};
            r.selectedIndex > -1 ? r.data.splice(r.selectedIndex + 1, 0, n) : r.data.push(n), r.refreshData(), r.selectItem(n), i.updateCurrentRecord(!0), u.fields.map(function(t, i) {
                var r = t["default"];
                r === "" || r === null ? n._set(i, t.notNull ? t.type == "number" && !t.autoInc ? 0 : "" : null) : (r && r.toUpperCase() == "CURRENT_TIMESTAMP" && (r = {
                    label: r,
                    action: r
                }), n._set(i, r))
            }), r.refreshRow(), h()
        }
    }, i.cancelUpdate = function() {
        o ? (r.data.splice(r.data.indexOf(s), 1), r.refreshData(), s.unwatchChanges(), o = !1) : s && (s.undoChanges(), s.unwatchChanges(), r.refreshRow(), i.updateCurrentRecord(!0)), h()
    }, i.refresh = function(n, t, r) {
        i.killResult(function() {
            dt(n, t, r)
        })
    }, i.killResult = function(t) {
        u && u.outFile ? n.sendReq("data.php", {
            action: "kill_query_result",
            file: u.outFile
        }, t) : t && t()
    }, i.changeResult = function(n, t) {
        u.selectResult(u.resultIndex + n, function() {
            pt(t)
        })
    }, i.changePage = function(n, t) {
        if (f) {
            u.selectPage(t === undefined ? u.page + n : t, function() {
                pt(!0)
            });
            return
        }
        t === undefined ? l += APP.queryPageSize * n : l = APP.queryPageSize * t, l < 0 && (l = 0), i.refresh()
    }, i.handleKeyDown = function(n) {
        var u = e && e.checkInFocus() || r.editor,
            t = n.keyCode,
            s;
        t == 113 && f && !i.$("btnQueryRun").disabled ? (s = u ? e : document.activeElement, i.refresh(), s.focus()) : t != 46 || u ? t != 45 || u ? t == 27 && o && !r.editor ? (i.cancelUpdate(), r.focus()) : i.__handleKeyDown(n) : i.$("btnQueryNewRec").disabled || i.newRec() : i.$("btnQueryDelRec").disabled || i.delRec()
    }, i.show = function() {
        f && TREE.enableDrag(["database", "table", "view", "procedure", "function", "event", "trigger"], function() {
            e.showDropZone(1), ValidateLayout(e.elem), TREE.focus()
        }, function(n) {
            e.showDropZone(0), n == i.$("phQuery") && e.addText(TREE.selectedItem.getFullName())
        })
    }, i.close = function() {
        i.killResult(), TREE.disableDrag(), CloseWindow(i)
    }, i.hide = function() {
        TREE.disableDrag()
    }, i
}

function FillerTableServices(n, t) {
    function o() {
        DisableElem(i._("btnWork"), e.map(function(n) {
            if (n.selected) return !0
        }).length == 0), h = u.selectedIndex > 1 ? "QUICK" : "", u.selectedIndex == 2 ? f.setData([{
            label: "QUICK",
            tooltip: "Do not scan the rows to check for incorrect links."
        }, {
            label: "FAST",
            tooltip: "Check only tables that have not been closed properly."
        }, {
            label: "CHANGED",
            tooltip: "Check only tables that have been changed since the last check or that have not been closed properly."
        }, {
            label: "MEDIUM",
            tooltip: "Scan rows to verify that deleted links are valid. This also calculates a key checksum for the rows and verifies this with a calculated checksum for the keys."
        }, {
            label: "EXTENDED",
            tooltip: "Do a full key lookup for all keys for each row. This ensures that the table is 100% consistent, but takes a long time."
        }], h) : u.selectedIndex == 3 ? f.setData([{
            label: "QUICK",
            tooltip: "Try to repair only the index file, and not the data file"
        }, {
            label: "EXTENDED",
            tooltip: "MySQL creates the index row by row instead of creating one index at a time with sorting."
        }, {
            label: "USE_FRM",
            tooltip: "Use if the .MYI index file is missing or if its header is corrupted. This option tells MySQL not to trust the information in the .MYI file header and to re-create it using information from the .frm file."
        }], h) : (f.setData(null), h = ""), f.setDisabled(u.selectedIndex < 2)
    }
    var i = new FillerBase(n),
        r, u, f, s = !0,
        h, e = n.tables.map(function(n) {
            if (!n.temp) return {
                selected: !0,
                name: n.name,
                status: "",
                note: ""
            }
        });
    return i.getLabel = function() {
        return "Services:" + n.name
    }, i.fill = function(n) {
        i.__fill(n, [440, null], '<div class="buttons">\t<button id="' + i._("btnWork") + '" style="width:70px;background-image:url(' + IMG_ACCEPT + ')" disabled="disabled" onclick="' + i._var + '.work()">Work<\/button>&nbsp;\t<button style="width:70px;background-image:url(' + IMG_CANCEL + ')" onclick="' + i._var + '.close()">Close<\/button><\/div>').innerHTML = '<table data-sticky="0,,4," cellpadding="5"><tr><td>Action<\/td><td id="' + i._("phCmbTask") + '"><\/td><td id="' + i._("phCmbMethodTitle") + '">&nbsp;&nbsp;&nbsp;Method<\/td><td id="' + i._("phCmbMethod") + '"><\/td><\/tr><\/table><div id="' + i._("phGrid") + '" data-sticky="0,0,40,0"><\/div>', u = new Combo(i.$("phCmbTask"), Labelize("Analyze", "Optimize", "Check", "Repair"), 150, t, o), f = new Combo(i.$("phCmbMethod"), [], 150), r = new DataGrid(i.$("phGrid"), {
            selectable: !0,
            onSelect: o,
            onEditSave: function(n, t) {
                n.editedDataField && n.editedRecord._set(n.editedDataField, t), o()
            }
        });
        var h = [{
            title: "",
            resizable: !1,
            dataField: "selected",
            width: 40,
            renderer: DataGridCheckBoxRenderer,
            onClick: function(n, t, i, u) {
                DataGridCheckBoxClickHandler(n, t, i, u), s = e.map(function(n) {
                    if (n.selected) return 1
                }).length == e.length, o(), r.createHeaders()
            },
            headerRenderer: function() {
                return '<div style="padding-left:2px;cursor:default">' + DataGridCheckBoxRenderer([
                    [s]
                ], 0, {
                    dataField: 0
                }) + "<\/div>"
            },
            onHeaderClick: function() {
                s = !s, e.map(function(n) {
                    n.selected = s
                }), r.refreshData(), r.createHeaders(), o()
            }
        }, {
            title: "Table",
            dataField: "name",
            width: 150,
            editable: !1
        }, {
            title: "Status",
            dataField: "status",
            width: 150,
            editable: !1
        }, {
            title: "Info / Note / Warning / Error",
            dataField: "note",
            width: 400,
            editable: !1
        }];
        r.create(h), r.setData(e), i._addToDeathList([r, u, f]), o()
    }, i.work = function() {
        var t = [],
            i = e.map(function(n) {
                return n.status = n.note = "", n.selected ? (t.push(n), "`" + n.name + "`") : void 0
            });
        r.refreshData(), n.sendQuery(u.selectedItem.label.toUpperCase() + " TABLE " + i.join(", ") + " " + h, function(n) {
            for (var i, f, e, u = 0; u < n.data.length; u++) i = n.data[u], i.status = "", i.note = "", f = i[2] == "status" ? i[2] : "note", i[f] = i[3], u > 0 && (e = n.data[u - 1], i[0] == e[0] && (e[f] += (e[f] ? "<br />" : "") + i[3], n.data.splice(u, 1), u--));
            n.data.map(function(n, i) {
                t[i].status = n.status, t[i].note = n.note
            }), r.refreshData()
        })
    }, i.close = function() {
        CloseWindow(i)
    }, i
}

function DataGridDefaultValueEditor(n) {
    var t = new DataGridEditorBase(n),
        i;
    return t.open = function() {
        var r = n.editedRecord.type,
            f = r == "TIMESTAMP" || r == "DATETIME" && n.editedRecord.parent.getHost().checkVersion("5.6.5"),
            s = r.search(/int|float|double|decimal/i) > -1,
            h = r.search(/text|blob/i) > -1,
            c = f ? 180 : s ? 160 : 110,
            o = CreateElem("div"),
            e, u;
        o.style.margin = "5px", o.innerHTML = '<div style="margin:5px"><label><input id="__dgEdRad1" tabindex="0" name="defRad" type="radio" onclick="' + t._var + '.handleRadio(1)" />No default value<\/label><br /><label><input id="__dgEdRad2" name="defRad" type="radio" onclick="' + t._var + '.handleRadio(1)" />NULL<\/label><br/>' + (f ? '<label><input id="__dgEdRad3" name="defRad" type="radio" onclick="' + t._var + '.handleRadio(1)" />CURRENT_TIMESTAMP<\/label><br />' : "") + (h ? "" : '<label><input id="__dgEdRad4" name="defRad" tabindex="0" type="radio" onclick="' + t._var + '.handleRadio(0)" />Custom:<\/label><br/><textarea id="__dgEdTxt" tabindex="0" style="height:33px; width:200px; margin:5px"><\/textarea><br />') + (s ? '<label><input id="__dgEdRad5" name="defRad" type="radio" />AUTO_INCREMENT<\/label><br />' : "") + (f ? '<label><input id="__dgEdChk1" type="checkbox" />On update CURRENT_TIMESTAMP<\/label><br />' : "") + '<div class="buttons" style="text-align:center; margin-top:10px">\t<button id="__dgEdBtn1" tabindex="0" style="background-image:url(' + IMG_ACCEPT + ')" onclick="' + t._var + '.update(1)">Save<\/button>&nbsp;&nbsp;\t<button id="__dgEdBtn2" tabindex="0" style="background-image:url(' + IMG_CANCEL + ')" onclick="' + t._var + '.update()">Cancel<\/button><\/div><\/div>', r = t.createBaseElem("div", -1, 0, 240, o.clientHeight + 15), r.style.border = "1px solid #adadad", r.style.backgroundColor = "white", r.appendChild(o), $$("__dgEdBtn2").focus(), t.addEditorEvents(), t.ignoreEnter = !0, t.ignoreTab = !0, i = setInterval(function() {
            document.activeElement == document.body || DiveToElem(document.activeElement, r) || $$("__dgEdBtn2").focus()
        }, 100), e = n.editedRecord, u = e.defValue, e.withNoDefault && u !== null && (u = undefined), h || ($$("__dgEdTxt").disabled = !0), s && e.autoInc ? $$("__dgEdRad5").checked = "checked" : u === undefined ? $$("__dgEdRad1").checked = "checked" : u === null ? $$("__dgEdRad2").checked = "checked" : f && u.toLowerCase() == "current_timestamp" ? $$("__dgEdRad3").checked = "checked" : h || ($$("__dgEdRad4").checked = "checked", $$("__dgEdTxt").disabled = !1, $$("__dgEdTxt").value = u), f && e.onUpdateTimestamp && ($$("__dgEdChk1").checked = "checked")
    }, t.handleRadio = function(n) {
        $$("__dgEdTxt") && ($$("__dgEdTxt").disabled = n ? "disabled" : "")
    }, t.update = function(i) {
        if (!i) {
            t.__close(null, !1);
            return
        }
        var r = n.editedRecord;
        $$("__dgEdRad5") && $$("__dgEdRad5").checked ? (r._set("autoInc", !0), r._delete("defValue")) : (r._set("autoInc", !1), r._set("defValue", $$("__dgEdRad1").checked ? undefined : $$("__dgEdRad2").checked ? null : $$("__dgEdRad3") && $$("__dgEdRad3").checked ? "CURRENT_TIMESTAMP" : $$("__dgEdTxt") ? $$("__dgEdTxt").value : "")), $$("__dgEdChk1") && r._set("onUpdateTimestamp", $$("__dgEdChk1").checked ? !0 : !1), t.__close(null, !0)
    }, t.close = function(t) {
        t && n.saveEditor(n.editedRecord.defValue), clearInterval(i)
    }, t
}

function DataGridIndexColumnsEditor(n, t) {
    function f() {
        var n = i.selectedIndex;
        DisableElem("__dgEdUp", n < 1, .5), DisableElem("__dgEdDown", n < 0 || n >= u.length - 1, .5)
    }
    var r = new DataGridEditorBase(n, !0),
        e, i, u = [];
    return r.moveRow = function(n) {
        i.moveRow(n), t && t(u), f()
    }, r.open = function() {
        var o = r.createBaseElem("div", -1, 0, 400, 260),
            h, s;
        o.style.backgroundColor = "white", o.style.border = "1px solid gray", o.innerHTML = '<div id="__dgEdGrid' + n._id + '" data-sticky="3,3,3,35"><\/div><div class="buttons" data-sticky="5,5,,5">\t<button id="__dgEdBtn1" onclick="' + r._var + '.__close(null,true)" style="background-image:url(' + IMG_ACCEPT + ')">Close<\/button>\t<button id="__dgEdDown" class="roundButton" onclick="' + r._var + '.moveRow(false)" style="margin-left:210px;background-image:url(' + IMG_DOWN + ')"><\/button>\t<button id="__dgEdUp" class="roundButton" onclick="' + r._var + '.moveRow(true)" style="margin-right:5px;background-image:url(' + IMG_UP + ')"><\/button><\/div>', ValidateLayout(o), i = new DataGrid($$("__dgEdGrid" + n._id), {
            selectable: !0,
            resizable: !1,
            scrollbars: "vertical",
            onSelect: f,
            onEditBeginning: function(n) {
                if (n.editedValue == null) return !1
            },
            onEditSave: function(n, r) {
                i.editedDataField && i.editedRecord._set(i.editedDataField, r), f(), t && t(u)
            }
        }), h = [{
            title: "Use",
            dataField: "selected",
            width: 40,
            renderer: DataGridCheckBoxRenderer,
            onClick: DataGridCheckBoxClickHandler
        }, {
            title: "Column",
            dataField: "name",
            width: 177,
            editable: !1,
            selectable: !1,
            style: "opacity:0.9"
        }, {
            title: "Data Type",
            dataField: "type",
            width: 90,
            editable: !1,
            selectable: !1,
            style: "opacity:0.9"
        }, {
            title: "Prefix Len",
            dataField: "prefixLen",
            width: 70,
            editable: !0,
            editor: new ClassFactory(DataGridNumberEditor, i, 0, 4096)
        }], i.create(h), s = ["CHAR", "VARCHAR", "BINARY", "VARBINARY", "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT"], n.editedRecord.columns.map(function(t) {
            var r = n.editedRecord.parent.columns.findByProp("name", t.name),
                i = n.editedRecord.parent.columns[r].type.toUpperCase();
            u.push({
                selected: !0,
                name: t.name,
                type: i,
                prefixLen: t.prefixLen != null ? t.prefixLen : s.contains(i) ? 0 : null
            })
        }), n.editedRecord.parent.columns.map(function(n) {
            u.findByProp("name", n.name) > -1 || u.push({
                selected: !1,
                name: n.name,
                type: n.type,
                prefixLen: s.contains(n.type.toUpperCase()) ? 0 : null
            })
        }), i.setData(u), i.updateScrolls(), f(), r.addEditorEvents(), r.ignoreEnter = !0, r.ignoreTab = !0, e = setInterval(function() {
            document.activeElement == document.body || DiveToElem(document.activeElement, o) || i.editor && DiveToElem(document.activeElement, r.elem) || !i.editor || document.activeElement == i.editor.input || $$("__dgEdBtn1").focus()
        }, 100)
    }, r.close = function(t) {
        t && n.saveEditor(null), clearInterval(e), i.destroy()
    }, r
}

function DataGridColumnsSelectEditor(n, t, i) {
    var u = new DataGridEditorBase(n, !0),
        f, r;
    return u.open = function() {
        var e = u.createBaseElem("div", -1, 0, 300, 260),
            o;
        e.style.backgroundColor = "white", e.style.border = "1px solid gray", e.innerHTML = '<div id="__dgEdGrid' + n._id + '" data-sticky="3,3,3,35"><\/div><div class="buttons" data-sticky="5,5,,5">\t<button id="__dgEdBtn1" onclick="' + u._var + '.__close(null,true)" style="background-image:url(' + IMG_ACCEPT + ')">Close<\/button><\/div>', ValidateLayout(e), r = new DataGrid($$("__dgEdGrid" + n._id), {
            selectable: !0,
            resizable: !1,
            scrollbars: "vertical",
            onEditBeginning: function(n) {
                if (n.editedValue == null) return !1
            },
            onEditSave: function(n, u) {
                r.editedDataField && r.editedRecord._set(r.editedDataField, u), i && i(t)
            }
        }), o = [{
            title: "Use",
            dataField: "selected",
            width: 40,
            renderer: DataGridCheckBoxRenderer,
            onClick: DataGridCheckBoxClickHandler
        }, {
            title: "Column",
            dataField: "name",
            width: 238,
            editable: !1,
            selectable: !1,
            style: "opacity:0.9"
        }], r.create(o), r.setData(typeof t == "function" ? t() : t), r.updateScrolls(), u.addEditorEvents(), u.ignoreEnter = !0, u.ignoreTab = !0, f = setInterval(function() {
            document.activeElement == document.body || DiveToElem(document.activeElement, e) || r.editor && DiveToElem(document.activeElement, u.elem) || !r.editor || document.activeElement == r.editor.input || $$("__dgEdBtn1").focus()
        }, 100)
    }, u.close = function(t) {
        t && n.saveEditor(null), clearInterval(f), r.destroy()
    }, u
}

function CreateEncodingsCombo(n, t) {
    return new Combo($$(n), Labelize(APP.hostInfo.encodings || []), 130, "UTF-8", t, APP.hostInfo.encodings ? "" : "Not supported")
}

function CreateDefinersCombo(n, t, i, r) {
    return new Combo($$(n), function() {
        return i.getHost().users
    }, t, i.definer, r)
}

function GetIconWithLabel(n) {
    return '<div style="background-image:url(' + n.icon + ');background-repeat:no-repeat;background-position:left center;padding-left:20px">' + (n.objType == "procedure" ? "proc" : n.objType == "function" ? "func" : n.objType).capitalize() + "<\/div>"
}

function Init() {
    function n() {
        APP.load(function() {
            APP.attachEventListener("change", function(n, t) {
                var i = t.target;
                for (TREE.refresh(), TREE.selectItem(i), UpdateTopMenu(i); i;) TREE.foldUnfold(i, !0), i = i.parent
            }), setInterval(function() {
                $$("phTime").innerHTML = "Web Server Time: " + APP.getServerTime() + " UTC"
            }, 1e3), InitGui()
        })
    }
    ValidateLayouts(), HTTPComm.encryptKey = sessionStorage.getItem("passwd") || "", APP = new App, APP.attachEventListener("configUpdated", function() {
        $$("phLock").innerHTML = '<img src="images/icons/lock_large' + (APP.encrypt ? "" : "_warn") + '.png" onclick="new PopupAppSettings(APP, 1)" title="Your connection is ' + (APP.encrypt ? "encrypted\n(except file upload/download)" : "not encrypted") + '" />', HTTPComm.defaultTimeout = APP.reqTimeout * 1e3;
        var n = GetWindow(FillerWelcome, APP);
        n && n.show()
    }), HTTPComm.encryptKey ? n() : APP.relogin(n)
}

function InitGui() {
    function n() {
        var n = (document.body.clientWidth < 900 ? 1 : 0) + (document.body.clientHeight < 550 ? 2 : 0);
        n ? (RESWARN || (RESWARN = (new Dialog).show('<img id="imgResWarn" style="float:left;margin:-8px 10px 0 0"/>Window size is too small for DbNinja to display correctly.<br />Please enlarge your browser window.', null, "Warning", 400)), n != RESDIR && ($$("imgResWarn").src = "images/gui/resize_" + (n == 3 ? "both" : n == 1 ? "width" : "height") + ".gif"), RESDIR = n) : RESWARN && (RESWARN.close(), RESWARN = RESDIR = null)
    }
    TREE = new Tree($$("phTree"), APP.children, UpdateTopMenu, 1, "1,1,1,1", '<div class="buttons" style="text-align:center;padding-top:10px">\t<div style="font-weight:bold">START HERE!<\/div>\t<div><img src="' + IMG_DOWN + '" /><\/div>\t<button onclick="new PopupAppSettings(APP,0)" style="background-image:url(' + IMG_SERVER_EDIT + ')">Manage Hosts<\/button><\/div>'), NAV = new TabNav($$("phMain"), WINDOWS, function(n) {
        TREE.selectItem(n.subject)
    }, function(n) {
        n.__close ? n.__close() : n.close()
    }, "0,0,0,0", !0), TOPMENU = new ListBoxTopMenu($$("phMenu")), ICNMENU1 = new IconMenu($$("phIcons1")), ICNMENU2 = new IconMenu($$("phIcons2")), UpdateTopMenu(APP), RESWARN = null, RESDIR = null, AddResizeCallback(n), n(), TimerResizeValidate = 0, AddResizeCallback(function() {
        clearTimeout(TimerResizeValidate), TimerResizeValidate = setTimeout(ValidateLayouts, 50)
    }), OpenWindow(FillerWelcome, APP), $$("phHide").style.visibility = "visible", ValidateLayouts()
}

function GetWindow(n, t) {
    return WINDOWS.map(function(i) {
        if (i.filler == n && i.subject == t) return i
    }, !0)
}

function OpenWindow(n, t, i, r) {
    var u, f;
    return !r && (u = GetWindow(n, t), u) ? (NAV.selectItem(u), u.reopen && u.reopen(t, i), u) : (f = new n(t, i), f.filler = n, WINDOWS._push(f), NAV.selectIndex(WINDOWS.length - 1), f)
}

function CloseWindow(n) {
    if (!n) {
        WINDOWS._clear();
        return
    }
    var t = WINDOWS.indexOf(n);
    WINDOWS._remove(n), WINDOWS.length && (t == WINDOWS.length && t--, NAV.selectIndex(t))
}

function CloseAllWindows(n, t, i) {
    for (var u, r = 0; r < WINDOWS.length; r++)
        if (u = WINDOWS[r], n == u.subject || n.hasOffspring && n.hasOffspring(u.subject)) {
            if (!u.canClose() && !t) {
                YesNoDialog("Some windows have unsaved changes. Discard changes and continue?", function() {
                    CloseAllWindows(n, !0, i)
                });
                return
            }
            CloseWindow(u), r--
        } i && i()
}

function ShowHideQueryLog() {
    __queryLog = !__queryLog, $$("phSql").style.display = __queryLog ? "block" : "none", SetSticky($$("phHide"), 3, __queryLog ? 160 : 5, !0), ValidateLayout($$("phSql"))
}

function UpdateTopMenu(n) {
    var t = n.getHost(),
        r = n.getDB(),
        i = n.parent && n.parent.objType == "group" ? n : null;
    TOPMENU.create([{
        label: "DbNinja",
        children: [{
            label: "Premium Services",
            action: function() {
                OpenWindow(FillerPremTools, APP).refresh()
            },
            disabled: !0,
            icon: IMG_AWARD
        }, null, {
            label: "Settings",
            action: function() {
                new PopupAppSettings(APP)
            },
            icon: IMG_SETTINGS
        }, null, {
            getLabel: function() {
                return (__queryLog ? "Hide" : "Show") + " Query Log"
            },
            icon: IMG_LOG,
            action: ShowHideQueryLog
        }]
    }, {
        label: "Host",
        disabled: !t,
        children: t ? t.getContextMenuItems() : null,
        handler: t ? t.contextMenuHandler : null
    }, {
        label: "Database",
        disabled: !r,
        children: r ? r.getContextMenuItems() : null,
        handler: r ? r.contextMenuHandler : null
    }, {
        label: i ? i.objType.capitalize() : "Object",
        disabled: !i,
        children: i ? i.getContextMenuItems() : null,
        handler: i ? i.contextMenuHandler : null
    }, {
        label: "Help",
        children: [{
            label: "Show Welcome Screen",
            action: function() {
                OpenWindow(FillerWelcome, APP)
            }
        }, null, {
            label: "Report a Bug",
            href: "http://" + DBNINJAWS + "/?page=bug-report",
            target: "_blank",
            icon: IMG_BUG
        }, null, {
            label: "Licensing Info",
            href: "http://" + DBNINJAWS + "/?page=resources&z=300",
            target: "_blank"
        }, {
            label: "About",
            action: APP.about
        }]
    }]), t = n.getHost(), r = n.getDB(), i = t && t.connected, ICNMENU1.create([{
        icon: IMG_SETTINGS,
        title: "DbNinja Settings",
        action: function() {
            new PopupAppSettings(APP)
        }
    }, {
        icon: IMG_GROUP,
        title: "User Manager",
        disabled: !i,
        action: function() {
            OpenWindow(FillerUserManager, t)
        }
    }, {
        icon: IMG_DATABASE_SAVE,
        title: "Export Database to Script",
        disabled: !r,
        action: function() {
            new PopupExportDB(r)
        }
    }, {
        icon: IMG_SCRIPT_ADD,
        title: "Execute SQL Script",
        disabled: !i,
        action: function() {
            t.uploadScript()
        }
    }, {
        icon: IMG_COMPARE,
        title: "Compare Databases",
        disabled: !i,
        action: function() {
            OpenWindow(FillerCompare, null, null, !0)
        }
    }, null, {
        icon: IMG_QUERY,
        title: "Query Editor",
        disabled: !i,
        action: function() {
            OpenWindow(FillerQuery, r || t, "", !0)
        }
    }, {
        icon: IMG_LOG,
        title: "Show/Hide Query Log",
        action: ShowHideQueryLog
    }]), ICNMENU2.create([{
        icon: IMG_BUG,
        title: "Submit Bug Report",
        href: "http://" + DBNINJAWS + "/?page=bug-report",
        target: "_blank"
    }, {
        icon: IMG_HELP,
        title: "MySQL Reference",
        action: function() {
            Confirm("Please enter a search term", "Search MySQL Help", "", function(n) {
                window.open("http://search.oracle.com/search/search?group=MySQL&q=" + n, "_target")
            })
        }
    }, null, {
        icon: IMG_EXIT,
        title: "Log out",
        href: "./"
    }])
}

function LogSQL(n) {
    if (Array.isArray(n)) {
        n.map(function(n) {
            LogSQL(n)
        });
        return
    }
    var t = $$("phSql"),
        r = CreateElem("div", t),
        i = t.childNodes.length;
    i > 1 && !t.childNodes[i - 2].style.backgroundColor && (r.style.backgroundColor = "#eeeeee"), i > 100 && t.removeChild(t.childNodes[0]), r.innerHTML = "&gt; " + EscapeHtml(n.substr(0, 2e3)), t.scrollTop = t.scrollHeight
}

function HandleSelect(n) {
    var t = $target(n),
        i;
    return t.tagName && ["input", "textarea", "pre"].contains(t.tagName.toLowerCase()) ? !0 : (i = !1, DiveToElem(t, document, !1, function(n) {
        if (n.className) {
            var t = n.className.split(" ");
            (t.contains("codemirror") || t.contains("selectable")) && (i = !0)
        }
    }), i)
}

function HandleKeyDown(n) {
    if (typeof NAV != "undefined" && !ScreenBlock.isBlocking) {
        var t = NAV.getSelectedItem();
        t && t.handleKeyDown && t.handleKeyDown(n)
    }
}

function HandleBodyMouseDown(n) {
    window.opera && !HandleSelect(n) && (n.target.unselectable = "on")
}

function HandleUnload() {
    if (!(navigator.appName.indexOf("Microsoft") > -1) || !__inIfr) return RES.window_unload_message
}

function DownloadFile(n, t) {
    __inIfr = !0, $$("phIfr").innerHTML = '<iframe id="ifr" src="about:blank" onreadystatechange="__inIfr=(readyState==\'loading\')"><\/iframe>', $$("ifr").src = "data.php?action=download&file=" + n + (t ? "&alias=" + t : "")
}

function ParseView(n) {
    var i = n.match(/^create(.+?)view (.+?) as (select.+?)(?: with (cascaded|local) check option){0,1}$/i),
        t, r, u, f, e;
    return i ? (t = i[1].match(/algorithm=(undefined|merge|temptable)/i), r = t ? t[1] : "", t = i[1].match(/definer=(.+?) /i), u = t ? t[1].replace(/`/g, "") : "", t = i[1].match(/sql security (definer|invoker)/i), f = t ? t[1] : "", e = i[4] || "", {
        algorithm: r,
        definer: u,
        sqlSecurity: f,
        checkOption: e,
        code: i[3]
    }) : null
}

function FixDataTypeName(n) {
    switch (n.toLowerCase()) {
        case "integer":
            return "int";
        case "double precision":
        case "real":
            return "double";
        case "dec":
        case "numeric":
        case "fixed":
            return "decimal";
        case "bool":
            return "boolean";
        case "serial":
            return "bigint"
    }
    return n.toLowerCase()
}

function ParseTable(n, t) {
    function p(n) {
        var i = {},
            t, r;
        return (t = n.match(/ comment[\x20=]'(.+?)'$/i)) && (n = n.substr(0, n.length - t[0].length), i.comment = t[1]), (t = n.match(/ on update current_timestamp/i)) && (i.onUpdateTimestamp = !0, n = n.substr(0, n.length - t[0].length)), (t = n.match(/ default '(.*?)'$| default ([^\x20]+)/i)) && (i.defValue = t[1] ? t[1] : t[2] == "NULL" ? null : t[2], n = n.substr(0, n.length - t[0].length)), (t = n.match(/ character set (\w+)/i)) && (i.charset = t[1]), (t = n.match(/ collate (\w+)/i)) && (i.collation = t[1]), t = n.match(/^(\w+)(?:\((.+?)\)){0,1}/), r = i.type = FixDataTypeName(t[1].toLowerCase()), r == "enum" || r == "set" ? i.values = t[2] : t[2] && (i.len = t[2]), n = n.toLowerCase(), n.indexOf("unsigned") > -1 && (i.unsigned = !0), n.indexOf("zerofill") > -1 && (i.zeroFill = !0), n.indexOf("binary") > -1 && (i.binary = !0), n.indexOf("not null") > -1 ? i.notNull = !0 : n.indexOf(" null") > -1 && (i.isNull = !0), n.indexOf("auto_increment") > -1 && (i.autoInc = !0), i
    }
    for (var e = {
        columns: [],
        indices: [],
        fkeys: []
    }, n, o = n.split("\n"), f, i, c, r, u = 1; u < o.length - 1; u++)
        if (n = o[u].replace(/^\s+|,$/gm, ""), i = n.match(/^`(.+?)`/), i) r = p(n.substr(i[0].length + 1)), r.name = i[1], e.columns.push(r);
        else if (!t)
            if (i = (n + " ").match(/^constraint `(.*?)` foreign key \((.+?)\) references (.+?) (.*)/i), i) {
                var s = i[4],
                    l = "",
                    a = "RESTRICT",
                    v = "RESTRICT";
                s && (f = s.match(/^\((.+?)\)/), f && (l = f[1]), f = s.match(/on delete (restrict|cascade|set null|no action)/i), f && (a = f[1].toUpperCase()), f = s.match(/on update (restrict|cascade|set null|no action)/i), f && (v = f[1].toUpperCase()));
                var h = i[3].replace(/`/g, ""),
                    y = "",
                    r = h.split(".");
                r.length > 1 && (y = r[0], h = r[1]), e.fkeys.push({
                    name: i[1],
                    columns: i[2].replace(/`/g, "").split(","),
                    refDB: y,
                    refTable: h,
                    refColumns: l.replace(/`/g, "").split(","),
                    onDelete: a,
                    onUpdate: v
                })
            } else i = n.match(/(?:(primary|unique|fulltext|spatial) ){0,1}(?:key|index)(?: `(.+?)`){0,1} \((`.+?`(?:\([0-9]+\)){0,1})+\)(?: using (\w+)){0,1}/i), i && (c = [], i[3].replace(/`/g, "").split(",").map(function(n) {
                var t = n.match(/^(.+?)(?:\((\d+)\)){0,1}$/);
                c.push({
                    name: t[1],
                    prefixLen: t[2] || null
                })
            }), e.indices.push({
                position: e.indices.length,
                type: i[1] || "NORMAL",
                name: i[2] || "PRIMARY",
                using: (i[4] || "DEFAULT").toUpperCase(),
                columns: c
            }));
    for (n = o[o.length - 1], (i = n.match(/ comment[\x20=]'(.+?)'$/i)) ? (e.comment = i[1], n = n.substr(0, n.length - i[1].length)) : e.comment = "", r = ["engine", "default charset", "collate", "checksum", "delay_key_write", "avg_row_length", "min_rows", "max_rows", "pack_keys", "row_format", "auto_increment"], u = 0; u < r.length; u++) i = n.match(new RegExp(r[u] + "=(\\w+)", "i")), e[r[u].replace(" ", "_")] = i ? i[1] : null;
    return e
}

function SmartString(n) {
    function o(n) {
        for (var i, t = 0; t < f.length; t++)
            if (i = f[t], n >= i[0] && n < i[1]) return !0
    }

    function s(t, i, r) {
        var f, u;
        for (i || (i = 0), f = r ? n.toLowerCase() : n, r && (t = t.toLowerCase());;) {
            if (u = f.indexOf(t, i), u == -1) return -1;
            if (o(u)) return u;
            i += t.length
        }
    }
    for (var f = [], t = 0, r = 0, u = "", e = 0, i; t < n.length;) {
        if (i = n.charAt(t), i == "\\" && !e) {
            e = 1, t += 1;
            continue
        }
        e || i != '"' && i != "'" && i != "`" || (u ? u == i && (u = "", r = t + 1) : (u = i, r != t && f.push([r, t]))), e = 0, t += 1
    }!u && r < n.length && f.push([r, t]), this.split = function(t, i) {
        for (var u = [], r = 0;;) {
            if (j = r, r = s(t, r, i), r == -1) {
                u.push(n.substr(j));
                break
            } else u.push(n.substring(j, r));
            r += t.length
        }
        return u
    }
}

function PopupDependencies(n) {
    function r(n, t, i, u, f) {
        var e = {
                label: i + (u ? " &nbsp;&nbsp;(" + u + ")" : "")
            },
            o = n.map(function(u) {
                if (u[3] == t && u[4] == i) {
                    var e = (u[0] == t ? "" : u[0] + ".") + u[1];
                    if (f.indexOf(e) == -1) return r(n, u[0], u[1], u[5] + " &#x21e8; " + u[2], [e].concat(f))
                }
            });
        return o.length && (e.children = o), e
    }
    var i, t = Storage.store(this, "PopupDependencies");
    return t.close = function() {
        Storage.dispose(t), i && i.close()
    }, n.sendQuery("SELECT TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME,REFERENCED_TABLE_SCHEMA,REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE REFERENCED_TABLE_NAME IS NOT NULL ORDER BY TABLE_NAME, COLUMN_NAME", function(u) {
        var f = r(u.data, n.getDB().name, n.name, "", []);
        if (!f.children) {
            Alert("Table has no dependencies");
            return
        }
        i = new Dialog(450, 460, ",5,,10"), i.show("", [{
            label: "Cancel",
            img: IMG_ACCEPT,
            action: function() {
                t.close()
            },
            onEscape: 1,
            selected: 1
        }], "Table Dependencies"), i.getContentElem().innerHTML = '<div id="' + t._("phText") + '" data-sticky="0,0,0,35" class="border"><\/div>', t._addToDeathList(new Tree(t.$("phText"), [f], null, 1, "1,1,1,1")), i.validateLayout()
    }), t
}

function PopupDelSelected(n) {
    function e() {
        r = [], n.iterateChildren(function(n) {
            if (!n.temp) {
                var t = n.clone(["name", "objType", "icon"]);
                r.push(t)
            }
        }), t.updateGrid(), t.updateButtons()
    }
    var t = Storage.store(this, "PopupDelSelected"),
        r = [],
        u = !1,
        f = new Dialog(380, 415, ",5,,10"),
        i;
    return f.show("", [{
        label: "Drop Selected",
        img: IMG_ACCEPT,
        action: function() {
            t.work()
        }
    }, {
        label: "Close",
        img: IMG_CANCEL,
        action: function() {
            t.close()
        },
        onEscape: 1,
        selected: 1
    }], "Drop Multiple Objects"), f.getContentElem().innerHTML = '<div id="' + t._("phGrid") + '" data-sticky="0,0,0,40"><\/div>', i = new DataGrid(t.$("phGrid"), {
        selectable: !0,
        resizable: !1,
        editable: !1,
        scrollbars: "vertical",
        scrollToView: !1,
        onEditSave: function() {
            t.updateButtons()
        }
    }), t._addToDeathList(i), t.updateGrid = function() {
        function n() {
            u = !u, r.map(function(n) {
                n.selected = u
            }), i.refreshData(), i.createHeaders(), t.updateButtons()
        }
        i.create([{
            title: "",
            dataField: "selected",
            width: 40,
            headerRenderer: function() {
                return '<div style="cursor:default;margin-left:3px">' + DataGridCheckBoxRenderer([
                    [u]
                ], 0, {
                    dataField: 0
                }) + "<\/div>"
            },
            renderer: DataGridCheckBoxRenderer,
            onClick: DataGridCheckBoxClickHandler,
            onHeaderClick: n
        }, {
            title: "Obj Type",
            dataField: "objType",
            width: 75,
            renderer: function(n, t) {
                return GetIconWithLabel(n[t])
            }
        }, {
            title: "Name",
            dataField: "name",
            width: 245
        }]), i.setData(r)
    }, t.updateButtons = function() {
        var t = r.map(function(n) {
                if (n.selected) return 1
            }).length,
            n;
        DisableElem(f.getButtonElem(0), t == 0), n = t == r.length, n != u && (u = n, i.createHeaders(), i.refreshData(!0))
    }, t.work = function() {
        var i = r.map(function(n) {
            if (n.selected) return "DROP " + n.objType.toUpperCase() + " `" + n.name + "`"
        });
        YesNoDialog("Drop " + i.length + " objects?", function() {
            n.sendQuery(i.join(";"), function() {
                n.reloadChildren(null, null, function() {
                    t.close(), Alert(RES.completed_successfully)
                })
            })
        })
    }, t.close = function() {
        Storage.dispose(t), f.close()
    }, f.validateLayout(), t.updateGrid(), t.updateButtons(), n.open ? (n.dispatchChange(), e()) : n.load(e), t
}

function PopupCompareObjects(n, t, i, r, u) {
    function o(n) {
        return n ? '<div style="background-image:url(' + IMG_SERVER_CONNECTED + ')" class="objCompareHeaderItem">' + n.getHost().name + ' &nbsp;&#9654<\/div><div style="background-image:url(' + IMG_DATABASE_OPEN + ')" class="objCompareHeaderItem">' + n.getDB().name + ' &nbsp;&#9654<\/div><div style="background-image:url(' + n.icon + ')" class="objCompareHeaderItem">' + n.name + "<\/div>" : ""
    }

    function s() {
        e.getContentElem().innerHTML = '<table data-sticky="0,,-3," cellpadding="6"><tr><td style="font-weight:bold">OLD ' + n.objType.capitalize() + "<\/td><td>" + o(n) + '<\/td><\/tr><tr><td style="font-weight:bold">NEW ' + i.objType.capitalize() + "<\/td><td>" + o(i) + '<\/td><\/tr><\/table><pre id="' + f._("txtCmp") + '" data-sticky="0,0,43,47" style="line-height:17px;outline:none;padding:3px;overflow:auto" class="border selectable" tabindex="0"><\/pre>', e.validateLayout();
        var u = new diff_match_patch,
            s = u.diff_linesToChars_(t, r),
            h = u.diff_main(s.chars1 || "", s.chars2 || "", !1);
        u.diff_charsToLines_(h, s.lineArray), f.$("txtCmp").innerHTML = u.diff_prettyHtml(h)
    }
    var f = Storage.store(this, "PopupCompareObjects"),
        e = new Dialog(800, 550, ",10,,10");
    return e.show("", [{
        label: "Swap Old-New",
        img: IMG_SWITCH,
        action: function() {
            f.swap()
        }
    }, {
        label: "Close",
        img: IMG_CANCEL,
        action: function() {
            f.close()
        },
        onEscape: 1,
        selected: 1
    }], u), f.swap = function() {
        var u = n;
        n = i, i = u, u = t, t = r, r = u, s()
    }, f.close = function() {
        Storage.dispose(f), e.close()
    }, s(), f
}

function PopupImportData(n) {
    function k() {
        l.create([{
            title: "Source Column",
            dataField: "srcColumn",
            width: 105,
            align: "center",
            selectable: !1,
            renderer: function(n, i) {
                var e, o, r;
                if (!u || !u.length) return "";
                for (e = n[i].srcColumn, o = [], r = 0; r < f; r++) o.push("<option" + (r == e ? ' selected="selected"' : "") + ' value="' + r + '">' + (r + 1) + "<\/option>");
                return '<select style="width:90px" onchange="' + t._var + ".updateMapping(" + i + ',parseInt(value))"><option value="-1"' + (e == -1 ? ' selected="selected"' : "") + ">Ignore<\/option>" + o.join("") + "<\/select>"
            }
        }, {
            title: "Target Column",
            dataField: "trgColumn",
            width: 223,
            editable: !1,
            selectable: !1
        }]), l.setData(i)
    }

    function d() {
        var h = [],
            n = 0,
            l, e, r;
        for (u = [], w.map(function(t, i) {
            var r, i;
            if (t) {
                if (r = t.split(o), r.length > n && (n = r.length), s)
                    for (i = 0; i < r.length; i++) r[i] = r[i] == a ? null : r[i].replace(new RegExp("^" + s + "|" + s + "$", "g"), "");
                u.push(r)
            }
        }), l = n != f, f = n, e = parseInt((t.$("phGrid1").clientWidth - __ScrollButtSize - 3) / n), e < 50 && (e = 50), r = 0; r < n; r++) h.push({
            title: "<b>" + (r + 1) + "<\/b>",
            dataField: r,
            width: e,
            renderer: function(n, t, i) {
                var r = n[t][i.dataField];
                return r === null ? '<div style="color:blue">NULL<\/div>' : (r || "").toString().substr(0, 500)
            }
        });
        c.create(h), c.setData(u), l && i && (i.map(function(n, t) {
            n.srcColumn = t < f ? t : -1
        }), k())
    }

    function g(i) {
        i && (e = i);
        var r = "data.php?action=linespreview&file=" + e + (APP.hostInfo.encodings ? "&enc=" + v.selectedItem.label : "");
        n.sendReq(r, null, function(n) {
            w = n || [], d(), t.updateButtons()
        })
    }
    var t = Storage.store(this, "PopupImportData"),
        u = [],
        i, w = [],
        f = 0,
        e, o = ";",
        s = '"',
        a = "NULL",
        b = "INSERT",
        r = new Dialog(700, 538, ",15,,12"),
        h, c, l;
    r.show("", [{
        label: "Import Now!",
        img: IMG_ACCEPT,
        action: function() {
            t.work()
        }
    }, {
        label: "Make SQL Script",
        img: IMG_SCRIPT,
        action: function() {
            t.work(!0)
        }
    }, {
        label: "Close",
        img: IMG_CANCEL,
        action: function() {
            t.close()
        },
        onEscape: 1,
        selected: 1
    }], RES.import_data + " into <b>" + n.getFullName() + "<\/b>"), r.getContentElem().innerHTML = '<div data-sticky="2,,2,">Source Data Preview<\/div><div data-sticky=",0,0,"><a onclick="' + t._var + '.browse()">Browse...<\/a><\/div><div id="' + t._("phGrid1") + '" data-sticky="0,0,20," style="height:135px"><\/div><div data-sticky="2,,166,">Source to Target Column Mapping<\/div><div id="' + t._("phGrid2") + '" data-sticky="0,,185,0" style="width:330px"><\/div><table data-sticky="350,,170," cellpadding="5"><tr><td>File encoding<\/td><td id="' + t._("phFileEnc") + '"><\/td><\/tr><tr><td>Columns separated with<\/td><td><input id="' + t._("txtSep") + '" type="text" value=";" style="width:65px" onchange="' + t._var + '.updateButtons(1)" /> (for Tab use <b>\\t<\/b>)<\/td><\/tr><tr><td>Columns enclosed with<\/td><td><input id="' + t._("txtEncl") + '" type="text" value="&quot;" style="width:65px" onchange="' + t._var + '.updateButtons(1)" /><\/td><\/tr><tr><td>NULLs represented by<\/td><td><input id="' + t._("txtNull") + '" type="text" value="NULL" style="width:65px" onchange="' + t._var + '.updateButtons(1)" /><\/td><\/tr><tr><td>Binary data is in HEX format<\/td><td><input id="' + t._("chkHex") + '" type="checkbox" checked="checked" /><\/td><\/tr><tr><td colspan="2"><\/td><\/tr><tr><td>On duplicate row<\/td><td id="' + t._("phDups") + '"><\/td><\/tr><tr><td>Start at record<\/td><td id="' + t._("phOffset") + '"><\/td><\/tr><tr><td>Total records (0=All)<\/td><td id="' + t._("phLimit") + '"><\/td><\/tr><\/table>';
    var v = CreateEncodingsCombo(t._("phFileEnc"), function() {
            e && g(e)
        }),
        y = new NumInput(t.$("phOffset"), 0, 100),
        p = new NumInput(t.$("phLimit"), 0, 100);
    return y.minimum = p.minimum = 0, h = new Combo(t.$("phDups"), [{
        label: "Throw error",
        value: "INSERT"
    }, {
        label: "Ignore",
        value: "INSERT IGNORE"
    }, {
        label: "Replace",
        value: "REPLACE"
    }], 100, null, function() {
        b = h.selectedItem.value
    }), h.selectIndex(0), c = new DataGrid(t.$("phGrid1"), {
        editable: !1
    }), l = new DataGrid(t.$("phGrid2"), {
        selectable: !0,
        resizable: !1,
        editable: !0,
        scrollbars: "vertical",
        scrollToView: !1,
        rowHeight: 24
    }), t._addToDeathList([c, l, y, p, v, h]), t.updateMapping = function(n, t) {
        i[n].srcColumn = t
    }, t.browse = function() {
        new UploadDialog("Choose the file to import", g, APP.hostInfo.maxFileSize, RES.warn_file_post_size)
    }, t.updateButtons = function(n) {
        o = t.$("txtSep").value = t.$("txtSep").value.trim() || ";", o = o.replace(/\\t/g, "\t"), s = t.$("txtEncl").value = t.$("txtEncl").value.trim() || "", a = t.$("txtNull").value = t.$("txtNull").value.trim() || "", n && d();
        var u = !f || !i || !i.map(function(n) {
            if (n.srcColumn > -1) return 1
        }).length;
        DisableElem(r.getButtonElem(0), u), DisableElem(r.getButtonElem(1), u)
    }, t.work = function(r) {
        var u = {},
            f;
        i.map(function(n) {
            n.srcColumn > -1 && (u[n.trgColumn] = [n.srcColumn, n.type])
        }), f = {
            action: "plugin",
            plugin: "import_data",
            cid: n.getHost().cid,
            file: e,
            file_encoding: v.selectedLabel,
            db: n.getDB().name,
            table: n.getFullName(),
            columns: u,
            offset: y.value,
            limit: p.value,
            separator: o,
            encloser: s,
            null_rep: a,
            hex: t.$("chkHex").checked,
            cmd: b,
            to_file: r || !1
        }, n.sendReq("data.php", f, function(n) {
            n.file ? DownloadFile(n.file, n.alias) : n.result && (Alert(RES.completed_successfully), t.close())
        })
    }, t.close = function() {
        Storage.dispose(t), r.close()
    }, r.validateLayout(), n.getDB().getTableColumnData(n.getFullName(), function(n) {
        i = n.map(function(n) {
            return {
                srcColumn: -1,
                trgColumn: n.field,
                selected: !0,
                type: n.binary ? "b" : n.type == "number" || n.type == "year" ? "n" : "s"
            }
        }), k(), t.updateButtons(), t.browse()
    }), t
}

function PopupExportData(n, t) {
    function k(n) {
        i.$("txtExpTbl").value = h, r = n || [], i.updateGrid(), i.updateButtons()
    }

    function d() {
        n.sendQuery(t, function(n) {
            h = "", k(n.fields.map(function(n) {
                return n.table && (h = n.table), {
                    column: n.fieldAlias,
                    selected: !0
                }
            }))
        }, null, QUERY_ONLY_FIELDS, !1, !1, function() {
            i.updateButtons()
        })
    }
    var i = Storage.store(this, "PopupExportData"),
        r, f = !0,
        h = "",
        p = 0,
        e = new Dialog(735, 550, ",5,,15"),
        o, y, u;
    e.show("", [{
        label: "Export",
        img: IMG_ACCEPT,
        action: function() {
            i.work()
        }
    }, {
        label: "Close",
        img: IMG_CANCEL,
        action: function() {
            i.close()
        },
        onEscape: 1,
        selected: 1
    }], RES.export_data), o = n.getDB(), e.getContentElem().innerHTML = '<div data-sticky="2,,1,">Default Database: <b>' + (o ? o.name : "<i>unspecified<\/i>") + '<\/b><\/div><div id="' + i._("phCode") + '" data-sticky="0,0,22," style="height:80px"><\/div><div id="' + i._("phExpGrid") + '" data-sticky="0,,110,0:300"><\/div><div id="' + i._("phExpTabs") + '" data-sticky="313,0,103,110"><\/div><table data-sticky="313,,,0" cellpadding="5"><tr><td>File encoding<\/td><td id="' + i._("phFileEnc") + '"><\/td><\/tr><tr><td>Start at record<\/td><td id="' + i._("phOffset") + '"><\/td><\/tr><tr><td>Total records (0=All)<\/td><td id="' + i._("phLimit") + '"><\/td><\/tr><\/table>', i.updateExample = function(n) {
        var t = l.selectedIndex == 0 ? ["[\n  [ val1, val2, val3 ],\n  [ ... ],\n  ...\n]", '[\n  { "fld1":val1, "fld2":val2, "fld3":val3 },\n  { ... },\n  ...\n]'] : ["array(\n  array(val1, val2, val3),\n  array(...),\n  ...\n);", 'array(\n  array("fld1"=>val1, "fld2"=>val2, "fld3"=>val3),\n  array(...),\n  ...\n);'];
        p = n, i.$("jsonExmpl").innerHTML = "Example:<br />" + t[n]
    };
    var c = new TabNav(i.$("phExpTabs"), [{
            label: "CSV",
            fill: function(n) {
                n.innerHTML = '<table style="margin:10px" cellpadding="5"><tr><td>Put column names on first line<\/td><td><input id="' + i._("chkFldNames1") + '" type="checkbox" checked="checked" /><\/td><\/tr><tr><td>Separate columns with<\/td><td><input id="' + i._("txtSep") + '" type="text" value=";" style="width:65px" onchange="' + i._var + '.updateButtons()" /> (for Tab use <b>\\t<\/b>)<\/td><\/tr><tr><td>Enclose columns with<\/td><td><input id="' + i._("txtEncl") + '" type="text" value="&quot;" style="width:65px" onchange="' + i._var + '.updateButtons()" /><\/td><\/tr><tr><td>Replace NULLs with<\/td><td><input id="' + i._("txtRepNull") + '" type="text" value="NULL" style="width:65px" /><\/td><\/tr><tr><td>Terminate lines with<\/td><td id="' + i._("phTerm") + '"><\/td><\/tr><tr><td>Auto adjust column widths<\/td><td><input id="' + i._("chkFixed") + '" type="checkbox" onclick="' + i._var + '.updateButtons()" /><\/td><\/tr><tr><td>Extra space between columns<\/td><td id="' + i._("phColSpace") + '"><\/td><\/tr><\/table>'
            }
        }, {
            label: "Excel",
            fill: function(n) {
                n.innerHTML = '<table style="margin:10px" cellpadding="5"><tr><td>Put column names on first line<\/td><td><input id="' + i._("chkFldNames2") + '" type="checkbox" checked="checked" /><\/td><\/tr><\/table>'
            }
        }, {
            label: "SQL",
            fill: function(n) {
                n.innerHTML = '<table style="margin:10px" cellpadding="5"><tr><td>Name of target table<\/td><td><input id="' + i._("txtExpTbl") + '" type="text" style="width:200px" /><\/td><\/tr><tr><td colspan="2"><label><input id="' + i._("chkDisForKeys") + '" type="checkbox" checked="checked" />Disable foreign key checks<\/label><\/td><\/tr><tr><td colspan="2"><label><input id="' + i._("chkLockTbl") + '" type="checkbox" checked="checked" />Lock tables for writing before INSERTs<\/label><\/td><\/tr><tr><td colspan="2"><label><input id="' + i._("chkAddCommit") + '" type="checkbox" checked="checked" />Add COMMIT after INSERTs<\/label><\/td><\/tr><tr><td colspan="2"><label><input id="' + i._("chkGroupIns") + '" type="checkbox" checked="checked" />Group records into single INSERT statement<\/label><\/td><\/tr><\/table>'
            }
        }, {
            label: "JSON / PHP",
            fill: function(n) {
                n.innerHTML = '<table style="margin:10px" cellpadding="5"><tr><td>Language<\/td><td id="' + i._("cmbExpScr") + '"><\/td><\/tr><tr><td colspan="2"><label><input id="' + i._("radJsonFrmt1") + '" name="' + i._("radJsonFrmt") + '" type="radio" checked="checked" onclick="' + i._var + '.updateExample(0)" />Array of Arrays<\/label><\/td><\/tr><tr><td colspan="2"><label><input id="' + i._("radJsonFrmt2") + '" name="' + i._("radJsonFrmt") + '" type="radio" onclick="' + i._var + '.updateExample(1)" />Array of Associative Arrays<\/label><\/td><\/tr><\/table><pre id="' + i._("jsonExmpl") + '" style="margin:20px;line-height:19px"><\/pre>'
            }
        }]),
        w = new Combo(i.$("phTerm"), [{
            label: "CR+LF (\\r\\n)",
            value: "\r\n"
        }, {
            label: "LF (\\n)",
            value: "\n"
        }, {
            label: "CR (\\r)",
            value: "\r"
        }], 100, "LF (\\n)"),
        l = new Combo(i.$("cmbExpScr"), Labelize("JSON", "PHP"), 100, "JSON", function() {
            i.updateExample(p)
        }),
        b = CreateEncodingsCombo(i._("phFileEnc")),
        s = new NumInput(i.$("phColSpace"), 1, 80),
        a = new NumInput(i.$("phOffset"), 0, 80),
        v = new NumInput(i.$("phLimit"), 0, 80);
    return s.minimum = a.minimum = v.minimum = 0, y = new CodeEditor(i.$("phCode"), {
        readOnly: !0
    }), y.fill(t), u = new DataGrid(i.$("phExpGrid"), {
        selectable: !0,
        resizable: !1,
        editable: !1,
        scrollbars: "vertical",
        scrollToView: !1,
        onEditSave: function() {
            i.updateButtons()
        }
    }), i._addToDeathList([c, y, u, w, l, b, s, a, v]), i.updateGrid = function() {
        f = !0, u.create([{
            title: "",
            resizable: !1,
            dataField: "selected",
            width: 40,
            renderer: DataGridCheckBoxRenderer,
            onClick: function(n, t, e, o) {
                DataGridCheckBoxClickHandler(n, t, e, o), f = r.map(function(n) {
                    if (n.selected) return 1
                }).length == r.length, i.updateButtons(), u.createHeaders()
            },
            headerRenderer: function() {
                return r && r.length ? '<div style="padding-left:3px;cursor:default">' + DataGridCheckBoxRenderer([
                    [f]
                ], 0, {
                    dataField: 0
                }) + "<\/div>" : ""
            },
            onHeaderClick: function() {
                f = !f, r.map(function(n) {
                    n.selected = f
                }), u.refreshData(), u.createHeaders(), i.updateButtons()
            }
        }, {
            title: "Source Column",
            dataField: "column",
            width: 258
        }]), u.setData(r)
    }, i.updateButtons = function() {
        i.$("txtSep").value = i.$("txtSep").value.trim() || ";", i.$("txtEncl").value = i.$("txtEncl").value.trim() || "", DisableElem(e.getButtonElem(0), !r || r.map(function(n) {
            if (n.selected) return 1
        }).length == 0);
        var n = i.$("chkFixed").checked;
        s.setDisabled(!n), DisableElem(i.$("txtSep"), n)
    }, i.work = function() {
        var u = {
                action: "plugin",
                plugin: "export_data",
                cid: n.getHost().cid,
                query: t,
                fields: r.map(function(n, t) {
                    if (n.selected) return t
                }),
                offset: a.value,
                limit: v.value,
                db: o ? o.name : "",
                file_encoding: b.selectedLabel
            },
            f;
        switch (c.getSelectedIndex()) {
            case 0:
                f = i.$("chkFixed").checked, u.format = "csv", u.add_field_names = i.$("chkFldNames1").checked ? 1 : 0, u.separator = f ? "" : i.$("txtSep").value, u.encloser = i.$("txtEncl").value, u.null_rep = i.$("txtRepNull").value, u.term = w.selectedItem.value, u.fixed = f ? 1 : 0, u.spacing = f ? s.value : "";
                break;
            case 1:
                u.format = "txt", u.add_field_names = i.$("chkFldNames2").checked ? 1 : 0, u.separator = "\t", u.encloser = u.null_rep = "", u.term = "\n", u.fixed = 0, u.spacing = "";
                break;
            case 2:
                u.format = "sql", u.target = i.$("txtExpTbl").value, u.no_foreign_keys = i.$("chkDisForKeys").checked, u.with_lock = i.$("chkLockTbl").checked, u.with_commit = i.$("chkAddCommit").checked, u.group_inserts = i.$("chkGroupIns").checked;
                break;
            case 3:
                u.format = l.selectedItem.label.toLowerCase(), u.type = i.$("radJsonFrmt1").checked ? 0 : 1
        }
        n.sendReq("data.php", u, function(n) {
            n.file && DownloadFile(n.file, n.alias)
        })
    }, i.close = function() {
        Storage.dispose(i), e.close()
    }, e.validateLayout(), c.selectIndex(0), i.updateExample(0), d(), i
}

function PopupExportDB(n) {
    function l() {
        i = [], h = 0, n.iterateChildren(function(n) {
            if (!n.temp) {
                var t = n.clone(["name", "objType", "icon"]);
                t.expStruct = !0, t.objType == "table" && (h++, t.expData = !0), i.push(t)
            }
        }), t.updateGrid(), t.updateButtons()
    }
    var t = Storage.store(this, "PopupExportDB"),
        i = [],
        h = 0,
        o = 0,
        s = 0,
        u = !1,
        f = !1,
        e = new Dialog(780, 470, ",60,,30"),
        c, r;
    return e.show("", [{
        label: "Export",
        img: IMG_ACCEPT,
        action: function() {
            t.work()
        }
    }, {
        label: "Close",
        img: IMG_CANCEL,
        action: function() {
            t.close()
        },
        onEscape: 1,
        selected: 1
    }], RES.export_to_script + ": <b>" + n.name + "<\/b>"), e.getContentElem().innerHTML = '<div id="' + t._("phExpGrid") + '" data-sticky="0,,0,0:435"><\/div><div data-sticky="440,0,0,0" style="line-height:30px;padding:10px" class="border">\t<label><input id="' + t._("chkExpStruct") + '" type="checkbox" checked="checked" onclick="' + t._var + ".updateGrid();" + t._var + '.updateButtons()" />Export database structure<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpCreateDb") + '" type="checkbox" checked="checked" onclick="' + t._var + '.updateButtons()" />Add \'CREATE DATABASE\'<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpDropDb") + '" type="checkbox" />Add \'DROP DATABASE IF EXISTS\'<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpDropObj") + '" type="checkbox" />Add \'DROP IF EXISTS\' for objects<\/label><br /><br />\t<label><input id="' + t._("chkExpData") + '" type="checkbox" checked="checked" onclick="' + t._var + ".updateGrid();" + t._var + '.updateButtons()" />Export data from tables<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpDisFKeys") + '" type="checkbox" checked="checked" />Disable foreign key checks<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpLock") + '" type="checkbox" checked="checked" />Lock tables for writing before INSERTs<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpCommit") + '" type="checkbox" checked="checked" />Add COMMIT after INSERTs<\/label><br />\t<label style="margin-left:15px"><input id="' + t._("chkExpGroupIns") + '" type="checkbox" checked="checked" />Group records into single INSERT statement<\/label><br /><br />\t<div data-sticky="25,,335,">File encoding<\/div><div id="' + t._("phFileEnc") + '" data-sticky="110,,340,"><\/div><\/div>', c = CreateEncodingsCombo(t._("phFileEnc")), r = new DataGrid(t.$("phExpGrid"), {
        selectable: !0,
        resizable: !1,
        editable: !1,
        scrollbars: "vertical",
        scrollToView: !1,
        onEditSave: function() {
            t.updateButtons()
        }
    }), t._addToDeathList([r, c]), t.updateGrid = function() {
        function n(n) {
            if (n) {
                if (!t.$("chkExpData").checked) return;
                f = !f, i.map(function(n) {
                    n.objType == "table" && (n.expData = f)
                })
            } else {
                if (!t.$("chkExpStruct").checked) return;
                u = !u, i.map(function(n) {
                    n.expStruct = u
                })
            }
            r.refreshData(), r.createHeaders(), t.updateButtons()
        }
        r.create([{
            title: "",
            dataField: "expStruct",
            width: 70,
            headerRenderer: function() {
                return t.$("chkExpStruct").checked ? '<div style="cursor:default"><div style="float:left;width:18px">' + DataGridCheckBoxRenderer([
                    [u]
                ], 0, {
                    dataField: 0
                }) + "<\/div>Struct<\/div>" : "Struct"
            },
            renderer: function(n, i, r) {
                if (t.$("chkExpStruct").checked) return DataGridCheckBoxRenderer(n, i, r)
            },
            onClick: DataGridCheckBoxClickHandler,
            onHeaderClick: n
        }, {
            title: "",
            dataField: "expData",
            width: 70,
            headerRenderer: function() {
                return t.$("chkExpData").checked ? '<div style="cursor:default"><div style="float:left;width:20px">' + DataGridCheckBoxRenderer([
                    [f]
                ], 0, {
                    dataField: 0
                }) + "<\/div>Data<\/div>" : "Data"
            },
            renderer: function(n, i, r) {
                if (n[i].objType == "table" && t.$("chkExpData").checked) return DataGridCheckBoxRenderer(n, i, r)
            },
            onClick: DataGridCheckBoxClickHandler,
            onHeaderClick: n
        }, {
            title: "Obj Type",
            dataField: "objType",
            width: 75,
            renderer: function(n, t) {
                return GetIconWithLabel(n[t])
            }
        }, {
            title: "Name",
            dataField: "name",
            width: 220
        }]), r.setData(i)
    }, t.updateButtons = function() {
        var n, c, l;
        o = s = 0, i.map(function(n) {
            n.expStruct && o++, n.expData && s++
        }), n = o == i.length, c = s == h, (u != n || f != c) && (u = n, f = c, r.createHeaders()), n = t.$("chkExpStruct").checked, c = t.$("chkExpData").checked, l = o && n || s && c, DisableElem(e.getButtonElem(0), !l), DisableElem(t._("chkExpCreateDb"), !n), DisableElem(t._("chkExpDropDb"), !n || !t.$("chkExpCreateDb").checked), DisableElem(t._("chkExpDropObj"), !n), DisableElem(t._("chkExpDisFKeys"), !c), DisableElem(t._("chkExpLock"), !c), DisableElem(t._("chkExpCommit"), !c)
    }, t.work = function(r) {
        var f = n.getHost(),
            e = t.$("chkExpStruct").checked,
            u = {
                db: n.name,
                with_drop_db: e && t.$("chkExpDropDb").checked ? 1 : 0,
                with_create_db: e && t.$("chkExpCreateDb").checked ? 1 : 0,
                with_drop_obj: e && t.$("chkExpDropObj").checked ? 1 : 0,
                with_commit: t.$("chkExpCommit").checked ? 1 : 0,
                with_lock: t.$("chkExpLock").checked ? 1 : 0,
                no_foreign_keys: t.$("chkExpDisFKeys").checked ? 1 : 0,
                group_inserts: t.$("chkExpGroupIns").checked ? 1 : 0,
                file_encoding: c.selectedLabel
            };
        if (e && (u.tables_struct = i.map(function(n) {
            if (n.objType == "table" && n.expStruct) return n.name
        }), u.views = i.map(function(n) {
            if (n.objType == "view" && n.expStruct) return n.name
        }), u.funcs = i.map(function(n) {
            if (n.objType == "function" && n.expStruct) return n.name
        }), u.procs = i.map(function(n) {
            if (n.objType == "procedure" && n.expStruct) return n.name
        }), u.events = i.map(function(n) {
            if (n.objType == "event" && n.expStruct) return n.name
        }), u.triggers = i.map(function(n) {
            if (n.objType == "trigger" && n.expStruct) return n.name
        })), t.$("chkExpData").checked && (u.tables_data = i.map(function(n) {
            if (n.expData) return n.name
        })), r) {
            u.host = f.host, u.port = f.port, u.uname = f.uname, u.passwd = f.passwd, Confirm("Please enter a name for this backup task", "Backup Name", "My new backup", function(t) {
                var i = String.random(32);
                u.label = t, n.sendReq("data.php", {
                    action: "save_tool",
                    type: "backup",
                    taskId: i,
                    data: JSON.stringify(u)
                }, function() {
                    OpenWindow(FillerPremTools, APP).refresh(i)
                })
            });
            return
        }
        u.action = "plugin", u.plugin = "export_db", u.cid = f.cid, n.sendReq("data.php", u, function(n) {
            n.file && DownloadFile(n.file, n.alias)
        })
    }, t.close = function() {
        Storage.dispose(t), e.close()
    }, e.validateLayout(), t.updateGrid(), t.updateButtons(), n.open ? (n.dispatchChange(), l()) : n.load(l), t
}

function PopupAppSettings(n, t) {
    function f() {
        var t = i.opts._changed || u.map(function(n) {
                if (n._changed || n._deleted || n.temp) return !0
            }).length > 0,
            f = u.map(function(n) {
                if (!n.uname || !n.label || !n.host) return !0
            }).length > 0,
            n = r.selectedItem;
        DisableElem(e.getButtonElem(0), f || !t || s), DisableElem(i._("btnRemHost"), !n), DisableElem(i._("btnHostUp"), !n || r.selectedIndex == 0, .5), DisableElem(i._("btnHostDown"), !n || r.selectedIndex >= u.length - 1, .5), i.$("btnRemHost").innerHTML = (n && n._deleted ? "Restore" : "Delete") + " Host"
    }
    var i = Storage.store(this, "PopupAppSettings"),
        r, o, s, h, u, e;
    return i.opts = n.clone(CONFIG_OPTS.getKeys()), i.opts.newPasswd = "", i.opts.watchChanges(f), u = n.children.map(function(n, t) {
        var i = n.clone(CONFIG_OPTS_HOST);
        return i.savePasswd = n.savePasswd, i._index = t, i.papa = n, i.watchChanges(), i
    }), e = new Dialog(680, 430, ",5,-3,"), e.show("", [{
        label: "Save",
        img: IMG_ACCEPT,
        action: function() {
            i.save()
        }
    }, {
        label: "Cancel",
        img: IMG_CANCEL,
        action: function() {
            i.close()
        },
        onEscape: 1,
        selected: 1
    }], "DbNinja Settings"), o = new TabNav(e.getContentElem(), [{
        label: "MySQL Hosts",
        fill: function(n) {
            function t(n, t, i) {
                return n[t][i.dataField] || '<div style="font-style:italic;color:red">Can\'t be empty<\/div>'
            }
            n.innerHTML = '<div class="buttons" data-sticky="5,,5,">\t<button onclick="' + i._var + '.addHost()" style="background-image:url(' + IMG_SERVER_ADD + ')">Add Host<\/button>\t<button id="' + i._("btnRemHost") + '" onclick="' + i._var + '.delHost()" style="width:105px;background-image:url(' + IMG_SERVER_DELETE + ')">Delete Host<\/button>\t<button id="' + i._("btnHostUp") + '" class="roundButton" onclick="' + i._var + '.moveRow(true)" style="margin-left:30px;background-image:url(' + IMG_UP + ')"><\/button>\t<button id="' + i._("btnHostDown") + '" class="roundButton" onclick="' + i._var + '.moveRow(false)" style="background-image:url(' + IMG_DOWN + ')"><\/button><\/div><div id="' + i._("phGrid") + '" data-sticky="0,0,40,0"><\/div>', r = new DataGrid(i.$("phGrid"), {
                selectable: !0,
                onSelect: f,
                onEditBeginning: function(n) {
                    if (n.editedDataField == "passwd" && !n.editedRecord.savePasswd) return !1
                },
                onEditSave: function(n, t) {
                    n.editedDataField && n.editedRecord._set(n.editedDataField, t), f()
                }
            });
            var e = [{
                title: "Label",
                dataField: "label",
                width: 120,
                editable: !0,
                renderer: t
            }, {
                title: "Host",
                dataField: "host",
                width: 150,
                editable: !0,
                renderer: t
            }, {
                title: "Port",
                dataField: "port",
                width: 60,
                editable: !0,
                align: "right",
                editor: new ClassFactory(DataGridNumberEditor, r, 1, 65535)
            }, {
                title: "User Name",
                dataField: "uname",
                width: 100,
                editable: !0,
                renderer: t
            }, {
                title: "Save Pswd",
                dataField: "savePasswd",
                width: 80,
                renderer: DataGridCheckBoxRenderer,
                onClick: DataGridCheckBoxClickHandler
            }, {
                title: "Password",
                dataField: "passwd",
                width: 80,
                editable: !0,
                renderer: function(n, t) {
                    return n[t].savePasswd && n[t].passwd ? "&bull;&bull;&bull;&bull;&bull;&bull;&bull;&bull;&bull;&bull;&bull;" : '<div style="font-style:italic;color:#aaaaaa">' + (n[t].savePasswd ? "Empty" : "Ask on Connect") + "<\/div>"
                }
            }, {
                title: "Keep Alive",
                dataField: "keepAlive",
                width: 69,
                renderer: DataGridCheckBoxRenderer,
                onClick: DataGridCheckBoxClickHandler
            }];
            r.create(e), r.setData(u), i._addToDeathList(r)
        }
    }, {
        label: "Settings",
        fill: function(t) {
            var r, s, h, c, u, e, o;
            t.innerHTML = '<div data-sticky="15,,15," style="line-height:27px">\t<label><input id="' + i._("chkEncr") + '" type="checkbox" onclick="' + i._var + ".opts._set('encrypt',this.checked)\" />Encrypt communication between my browser and DbNinja<\/label>\t\t<img src=\"" + IMG_HELP + '" title="DbNinja will use ~twice more bandwidth with encryption enabled, but your communication will be secure. Contents of uploaded and downloaded files will NOT be encrypted." style="vertical-align:-2px" /><br />\t<label><input id="' + i._("chkDbHide") + '" type="checkbox" onclick="' + i._var + ".opts._set('hideSysDBs',this.checked);\" />Hide system databases (mysql, information_schema, performance_schema)<\/label><br />\t<label><input id=\"" + i._("chkRowRowNums") + '" type="checkbox" onclick="' + i._var + '.opts._set(\'showQueryRowNums\',this.checked);" />Show row numbers in query result<\/label>\t<table cellpadding="4" style="margin-top:5px">\t<tr><td>Default action for clicking on <span style="color:blue">[Binary]<\/span> data cell<\/td><td id="' + i._("phBinCell") + '" colspan="2"><\/td><\/tr>\t<tr><td>Default action for double-clicking on a Table/View<\/td><td id="' + i._("phTableAction") + '" colspan="2"><\/td><\/tr>\t<tr><td colspan="3"><\/td><\/tr>\t<tr><td>Number of rows per page in query result<\/td><td id="' + i._("phPageRows") + '"><\/td><td id="' + i._("phPageNote") + '" style="color:red"><\/td><\/tr>\t<tr><td>Abort long running query after<\/td><td style="width:70px" id="' + i._("phReqTimeout") + '"><\/td><td>seconds<\/td><\/tr>\t<tr><td>Abort query after fetched<\/td><td id="' + i._("phLimitDataSize") + '"><\/td><td id="' + i._("phDataNote") + '">megabytes<\/td><\/tr>\t<tr><td>Abort query after fetched<\/td><td id="' + i._("phLimitDataRows") + '"><\/td><td>records<\/td><\/tr>\t<tr><td>Don\'t bring cells larger than<\/td><td id="' + i._("phLimitCell") + '"><\/td><td>bytes<\/td><\/tr>\t<\/table>', i.$("chkEncr").checked = n.encrypt ? "checked" : "", i.$("chkDbHide").checked = n.hideSysDBs ? "checked" : "", i.$("chkRowRowNums").checked = n.showQueryRowNums ? "checked" : "", r = new NumInput(i.$("phReqTimeout"), i.opts.reqTimeout, 80, function(n) {
                i.opts._set("reqTimeout", n)
            }), r.minimum = 10, r.maximum = 3600, s = new NumInput(i.$("phLimitDataSize"), i.opts.queryMaxDataSize, 80, function(n) {
                i.opts._set("queryMaxDataSize", n), i.$("phDataNote").innerHTML = n > 10 ? '<span style="color:red">Too high value can cause connection timeouts<\/span>' : "MB"
            }), s.minimum = 0, h = new NumInput(i.$("phLimitDataRows"), i.opts.queryMaxRows, 80, function(n) {
                i.opts._set("queryMaxRows", n)
            }), h.minimum = 0, c = new NumInput(i.$("phPageRows"), i.opts.queryPageSize, 80, function(n) {
                i.opts._set("queryPageSize", n), i.$("phPageNote").innerHTML = n > 500 ? "Too high value will cause slow performance" : ""
            }), c.minimum = 1, u = new NumInput(i.$("phLimitCell"), i.opts.queryMaxCellSize, 80, function(n) {
                i.opts._set("queryMaxCellSize", n)
            }), u.minimum = 1, u.maximum = 65536, e = new Combo(i.$("phBinCell"), Labelize("Upload value", "Download value", "Preview as picture", "Preview as binary", "Preview as text"), 180, null, function() {
                i.opts._set("binCellAction", e.selectedIndex), f()
            }), e.selectIndex(i.opts.binCellAction, !0), o = new Combo(i.$("phTableAction"), Labelize("Open Structure Editor", "Open Data Editor"), 180, null, function() {
                i.opts._set("tableAction", o.selectedIndex), f()
            }), o.selectIndex(i.opts.tableAction, !0), i._addToDeathList([r, s, h, c, u, e, o])
        }
    }, {
        label: "Password",
        fill: function(n) {
            n.innerHTML = '<div data-sticky="15,,20,">This allows you to change the password of your DbNinja account<\/div><table cellpadding="5" data-sticky="10,,45,"><tr><td>New password<\/td><td><input id="' + i._("inpPswd1") + '" type="password" style="width:110px" onkeyup="' + i._var + '.handlePasswdChange()" /><\/td><td>&nbsp;&nbsp;Confirmation<\/td><td><input id="' + i._("inpPswd2") + '" type="password" style="width:110px" onkeyup="' + i._var + '.handlePasswdChange()" /><\/td><\/tr><\/table><div id="' + i._("phPassStr") + '" data-sticky="15,,90,"><\/div>'
        }
    }], null, null, "0,0,-5,0"), i._addToDeathList(o), i.moveRow = function(n) {
        r.moveRow(n), u.map(function(n, t) {
            n._set("_index", t)
        }), f()
    }, i.reopen = function(n, t) {
        t !== undefined && o.selectIndex(t)
    }, i.addHost = function() {
        u.push({
            label: GetNewName("new_host_", u, "label"),
            host: "127.0.0.1",
            port: 3306,
            uname: "",
            passwd: "",
            _changed: !0,
            temp: 1
        }), r.refreshData(), r.selectIndex(u.length - 1), f()
    }, i.delHost = function() {
        var n = r.selectedItem;
        n.temp ? (u.removeAll(n), r.refreshData()) : (n._deleted ? n._delete("_deleted") : n._set("_deleted", !0), r.refreshData(), r.selectItem(n)), f()
    }, i.handlePasswdChange = function() {
        i.opts._set("newPasswd", i.$("inpPswd1").value);
        var n, t = i.$("inpPswd2").value;
        s = "", h = !1, i.opts.newPasswd && (InputBox.PasswdStrength(i.opts.newPasswd) < 3 && (n = "Warning: This is a weak password. Try using capitals, numerals and symbols.", h = !0), t ? i.opts.newPasswd != t && (n = s = "Passwords do not match") : n = s = "Please confirm the password"), i.$("phPassStr").innerHTML = n ? '<div style="color:red">' + n + "<\/div>" : "", f()
    }, i.handleSecKeyChange = function() {
        i.opts._set("secureKey", i.$("txtSecKey").value), f()
    }, i.save = function() {
        function t() {
            function r() {
                var t = i.opts.clone(CONFIG_OPTS.getKeys());
                t.newPasswd = i.opts.newPasswd, n.save(f, t, i.close)
            }
            var t = 0,
                f = u.map(function(n) {
                    if (!n._deleted) {
                        var i = n.clone(CONFIG_OPTS_HOST);
                        return i.uname = i.uname.trim(), i.passwd = n.savePasswd ? n.passwd || "" : null, i.queries = n.papa ? n.papa.favourites.cloneChildren() : [], i
                    }
                    t++
                });
            t ? YesNoDialog("Associated favorite queries will be deleted with the host" + (t > 1 ? "s" : "") + ".<br />Do you want to continue?", r) : r()
        }
        h ? YesNoDialog(RES.chosen_weak_password, t) : t()
    }, i.close = function() {
        Storage.dispose(i), e.close()
    }, o.selectIndex(t || 0), e.validateLayout(), f(), i
}

function attachEventListener(n, t) {
    this.__eventListeners || (this.__eventListeners = {});
    var i = this.__eventListeners;
    (i[n] || (i[n] = []), i[n].contains(t)) || i[n].push(t)
}

function detachEventListener(n, t) {
    var i = this.__eventListeners;
    i && i[n] && i[n].removeAll(t)
}

function detachAllEventListeners() {
    delete this.__eventListeners
}

function dispatchEvent(n, t) {
    var i = this.__eventListeners,
        r;
    if (i && i[n])
        for (t || (t = {}), r = 0; r < i[n].length; r++) i[n][r](n, t)
}

function __changeWatchHandler(n, t) {
    var u, i, r;
    if (t.property !== undefined) {
        for (u = !1, i = t.target._changedProperties, r = 0; r < i.length; r++)
            if (i[r][0] == t.property) {
                i[r][1] == t.value && i.splice(r, 1), u = !0;
                break
            } u || i.push([t.property, t.oldValue]), t.target._changed = i.length > 0, t.target._changedCallback && t.target._changedCallback(t.property, t.value, t.oldValue)
    }
}

function CodeEditor(n, t) {
    var i = Storage.store(this, "CodeEditor"),
        r, f = {
            lineNumbers: !0,
            matchBrackets: !0,
            indentUnit: 4,
            tabindex: 0,
            indentWithTabs: !0,
            readOnly: !1,
            mode: "text/x-mysql"
        },
        u;
    i.elem = n, t && t.copyTo(f), i.setSize = function(n, t) {
        r.setSize(n, t)
    }, i.getValue = function() {
        return r.getValue()
    }, i.setValue = function(n) {
        r.setValue(n)
    }, i.fill = function(t) {
        if (n.innerHTML = '<div id="' + i._("q") + '" data-sticky="0,0,0,0"><\/div><div id="' + i._("c") + '" data-sticky="0,0,0,0" style="display:none;opacity:.4;background-color:#f1f1f1"><\/div>', f.value = t.replace(/\n\r|\r\n/g, "\n").replace(/\r/g, "\n"), r = CodeMirror(i.$("q"), f), n.setAttribute("data-sticky-callback", i._var + ".handleResize()"), !f.readOnly && !f.noHelp) {
            var u = CreateElem("div", n);
            u.setAttribute("data-sticky", ",0,-21,"), u.innerHTML = '<img src="' + IMG_HELP + '" onclick="' + i._var + '.help()" title="Help" style="border:1px solid #adadad;height:16px;width:16px;padding:2px;cursor:pointer;background-color:white" />'
        }
        ValidateLayout(n)
    }, i.showDropZone = function(t) {
        if (!t) {
            u && RemoveNode(u), u = null;
            return
        }
        u = CreateElem("div", n), u.setAttribute("data-sticky", "2,2,2,2"), u.style.border = "2px dashed red", ValidateLayout(u)
    }, i.handleResize = function() {
        r.getScrollerElement().style.height = n.clientHeight - 2 + "px", r.refresh()
    }, i.disable = function(n) {
        r.setOption("readOnly", n), i.$("c").style.display = n ? "" : "none"
    }, i.help = function() {
        var n = Alert('<table style="border-spacing:1px" cellpadding="5"><tr style="font-weight:bold;background-color:#ededed"><td>Action<\/td><td>PC<\/td><td>MAC<\/td><\/tr><tr><td style="width:110px">Start searching<\/td><td style="width:90px">Ctrl-F<\/td><td>Cmd-F<\/td><\/tr><tr><td>Find next<\/td><td>Ctrl-G<\/td><td>Cmd-G<\/td><\/tr><tr><td>Find previous<\/td><td>Shift-Ctrl-G<\/td><td>Shift-Cmd-G<\/td><\/tr><tr><td>Replace<\/td><td>Shift-Ctrl-F<\/td><td>Cmd-Option-F<\/td><\/tr><tr><td>Replace all<\/td><td>Shift-Ctrl-R<\/td><td>Shift-Cmd-Option-F<\/td><\/tr><\/table>', "Find/Replace Shortcuts", null, null, function() {
            n.close(!0), i.focus()
        })
    }, i.destroy = function() {
        n.removeAttribute("data-sticky-callback"), n.innerHTML = "", Storage.dispose(i)
    }, i.checkInFocus = function() {
        return DiveToElem(document.activeElement, n)
    }, i.getWrapperElement = function() {
        return r.getWrapperElement()
    }, i.getSelection = function() {
        return r.getSelection()
    }, i.focus = function() {
        r.focus()
    }, i.setCursor = function(n, t) {
        r.setCursor(n, t)
    }, i.addText = function(n) {
        r.replaceSelection(n);
        var t = r.getCursor();
        r.setCursor({
            line: t.line,
            ch: t.ch
        }), i.focus()
    }
}

function Combo(n, t, i, r, u, f) {
    var e = Storage.store(this, "Combo"),
        s = [],
        o, h;
    return e.selectedIndex = -1, e.selectedItem = null, e.selectedLabel = null, e.isOpen = !1, typeof t == "function" && (h = t, t = t()), this.fill = function() {
        n.innerHTML = '<div id="' + e._("Combo") + '" style="width:' + i + 'px" class="combo focusable" tabindex="0" onkeydown="' + e._var + '.handleKeyDown(event)">\t<div id="' + e._("ComboTxt") + '" style="float:left;width:' + (i - 26) + 'px" class="comboText" onmousedown="' + e._var + ".flip(!" + e._var + '.isOpen)">&nbsp;<\/div>\t<div id="' + e._("ComboBtn") + '" onmousedown="' + e._var + ".flip(!" + e._var + '.isOpen)" class="comboButton" style="background-image:url(images/gui/combo_down.gif);float:right"><\/div>\t<div id="' + e._("ComboLst") + '" class="comboList" style="width:' + (i + 2) + "px;display:" + (e.isOpen ? "" : "none") + '"><\/div>\t<div id="' + e._("ComboDis") + '" style="width:' + i + 'px;display:none" class="comboDisabler"><\/div><\/div>', e.elem = e.$("Combo"), t && r !== undefined && r !== null && (e.select(r, !0), r = undefined), e.selectedIndex == -1 && (e.$("ComboTxt").innerHTML = f ? '<div style="font-style:italic;color:#999999">' + f + "<\/div>" : "&nbsp;"), this.setDisabled(!t || !t.length)
    }, this.setDisabled = function(n) {
        e.$("ComboDis").style.display = n ? "" : "none", e.elem.tabIndex = n ? -1 : 0
    }, this.handleKeyDown = function(n) {
        var i = n.keyCode,
            r;
        if (i == 27) e.flip(!1);
        else if (i == 13 || i == 32 || i == 9) o && e.selectItem(o.selectedItem), e.flip(!e.isOpen && i != 9);
        else if (i == 38 || i == 40) {
            if (o) return;
            r = e.selectedIndex + i - 39, e.selectIndex(r < 0 ? 0 : r > t.length - 1 ? t.length - 1 : r)
        } else i == 36 ? e.selectIndex(t.length > 0 ? 0 : -1) : i == 35 && e.selectIndex(t.length - 1)
    }, this.flip = function(n) {
        var i = e.$("ComboLst");
        n || (o && (o.destroy(), o = null), RemoveEvents(s), e.elem.focus()), e.isOpen = n, i.style.display = n ? "" : "none", e.$("ComboBtn").style.backgroundImage = "url(images/gui/combo_" + (n ? "up" : "down") + ".gif)", n && (h && (t = h()), o = new ListBox(i, t, function(n) {
            e.selectItem(n), e.flip(!1)
        }, {
            itemCount: 7,
            sticky: "0,0,0,0"
        }), o.selectItem(e.selectedItem, !0), o.scrollToIndex(o.selectedIndex, !0), s = [AddEvent(document, "mousedown", function(n) {
            DiveToElem(n.target, e.elem) || e.flip(!1)
        })], o.focus())
    }, this.selectIndex = function(n, i) {
        e.selectedIndex = n = n < 0 || n >= t.length ? -1 : n, e.selectedItem = n > -1 ? t[n] || null : null, e.selectedLabel = e.selectedItem ? typeof e.selectedItem == "string" ? e.selectedItem : e.selectedItem.getLabel ? e.selectedItem.getLabel() : e.selectedItem.label : null, e.$("ComboTxt").innerHTML = e.selectedLabel || f || "&nbsp;", n > -1 && t[n] && (e.elem.title = t[n].tooltip ? t[n].tooltip : ""), u && !i && u(e.selectedItem)
    }, this.select = function(n, t) {
        typeof n == "string" ? e.selectLabel(n, t) : e.selectItem(n, t)
    }, this.selectItem = function(n, i) {
        var r = t.indexOf(n);
        e.selectIndex(r, i)
    }, this.selectLabel = function(n, i) {
        var r, u;
        for (n = n.toLowerCase(), r = 0; r < t.length; r++)
            if (u = typeof t[r] == "string" ? t[r] : t[r].getLabel ? t[r].getLabel() : t[r].label, u.toLowerCase() == n) {
                e.selectIndex(r, i);
                return
            }
    }, this.destroy = function() {
        RemoveEvents(s), o && (o.destroy(), o = null), Storage.dispose(e)
    }, this.setData = function(n, i) {
        t = n, r = i, e.fill()
    }, this.fill(), e
}

function DataGrid(n, t) {
    function c(n) {
        var i = ["<colgroup>"],
            t;
        if (n)
            for (t = 0; t < u.length; t++) i.push('<col style="width:' + (u[t].width - 3) + 'px"><\/col><col style="width:3px"><\/col>');
        else
            for (t = 0; t < u.length; t++) i.push('<col style="width:' + u[t].width + 'px"><\/col>');
        return i.join("")
    }

    function l(n) {
        for (var o = [], s = u.length - 1, t, e, f = 0; f <= s; f++) t = u[f], e = t.renderer ? t.renderer(r, n, t) : r[n][t.dataField], o.push('<td id="' + i._("DataGrid") + "_" + n + "_" + f + '" data-rowindex="' + n + '" data-colindex="' + f + '" class="DataGridDataCell" style="text-align:' + t.align + ";" + t.style + '">' + (e == null ? "&nbsp;" : e) + "<\/td>");
        return o
    }

    function a(n) {
        var t = DiveToAttribute(n, "data-rowindex");
        if (t) return [parseInt(t[1]), parseInt(t[0].getAttribute("data-colindex"))]
    }

    function v(n) {
        var o = $$("" + i._("DataGrid") + "_" + n),
            t, e, s, u;
        if (o && (o.className = o.className.replace(" DataGridSelectedRow", "")), i.selectedItems.removeAll(r[n]), i.selectedIndices.removeAll(n), t = -1, i.selectedItems.length)
            for (u = 1; e = n - u, s = n + u, e > -1 || s < r.length; u++) {
                if (n + u < r.length && i.selectedIndices.indexOf(n + u) > -1) {
                    t = s;
                    break
                }
                if (e > -1 && i.selectedIndices.indexOf(n - u) > -1) {
                    t = e;
                    break
                }
            }
        i.selectedItem = t > -1 ? r[t] : null, i.selectedIndex = t > -1 ? t : -1, f = n
    }

    function o(n) {
        var t = $$(i._("DataGrid") + "_" + n);
        t.className += " DataGridSelectedRow", i.selectedItems.push(r[n]), i.selectedIndices.push(n), i.selectedItem = r[n], i.selectedIndex = n, f = n
    }

    function y(n) {
        if (i.selectedItem) {
            var u = i.selectedColumnIndex,
                t = i.selectedItems.map(function(n) {
                    if (n != i.selectedItem) return n
                });
            t.push(i.selectedItem), n && n(), i.selectedItems = [], i.selectedIndices = [], t.map(function(n) {
                o(r.indexOf(n))
            }), i.selectCell()
        } else n && n()
    }

    function p(n, t, r) {
        var e, f;
        u[n].width = t, e = i.$("DataGridTblHeader"), e.style.width = parseInt(e.style.width) + r + "px", e.getElementsByTagName("col")[n * 2].style.width = t - 3 + "px", f = i.$("DataGridTblData"), f && (f.style.width = parseInt(f.style.width) + r + "px", f.getElementsByTagName("col")[n].style.width = t + "px"), i.tableWidth += r
    }
    var i = Storage.store(this, "DataGrid"),
        w = i._id,
        u, r = [],
        h, f = 0,
        e, s;
    i.columns = null, i.sortable = !0, i.tableWidth = 0, i.settings = t, i.selectedIndex = -1, i.selectedIndices = [], i.selectedItem = null, i.selectedItems = [], i.selectedField = null, i.selectedColumnIndex = -1, i.selectedCellElem = null, i.sortColumnIndex = -1, i.sortDescending = !0, i.data = [], i.rootElem = null, i.dataElem = null, s = {
        minColumnWidth: 30,
        sticky: "0,0,0,0",
        rowHeight: 22,
        headerHeight: 22,
        scrollbars: "both",
        scrollToView: "both",
        resizable: !0,
        editable: !0,
        selectable: !0
    }, s.insertable = t.editable, s.getKeys().map(function(n) {
        t[n] === undefined && (t[n] = s[n])
    }), n.innerHTML = '<div id="' + i._("DataGrid") + '" class="DataGrid" data-sticky="' + t.sticky + '" onkeydown="' + i._var + '.handleKeyPress(event)">\t<div id="' + i._("DataGridHeader") + '" class="DataGridHeaderContainer" data-sticky="1,1,1,"><\/div>\t<div id="' + i._("DataGridData") + '" class="DataGridDataContainer" data-sticky="1,1,' + (t.headerHeight + 2) + ',1" tabindex="0" onscroll="$$(\'' + i._("DataGridHeader") + '\').scrollLeft=this.scrollLeft"><\/div><\/div><div id="' + i._("DataGridGlass") + '" data-sticky="0,0,0,0" style="display:none;background-image:url(' + IMG_SPACER + ')"><\/div>', i.create = function(r) {
        var f, o;
        for (i.columns = u = r, i.sortColumnIndex = -1, i.sortDescending = !1, i.tableWidth = 0, f = 0; f < r.length; f++) r[f].index = f, o = r[f].width, o || (o = r[f].width = t.minColumnWidth), i.tableWidth += o, r[f].align || (r[f].align = "left"), r[f].style || (r[f].style = ""), r[f].resizable == undefined && (r[f].resizable = t.resizable), r[f].editable == undefined && (r[f].editable = t.editable);
        e && e.destroy(), i.rootElem = i.$("DataGrid"), i.dataElem = i.$("DataGridData"), e = new AutoScrollBars(i.dataElem, function(n) {
            SetSticky(i.$("DataGridHeader"), 1, n ? __ScrollSize + 2 : 1)
        }, t.scrollbars), ValidateLayout(n), i.createHeaders()
    }, i.updateScrolls = function() {
        ValidateLayout(n), e.updateSliders()
    }, i.createHeaders = function() {
        for (var r = [], f = u.length - 1, n = 0; n <= f; n++) r.push('<td data-rowindex="-1" data-colindex="' + n + '" class="DataGridHeaderCell' + (i.sortColumnIndex == n ? " DataGridSortArrow DataGridSort" + (i.sortDescending ? "Down" : "Up") : "") + '" onmousedown="' + i._var + ".handleHeaderMouseDown(event," + n + ')" onmouseup="' + i._var + '.focus(1)">' + (u[n].headerRenderer ? u[n].headerRenderer(u[n]) : u[n].title || "") + '<\/td><td class="DataGridResizer" ' + (u[n].resizable ? 'onmousedown="' + i._var + ".resizeColumn(event," + n + ')" ondblclick="' + i._var + ".autosizeColumn(" + n + ')"' : 'style="cursor:default"') + "><\/td>");
        i.$("DataGridHeader").innerHTML = '<table id="' + i._("DataGridTblHeader") + '" cellspacing="0" cellpadding="0" style="width:' + i.tableWidth + 'px">' + c(!0) + '<tr class="DataGridHeaderRow" style="line-height:' + t.headerHeight + 'px">' + r.join("") + "<\/tr><\/table>"
    }, i.setData = function(n, u) {
        var o, h, s, e, f;
        for (i.unselectAll(!0), o = 0, h = 0, u || (o = i.dataElem.scrollLeft, sTop = i.dataElem.scrollTop), i.data = r = n, s = ['<table id="' + i._("DataGridTblData") + '" cellspacing="0" cellpadding="0" style="width:' + i.tableWidth + 'px" onmousedown="' + i._var + '.handleMouseDown(event)" ondblclick="' + i._var + '.openEditor(true)">', c()], e = [], f = 0; f < n.length; f++) s.push('<tr id="' + i._("DataGrid") + "_" + f + '" style="line-height:' + t.rowHeight + 'px" class="DataGridDataRow' + (f % 2 ? " DataGridDarkRow" : "") + '">' + l(f).join("") + "<\/tr>"), n[f]._deleted && e.push(f);
        for (i.dataElem.innerHTML = s.join("") + "<\/table>", i.dataElem.scrollLeft = o, i.dataElem.scrollTop = sTop, i.updateScrolls(), f = 0; f < e.length; f++) $$(i._("DataGrid") + "_" + e[f]).className += " DataGridDeletedRow"
    }, i.setDisabled = function(n) {
        i.$("DataGridGlass").style.display = n ? "" : "none"
    }, i.handleKeyPress = function(n) {
        var t, o, s, e, f;
        if (!i.editor)
            if (t = n.keyCode, t == 13 || t == 32) {
                if (i.selectedColumnIndex < 0) return;
                if (o = u[i.selectedColumnIndex], o.onClick) {
                    if (i.closeEditor(), !i.selectedItem._deleted) o.onClick(n, i, i.selectedIndex, o)
                } else setTimeout(i.openEditor, 100, !0)
            } else if (t == 38 || t == 40) {
                if (f = i.selectedIndex + t - 39, f < 0 || f >= r.length) return;
                i.selectIndex(f, n), i.selectCell()
            } else if (t == 36 || t == 35) {
                if (e = t == 36 ? 0 : r.length - 1, e < 0 || e >= r.length) return;
                i.selectIndex(e, n), i.selectCell()
            } else if (t == 34 || t == 33) {
                if (s = $$(i._("DataGrid") + "_0"), !s) return;
                e = i.selectedIndex + (parseInt(i.dataElem.clientHeight / s.getBoundingClientRect().height) - 1) * (t == 33 ? -1 : 1), e < 0 && (e = 0), e >= r.length && (e = r.length - 1), i.selectIndex(e, n), i.selectCell()
            } else if (t == 37 || t == 39) {
                for (f = i.selectedColumnIndex;;) {
                    if (f += t - 38, f < 0 || f == u.length) break;
                    if (u[f].selectable !== !1) {
                        i.selectCell(f);
                        return
                    }
                }
                i.dataElem.scrollLeft += 50 * (t - 38)
            } else n.ctrlKey && t == 65 && i.selectAll()
    }, i.handleContextMenu = function(n) {
        var i = a(n.target),
            f, t;
        i && (t = u[i[1]], t.contextMenuItems) && (f = typeof t.contextMenuItems == "function" ? t.contextMenuItems(r, i[0], t) : t.contextMenuItems, f && f.length) && (i = GetMousePosition(n), new PopupMenu(i[0] + 3, i[1] + 5, f, t.contextMenuHandler, 120))
    }, i.handleMouseDown = function(n) {
        var t = a(n.target),
            r;
        if (t) {
            if (i.closeEditor(), r = u[t[1]], n.button == 2 && i.selectedIndices.contains(t[0])) {
                i.selectedIndex = f = t[0], i.selectCell(t[1]), i.handleContextMenu(n);
                return
            }
            if (i.selectIndex(t[0], n), i.selectCell(t[1]), n.button == 2) {
                i.handleContextMenu(n);
                return
            }
            if (r.onClick && i.selectedItem && !i.selectedItem._deleted) r.onClick(n, i, t[0], r)
        }
    }, i.selectAll = function() {
        if (r.length && t.multiselect) {
            i.unselectAll();
            for (var n = r.length - 1; n >= 0; n--) o(n);
            if (t.onSelect) t.onSelect(i.selectedItem)
        }
    }, i.unselectAll = function(n) {
        if (n)
            for (var t = i.selectedItems.length - 1; t >= 0; t--) r.indexOf(i.selectedItems[t]) == -1 && (i.selectedItems.splice(t, 1), i.selectedIndices.splice(t, 1));
        while (i.selectedItems.length) v(r.indexOf(i.selectedItems[0]));
        i.selectedItem = null, i.selectedIndex = -1, f = 0
    }, i.selectIndex = function(n, u) {
        var e, h, s;
        if (t.selectable && !(n < 0) && !(n >= r.length)) {
            if (u && t.multiselect && (u.ctrlKey || u.shiftKey)) {
                if (u.ctrlKey) i.selectedIndices.contains(n) ? v(n) : o(n);
                else if (u.shiftKey) {
                    for (e = f, i.unselectAll(), h = e < n ? 1 : -1, s = e; s != n + h; s += h) o(s);
                    f = e
                }
            } else {
                if (i.selectedIndex == n) return;
                i.unselectAll(), o(n)
            }
            if (i.scrollRowToView(n), u && t.onSelect) t.onSelect(i.selectedItem)
        }
    }, i.selectItem = function(n) {
        i.selectIndex(r.indexOf(n)), i.selectCell()
    }, i.unselectCell = function() {
        i.selectedCellElem && (i.selectedCellElem.className = "DataGridDataCell"), i.selectedColumnIndex = -1, i.selectedField = null, i.selectedCellElem = null
    }, i.selectCell = function(n) {
        if (t.selectable && (n === undefined && (n = i.selectedColumnIndex), i.unselectCell(), !(i.selectedIndex < 0))) {
            n < 0 && (n = 0);
            var r = i.scrollCellToView(i.selectedIndex, n);
            if (u[n].selectable !== !1) return i.selectedColumnIndex = n, i.selectedField = u[n].dataField, i.selectedCellElem = r, r.className = "DataGridDataCell DataGridSelectedCell", !0
        }
    }, i.scrollRowToView = function(n, r) {
        var u = $$(i._("DataGrid") + "_" + n);
        return u && (r || t.scrollToView == "both" || t.scrollToView == "vertical") && ScrollToView(u, i.dataElem, 5, 2), u
    }, i.scrollCellToView = function(n, r) {
        var u = $$("" + i._("DataGrid") + "_" + n + "_" + r);
        return (t.scrollToView == "both" || t.scrollToView == "horizontal") && ScrollToView(u, i.dataElem, 5), u
    }, i.refreshData = function(n) {
        n ? y(function() {
            i.setData(i.data)
        }) : i.setData(i.data)
    }, i.refreshRow = function(n) {
        var u, t, r;
        if ((n === undefined && (n = i.selectedIndex), n != -1) && (u = l(n), t = $$(i._("DataGrid") + "_" + n), t))
            for (t = t.getElementsByTagName("td"), r = 0; r < t.length; r++) t[r].innerHTML = u[r]
    }, i.focus = function(n) {
        i.rootElem && !n ? i.rootElem.focus() : i.dataElem && i.dataElem.focus()
    }, i.openEditor = function(n) {
        var r, f;
        if (t.onRowDoubleClick) {
            t.onRowDoubleClick(i.selectedItem);
            return
        }(i.closeEditor(), i.selectedCellElem) && (r = DiveToAttribute(i.selectedCellElem, "data-rowindex"), r) && (f = u[r[0].getAttribute("data-colindex")], f && f.editable && !f.onClick) && ((i.handleEditStarted(r[0], parseInt(r[1]), f), n && t.onEditBeginning && t.onEditBeginning(i) === !1) || (i.editor = i.editedColumn.editor ? i.editedColumn.editor.create() : new DataGridTextEditor(i), i.editor.open()))
    }, i.handleEditStarted = function(n, t, u) {
        i.editedColumn = u, i.editedElem = n, i.editedRowIndex = t, i.editedRecord = r[t], i.editedDataField = i.editedColumn.dataField, i.editedValue = i.editedRecord[i.editedDataField]
    }, i.closeEditor = function(n) {
        i.editor && (i.editor.__close ? i.editor.__close(null, n === undefined ? !0 : n) : (i.editor.close(), i.handleEditEnded()))
    }, i.handleEditEnded = function() {
        i.editor = null, i.editedElem = null, i.editedRecord = null, i.editedRowIndex = -1, i.editedColumn = null, i.editedDataField = null, i.editedValue = null, i.focus(!0)
    }, i.saveEditor = function(n) {
        if (t.onEditSave) t.onEditSave(i, n);
        else i.editedRecord[i.editedDataField] = n;
        i.refreshRow(i.editedRowIndex)
    }, i.handleHeaderMouseDown = function(n, t) {
        if (n.button == 2) {
            i.handleContextMenu(n);
            return
        }
        var r = u[t];
        if (r.onHeaderClick) r.onHeaderClick(t);
        else if ((!i.settings.onBeforeSort || i.settings.onBeforeSort(i, r) !== !1) && (i.sortColumn(t), i.settings.onAfterSort)) i.settings.onAfterSort(r)
    }, i.addSortArrow = function(n, t) {
        i.sortColumnIndex = n, i.sortDescending = t, i.createHeaders()
    }, i.sortColumn = function(n) {
        if (r.length && i.sortable && u[n].sortable) {
            var t, f;
            i.sortColumnIndex == -1 && (h = r.concat([])), n != i.sortColumnIndex ? (t = n, f = !1) : i.sortDescending == !0 ? (t = -1, r = h) : f = !0, i.addSortArrow(t, f), i.sortColumnIndex == -1 ? r = h : r.sort(function(t, r) {
                var f = u[n];
                return f.sortText ? (t = t[f.dataField], r = r[f.dataField], t || (t = ""), r || (r = "")) : (t = Number(t[f.dataField]), r = Number(r[f.dataField]), t == null && (t = -Infinity), r == null && (r = -Infinity)), (t < r ? -1 : t > r ? 1 : 0) * (i.sortDescending ? -1 : 1)
            }), y(function() {
                i.setData(r)
            })
        }
    }, i.resizeColumn = function(n, r) {
        var f;
        HandleDrag(n, function(n, i) {
            var f = u[r].width + n;
            return f < t.minColumnWidth && (n += t.minColumnWidth - f, f = t.minColumnWidth), p(r, f, n), [n, i]
        }, function() {
            f && f.remove(), i.updateScrolls()
        }, function() {
            f = ScreenBlock.block("", !1, "ew-resize")
        })
    }, i.autosizeColumn = function(n) {
        var t = i.getBestColumnWidth(r, n);
        t > 350 && (t = 350), p(n, t, t - u[n].width), i.updateScrolls()
    }, i.getBestColumnWidth = function(n, i) {
        for (var f = 0, e = n.length, r, u = 0; u < n.length; u++)(r = n[u][i], r) && (r = r.toString(), r.length > f && (f = r.length));
        return Math.max(GetTextWidth(new Array(f + 1).join("X")), t.minColumnWidth)
    }, i.moveRow = function(n) {
        if (i.selectedIndex != -1 && (i.selectedIndex != 0 || !n) && (i.selectedIndex != r.length - 1 || n)) {
            var u = i.selectedIndex + (n ? -1 : 1),
                t = r.splice(u, 1);
            return r.splice(i.selectedIndex, 0, t[0]), i.refreshData(!0), t
        }
    }, i.destroy = function() {
        i.closeEditor(!1), e && e.destroy(), n.innerHTML = "", Storage.dispose(i)
    }, i.handleEditEnded()
}

function DataGridTextEditor(n, t) {
    var i = new DataGridEditorBase(n),
        r;
    return i.open = function() {
        var u = i.createBaseElem("input", -1, -2),
            f;
        u.type = "text", u.value = r = n.editedValue || t || "", f = n.editedElem.getBoundingClientRect(), u.style.width = f.width - 3 + "px", u.className = "DataGridSimpleTextEditor shadow", u.style.outline = "none", u.style.height = n.settings.rowHeight + "px", n.editedColumn.maxLength && (u.maxLength = n.editedColumn.maxLength), u.focus(), u.select(), i.addEditorEvents()
    }, i.close = function(t) {
        t && r != i.elem.value && n.saveEditor(i.elem.value)
    }, i
}

function DataGridAdvTextEditor(n) {
    var t = new DataGridEditorBase(n);
    return t.inpValue = t._("txt"), t.open = function() {
        var u = n.editedElem.getBoundingClientRect(),
            i = t.createBaseElem("div", -1, -2, Math.max(u.width, 100)),
            r;
        i.className = "DataGridSimpleTextEditor shadow", r = n.editedValue == undefined ? "" : n.editedValue, r.search(/\x0A|\x0D/) > -1 ? t.maximize() : (i.innerHTML = '<input id="' + t.inpValue + '" type="text" style="outline:none;width:' + (i.clientWidth - 26) + 'px" /><img src="images/gui/dg_maximize.gif" onclick="' + t._var + '.maximize()" style="margin-left:2px" />', $$(t.inpValue).value = r, $$(t.inpValue).select(), MoveIntoView(i)), t.addEditorEvents()
    }, t.maximize = function() {
        t.ignoreEnter = !0, t.tabSaves = !0, t.elem.innerHTML = '<textarea id="' + t.inpValue + '" data-sticky="1,1,1,17" style="outline:none;resize:none"><\/textarea><div data-sticky="1,1,,2">To save press Ctrl+Enter or click outside. Press ESC to cancel.<\/div>', t.elem.style.width = "600px", t.elem.style.height = "350px", ValidateLayout(t.elem), $$(t.inpValue).value = n.editedValue == undefined ? "" : n.editedValue, $$(t.inpValue).select(), MoveIntoView(t.elem)
    }, t.close = function(i) {
        i && n.saveEditor($$(t.inpValue).value)
    }, t
}

function DataGridSelectEditor(n, t, i) {
    var r = new DataGridEditorBase(n),
        u;
    return r.open = function() {
        var e, o, f;
        i || (i = Math.max(100, n.editedElem.getBoundingClientRect().width)), e = r.createBaseElem("div", 0, 0), o = typeof t == "function" ? t(n.editedRecord) : t, u = new ListBox(e, o, r.handleSelect, {
            itemCount: 10,
            minWidth: i
        }), u.elem.style.margin = "-1px", MoveIntoView(e), f = n.editedRecord[n.editedDataField], u.selectLabel(typeof f == "string" ? f : f === null ? "" : f.label), u.scrollToIndex(u.selectedIndex, !0), r.addEditorEvents()
    }, r.handleSelect = function() {
        r.__close({
            type: "keydown",
            keyCode: 13
        })
    }, r.close = function(t) {
        var i = u.selectedItem;
        t && i && n.saveEditor(i.getLabel ? i.getLabel() : i.label ? i.label : ""), u.destroy()
    }, r
}

function DataGridNumberEditor(n, t, i, r) {
    var f = new DataGridEditorBase(n),
        u;
    return f.open = function() {
        var e = f.createBaseElem("div", -1, -1),
            o = n.editedElem.getBoundingClientRect();
        u = new NumInput(e, isNaN(n.editedValue + "") ? 0 : n.editedValue, Math.max(o.width, 70)), u.allowDot = !!r, t !== undefined && t !== null && (u.minimum = t), i !== undefined && i !== null && (u.maximum = i), u.focus(), f.addEditorEvents(), f.input = u.input
    }, f.close = function(t) {
        t && n.saveEditor(u.value + ""), u.destroy(), f.input = null
    }, f
}

function DataGridEditorBase(n, t) {
    function f() {
        i.__close({
            type: "resize"
        })
    }
    var i = Storage.store(this, "DGEditorBase"),
        r = [],
        e = i.id = "__dgEditor" + n._id,
        u;
    return i.ignoreEnter = !1, i.ignoreTab = !1, i.tabSaves = !1, i.ctrlEnterSaves = !0, u = !1, i.createBaseElem = function(t, r, u, f, o) {
        var v = n.rootElem,
            s = i.elem = CreateElem(t, v),
            c = v.getBoundingClientRect(),
            h = n.editedElem.getBoundingClientRect(),
            l, a;
        return s.id = e, s.style.position = "absolute", l = h.left - c.left + r, a = h.top - c.top + u, f && (s.style.width = f + "px", l + f > c.width && (l = h.left + h.width - r - f)), o && (s.style.height = o + "px", a + o > c.height && (a = h.top + h.height - u - o)), s.style.left = l + "px", s.style.top = a + "px", s.style.zIndex = 100, s.className = "shadow", s.focus(), s
    }, i.removeBaseElem = function() {
        RemoveNode(i.elem)
    }, i.__close = function(t, r) {
        if (!u) {
            var f = null;
            if (t && !r) switch (t.type) {
                case "keydown":
                    t.keyCode == 27 ? f = !1 : t.keyCode != 9 || i.ignoreTab ? t.keyCode == 13 && (t.ctrlKey && i.ctrlEnterSaves || !i.ignoreEnter) && (f = !0) : f = i.tabSaves;
                    break;
                case "mousedown":
                    DiveToElem(t.target, i.elem) || (f = !0);
                    break;
                case WHEEL_EVENT:
                case "resize":
                    f = !1
            }
            if (r != undefined && (f = r), f != null) {
                if (i.close(f) === !1) return;
                i.removeEditorEvents(), i.removeBaseElem(), n.handleEditEnded(), Storage.dispose(i), u = !0
            }
        }
    }, i.addEditorEvents = function() {
        r.push(AddEvent(document, "mousedown", i.__close)), r.push(AddEvent(document, "keydown", i.__close)), r.push(AddEvent(n.dataElem, WHEEL_EVENT, i.__close)), AddResizeCallback(f), t || r.push(AddEvent(i.elem, "mousedown", StopPropagation))
    }, i.removeEditorEvents = function() {
        RemoveEvents(r), r.length = 0, RemoveResizeCallback(f)
    }, i
}

function DataGridDblClickHandlingEditor(n, t) {
    this.open = function(n, i, r, u, f) {
        t(n, i, r, u, f)
    }, this.close = function() {}
}

function DataGridCheckBoxRenderer(n, t, i) {
    return n[t][i.dataField] === null ? "" : '<div class="DataGridCheckBox' + (n[t][i.dataField] ? "Checked" : "") + '">&nbsp;<\/div>'
}

function DataGridCheckBoxClickHandler(n, t, i, r) {
    if (t.selectedCellElem.innerHTML.indexOf("DataGridCheckBox") != -1) {
        t.handleEditStarted(t.selectedCellElem, i, r);
        var u = t.data[i][r.dataField];
        if (u !== null) {
            if (u = !u, t.data[i]._set(r.dataField, u), t.refreshRow(i), StopPropagation(n), t.settings.onEditSave) t.settings.onEditSave(t, u);
            t.handleEditEnded()
        }
    }
}

function DataGridGaugeRenderer(n, t, i, r) {
    var u = parseInt(n[t][i.dataField]),
        f, e;
    return isNaN(u) ? "" : (f = u, n.map(function(n) {
        if (n) {
            var t = parseInt(n[i.dataField]);
            !isNaN(t) && f < t && (f = t)
        }
    }), e = Math.ceil(u / f * 100), '<div class="DataGridGauge">\t<div class="DataGridGaugeText">' + u + (r || "") + '<\/div>\t<div style="width:' + e + '%" class="DataGridGaugeBar roundTop roundBottom"><\/div><\/div>')
}

function Dialog(n, t, i) {
    var r = Storage.store(this, "Dialog"),
        s, f, u, e = -1,
        h = !1,
        o;
    return r.muddy = !0, r.show = function(h, c, l, a, v) {
        var y, l, p, w;
        return o = ScreenBlock.block("", r.muddy), r.btns = c, f = document.activeElement, y = r.elem = CreateElem("div"), y.id = u = r._("__dialog"), y.className = "dialog shadow", y.style.zIndex = o.zIndex, n && (y.style.width = n + "px", a = null), t && (y.style.height = t + "px", v = null), __dialogs.push(r), l || (l = "Alert"), h = '<div id="' + r._("phDlgTitle") + '" class="dialogTitle" onmousedown="StartMover(event,$$(\'' + u + "'))\">" + l + '<\/div><div id="' + r._("phDlgContent") + '" ' + (n || t ? 'data-sticky="10,10,0,10"' : 'class="dialogContent" style="' + (a ? "max-width:" + a + "px;" : "") + (v ? "max-height:" + v + "px" : "") + '"') + ">" + (h || "") + "<\/div>", c && (y.style.paddingBottom = 0, h += '<div id="' + r._("phDlgBtns") + '" class="buttons" ' + (i ? 'data-sticky="' + i + '"' : 'style="text-align:center;padding-bottom:10px"') + ">", p = u + "_0", c.map(function(n, t) {
            var i = u + "_" + t;
            n.onEscape && (e = t), n.selected && (p = i), h += '<button id="' + i + '" style="' + (n.img ? "background-image:url(" + n.img + ");" : "") + (n.width ? "width:" + n.width + "px" : "") + '" onclick="' + r._var + ".pressButton(" + t + ')">' + n.label + "<\/button>&nbsp;&nbsp;"
        }), h += "<\/div>"), y.innerHTML = h, (n || t) && (w = r.$("phDlgTitle").clientHeight + 10, SetSticky(r.getContentElem(), 2, w, !0), i && AddToSticky(r.getButtonsElem(), 2, w, !0)), e > -1 && (r.$("phDlgTitle").innerHTML += '<div class="dialogX" onmousedown="StopPropagation(event)" onclick="' + r._var + '.handleEscape()"><\/div>'), s = AddEvent(document, "keydown", function(n) {
            n.keyCode == 27 && __dialogs[__dialogs.length - 1] == r && (r.handleEscape(), StopPropagation(n))
        }), c && $$(p).focus(), r.center(), AddResizeCallback(r.center), r
    }, r.toFront = function(n) {
        r.elem.style.zIndex = n || 1e4
    }, r.handleEscape = function() {
        e > -1 && r.btns[e].action(), r.close()
    }, r.getContentElem = function() {
        return r.$("phDlgContent")
    }, r.getButtonsElem = function() {
        return r.$("phDlgBtns")
    }, r.getButtonElem = function(n) {
        return $$(u + "_" + n)
    }, r.fill = function(n) {
        r.getContentElem().innerHTML = n
    }, r.pressButton = function(n) {
        this.getButtonElem(n).focus(), r.btns[n].action && r.btns[n].action()
    }, r.center = function() {
        var n = $$(u);
        n && CenterSticky(n)
    }, r.close = function(n) {
        h || (h = !0, RemoveEvent(s), RemoveNode(u), RemoveResizeCallback(r.center), Storage.dispose(r), o.remove(), __dialogs.length--, n || CallLater(function() {
            f && f.focus(), f = null
        }))
    }, r.validateLayout = function() {
        ValidateLayout(r.getContentElem())
    }, r
}

function Alert(n, t, i, r, u, f, e, o, s, h) {
    var c = new Dialog,
        l;
    return s !== undefined && (c.muddy = s), l = e ? null : [{
        label: f || "Ok",
        action: u || c.close,
        img: o || IMG_ACCEPT,
        onEscape: 1
    }], c.show(n, l, t || null, i, r), h && c.toFront(), e && setTimeout(c.close, 1500), c
}

function Confirm(n, t, i, r, u, f) {
    var e = new Dialog;
    e.show('<div style="padding-bottom:5px">' + n + '<\/div><input id="' + e._("txt") + '" type="' + (u ? "password" : "text") + '" style="width:90%;min-width:250px" onkeydown="if (event.keyCode==13) ' + e._var + '.pressButton(0)" />' + (f ? '<div style="padding-top:5px">' + f + "<\/div>" : ""), [{
        label: "Ok",
        img: IMG_ACCEPT,
        action: function() {
            var n = e.$("txt").value;
            (!r || r && r(n) !== !1) && e.close()
        }
    }, {
        label: "Cancel",
        img: IMG_CANCEL,
        action: e.close,
        onEscape: 1,
        selected: 1
    }], t), e.$("txt").value = i, e.$("txt").select()
}

function SetClipboard(n) {
    window.clipboardData ? (window.clipboardData.setData("Text", n), Alert(RES.data_copied_to_clipboard, "Clipboard", 0, 0, null, null, !0)) : new ClipboardDialog(n)
}

function ClipboardDialog(n) {
    var t = Storage.store(this, "Clipboard Dialog"),
        i, r;
    t.pushData = function() {
        return n
    }, t.close = function() {
        swfobject.removeSWF("phSwfCB"), i.close(), Storage.dispose(t)
    }, i = new Dialog(530, 285, ",10,,10"), i.show('<textarea id="txtCopyToClipboard"><\/textarea><div id="phPhSwdCB" data-sticky="-5,,,0" style="height:25px"><div id="phSwfCB" style="width:132px"><\/div><\/div>', [{
        label: "Close",
        action: t.close,
        img: IMG_CANCEL,
        onEscape: 1
    }], RES.copy_to_clipboard), i.validateLayout(), $$("txtCopyToClipboard").value = n, CallLater(function() {
        $$("txtCopyToClipboard").select()
    }), r = {
        dataSourceFunc: t._var + ".pushData",
        completeCallback: t._var + ".close",
        buttonText: "Copy Everything"
    }, swfobject.embedSWF("js/lib/clipboard.swf", "phSwfCB", "132", "27", "10.0.0", null, r, {
        wmode: "transparent",
        allowScriptAccess: "always"
    }, null, function(n) {
        n.success || (swfobject.removeSWF("phSwfCB"), $$("phPhSwdCB").innerHTML = '<div style="font-weight:bold;margin:5px 0 0 10px">' + RES.copy_contents + "<\/div>")
    })
}

function LoginDialog(n, t) {
    var i = Storage.store(this, "LoginDialog"),
        r = new Dialog;
    return r.show('<div style="padding-bottom:15px;font-weight:bold;width:250px">Your session has expired because of long inactivity or server restart.<br /><br />Please reauthenticate:<\/div>Username<br /><input id="inpUname" type="text" style="width:250px" onkeyup="' + i._var + '.updateButtons(event)" oncopy="' + i._var + '.updateButtons()" onpaste="' + i._var + '.updateButtons()" /><br /><br/>Password<br /><input id="inpPasswd" type="password" style="width:250px" onkeyup="' + i._var + '.updateButtons(event)" oncopy="' + i._var + '.updateButtons()" onpaste="' + i._var + '.updateButtons()" />', [{
        label: "Login",
        img: IMG_ACCEPT,
        action: function() {
            t && t($$("inpUname").value, $$("inpPasswd").value)
        }
    }], "DbNinja Login"), i.updateButtons = function(n) {
        var t = $$("inpUname").value && $$("inpPasswd").value;
        n && n.keyCode == 13 && t ? r.pressButton(0) : DisableElem(r.getButtonElem(0), !t)
    }, i.updateButtons(), n ? ($$("inpUname").value = n, $$("inpPasswd").focus()) : $$("inpUname").focus(), i.close = function() {
        Storage.dispose(i), r.close()
    }, i
}

function YesNoDialog(n, t, i, r, u) {
    var f = new Dialog,
        e = [{
            label: "Yes",
            img: IMG_ACCEPT,
            action: function() {
                f.close(), t && t()
            }
        }, {
            label: "No",
            img: IMG_CANCEL,
            action: function() {
                f.close(), i && i()
            }
        }];
    r ? e.push({
        label: "Cancel",
        img: IMG_UNDO,
        action: f.close,
        selected: 1,
        onEscape: 1
    }) : (e[u === undefined ? 1 : 0].onEscape = 1, e[u === undefined ? 1 : 0].selected = 1), f.show(n, e)
}

function UploadDialog(n, t, i, r) {
    function f() {
        u.getButtonElem(0).innerHTML = "Upload", DisableElem(u.getButtonElem(0), !0), DisableElem(u.getButtonElem(1), !1), u.getButtonElem(1).focus()
    }
    var u = new Dialog,
        s = "../../data.php?action=upload&sessid=" + Cookies.get("PHPSESSID"),
        e, o;
    return u.show('<div id="phSwfUpl" style="width:270px;height:90px"><\/div>', [{
        label: "Upload",
        img: IMG_ACCEPT,
        width: 75,
        action: function() {
            var n = swfobject.getObjectById("phSwfUpl");
            u.getButtonElem(0).innerHTML == "Upload" ? n.upload(s, "Filedata") : n.close()
        }
    }, {
        label: "Cancel",
        img: IMG_CANCEL,
        action: function() {
            u.close()
        },
        selected: 1,
        onEscape: 1
    }], n), u.handleFileSelect = function(n, t) {
        var f = i && t > i;
        f && Alert(r || "File is too large. Maximum size is " + i), DisableElem(u.getButtonElem(0), f)
    }, u.handleUploadStart = function() {
        u.getButtonElem(0).innerHTML = "Abort", DisableElem(u.getButtonElem(1), !0)
    }, u.handleError = function(n) {
        f(), Alert(n)
    }, u.handleDone = function(n) {
        u.close();
        var i, r = !1;
        try {
            if (i = n.match(/^file:(.+)/), !i) throw {
                message: "Error: " + n
            };
        } catch (f) {
            Alert(f.message, "Error"), r = !0
        }!r && t && t(i[1])
    }, u.handleAbort = function() {
        f()
    }, e = u.close, u.close = function() {
        swfobject.removeSWF("phSwfUpl"), e()
    }, f(), o = {
        showUpload: 0,
        uploadStartCallback: u._var + ".handleUploadStart",
        selectCallback: u._var + ".handleFileSelect",
        errorCallback: u._var + ".handleError",
        completeCallback: u._var + ".handleDone",
        abortCallback: u._var + ".handleAbort",
        maxSize: APP.calc_max_upload_size
    }, swfobject.embedSWF("js/lib/uploader.swf", "phSwfUpl", "260", "75", "10.0.0", null, o, {
        wmode: "transparent",
        allowScriptAccess: "always"
    }, null, function(r) {
        r.success || (u.close(), UploadDialogIfr(n, t, i))
    }), u
}

function UploadDialogIfr(n, t, i) {
    var r = new Dialog;
    r.show('<form id="frmFu" method="post" action="data.php?action=upload" target="ifrFu" enctype="multipart/form-data">' + (i ? '<input type="hidden" name="MAX_FILE_SIZE" value="' + i + '" />' : "") + '<div style="margin-bottom:5px;font-weight:bold">Please choose a file<\/div><input id="fuu" name="Filedata" type="file" style="width:330px" /><\/form>', [{
        label: "Upload",
        img: IMG_ACCEPT,
        action: function() {
            if (!$$("fuu").value.trim()) {
                alert("You need to choose a file");
                return
            }
            var n = new Dialog;
            n.show("Uploading. Please wait...", null, "File Upload"), AddEvent($$("ifrFu"), "load", function() {
                var u = !1,
                    i, r;
                try {
                    if (i = TextContent($$("ifrFu").contentWindow.document.documentElement), r = i.match(/^file:(.+)/), !r) throw {
                        message: "Error: " + i
                    };
                } catch (f) {
                    Alert(f.message, "Error"), u = !0
                }
                RemoveNode("frmFu"), n.close(), !u && t && t(r[1])
            }, !0), document.body.appendChild($$("frmFu")), $$("frmFu").style.display = "none", r.close(), setTimeout(function() {
                $$("frmFu").submit()
            }, 100)
        }
    }, {
        label: "Cancel",
        img: IMG_CANCEL,
        action: function() {
            r.close()
        },
        onEscape: 1
    }], n)
}

function HandleDrag(n, t, i, r) {
    var f = GetMousePosition(n),
        u = [],
        e = !0;
    u.push(AddEvent(document, "mousemove", function(n) {
        e && (r && r(), e = !1);
        var i = GetMousePosition(n);
        i = t(i[0] - f[0], i[1] - f[1]), f[0] += i[0], f[1] += i[1]
    })), u.push(AddEvent(document, "mouseup", function(n) {
        RemoveEvents(u), i && i(n)
    })), u.push(AddEvent(document, "mouseout", function(n) {
        if (n.relatedTarget) return !0;
        RemoveEvents(u), i && i(n)
    }))
}

function StartMover(n, t) {
    var i = ScreenBlock.block("");
    HandleDrag(n, function(n, i) {
        return t.style.left = parseInt(t.style.left) + n + "px", t.style.top = parseInt(t.style.top) + i + "px", [n, i]
    }, function() {
        i.remove()
    })
}

function StartDragger(n, t, i, r, u) {
    var f = CreateElem("div");
    f.style.position = "absolute", f.style.left = t + "px", f.style.top = i + "px", f.style.zIndex = 1e4, f.style.cursor = "default", f.style.backgroundColor = "white", f.innerHTML = r, HandleDrag(n, function(n, t) {
        return f.style.left = parseInt(f.style.left) + n + "px", f.style.top = parseInt(f.style.top) + t + "px", [n, t]
    }, function(n) {
        if (RemoveNode(f), u) {
            var t = DiveToAttribute($target(n), "data-dropzone");
            u(t ? t[0] : null)
        }
    })
}

function StartHSplitter(n, t, i, r, u, f) {
    var a, e, c, v, o, l, s, h;
    document.body.style.cursor = "ew-resize", a = ScreenBlock.block(""), e = CreateElem("div", i.parentNode), e.setAttribute("data-sticky", i.getAttribute("data-sticky")), e.className = "hSplitterDrag", ValidateLayout(e), c = v = parseInt(GetStyle(t, "width")), o = l = parseInt(GetStyle(r, "width")), s = parseInt(GetStyle(t, "minWidth")), s || (s = 50), h = parseInt(GetStyle(r, "minWidth")), h || (h = 50), HandleDrag(n, function(n, t) {
        var i;
        return n < 0 ? (i = c + n, i < s && (n += s - i)) : (i = o - n, i < h && (n += i - h)), c += n, o -= n, AddToSticky(e, 0, n, !0), u && u(n), [n, t]
    }, function() {
        a.remove(), t.style.width = c + "px", AddToSticky(i, 0, l - o, !0), AddToSticky(r, 0, l - o, !0), ValidateLayout(t), CallLater(function() {
            RemoveNode(e)
        }), document.body.style.cursor = "default", f && f()
    })
}

function StartVSplitter(n, t, i, r, u, f) {
    var a, e, o, v, s, l, y, h, c;
    document.body.style.cursor = "ns-resize", a = ScreenBlock.block(""), e = CreateElem("div", i.parentNode), e.setAttribute("data-sticky", i.getAttribute("data-sticky")), e.className = "vSplitterDrag", ValidateLayout(e), o = v = parseInt(GetStyle(t, "height")), y = parseInt(GetStyle(i, "height")), s = l = parseInt(GetStyle(r, "height")), h = parseInt(GetStyle(t, "minHeight")), h || (h = 50), c = parseInt(GetStyle(r, "minHeight")), c || (c = 50), HandleDrag(n, function(n, t) {
        var i;
        return t < 0 ? (i = o + t, i < h && (t += h - i)) : (i = s - t, i < c && (t += i - c)), o += t, s -= t, AddToSticky(e, 2, t, !0), u && u(t), [n, t]
    }, function() {
        a.remove(), t.style.height = o + "px", AddToSticky(i, 2, l - s, !0), AddToSticky(r, 2, l - s, !0), ValidateLayout(t), CallLater(function() {
            RemoveNode(e)
        }), document.body.style.cursor = "default", f && f(o)
    })
}

function StartResizer(n, t, i) {
    HandleDrag(n, function(n, r) {
        var e = t.style.minWidth ? parseInt(t.style.minWidth) : 50,
            o = t.style.minHeight ? parseInt(t.style.minHeight) : 50,
            u = parseInt(t.style.width) + n,
            f = parseInt(t.style.height) + r;
        return u < e && (n += e - u, u = e), f < o && (r += o - f, f = o), t.style.width = u + "px", t.style.height = f + "px", i && i(n), [n, r]
    }, function() {})
}

function ListBox(n, t, i, r) {
    var u = Storage.store(this, "ListBox"),
        f = null,
        e = [],
        o;
    r || (r = {});
    var s = r.height,
        h = r.width,
        y = parseInt(r.itemCount),
        c = r.minWidth,
        l = r.maxWidth,
        a = r.minHeight,
        v = r.maxHeight || y * 23 + 1 || null,
        p = r.tooltipField || "tooltip";
    return u.selectedItem = null, u.selectedIndex = -1, u.selectedLabel = "", u.data = t || [], u.draw = function() {
        n.innerHTML += '<div id="' + u._("phListBox") + '" class="listBox" tabindex="0" onfocus="' + u._var + '.setEvents(1)" onblur="' + u._var + '.setEvents(0)" style="' + (s ? "height:" + s + "px;" : (a ? "min-height:" + a + "px;" : "") + (v ? "max-height:" + v + "px;" : "")) + (h ? "width:" + h + "px;" : (c ? "min-width:" + c + "px;" : "") + (l ? "max-width:" + l + "px;" : "")) + '"' + (r.sticky ? ' data-sticky="' + r.sticky + '"' : "") + '><div id="' + u._("ListBox") + '" data-sticky="1,1,1,1" style="overflow:hidden; max-height: 400px; background-color: white; border: 1px solid lightgray"><\/div><\/div>', u.elem = u.$("phListBox"), u.itemsElem = u.$("ListBox"), u.fill(), ValidateLayout(u.elem), o = new AutoScrollBars(u.itemsElem, null, "vertical"), u.focus()
    }, u.fill = function(n) {
        var e, f, i, c;
        for (n && (u.data = t = n), e = [], f = 0; t && f < t.length; f++) i = t[f], i ? i.header ? e.push('<div class="listBoxHeader roundTop roundBottom">' + i.header + "<\/div>") : (c = i.getLabel ? i.getLabel() : i.label, e.push('<div id="' + u._("ListBox") + "_" + f + '" class="' + (i.selected ? 'listBoxItemSelected roundTop roundBottom"' : 'listBoxItem roundTop roundBottom" ') + (r.withContextMenu && i.getContextMenuItems ? 'onmousedown="' + u._var + ".handleMouseDown(event," + f + ')" ondblclick="' + u._var + ".handleDblClick(" + f + ')"' : 'onmouseup="' + u._var + ".selectIndex(" + f + ')"') + ' title="' + (i[p] || "") + '">' + (c || "&nbsp;") + "<\/div>")) : e.push('<div class="listBoxSeparator"><\/div>');
        u.itemsElem.innerHTML = e.join(""), s || (u.elem.style.height = u.elem.clientHeight + "px"), h || (u.elem.style.width = u.elem.clientWidth + "px"), u.selectIndex(-1, !0), o && o.updateSliders()
    }, u.setEvents = function(n) {
        if (e.length) {
            n || (RemoveEvents(e), e.length = 0);
            return
        }
        e = [AddEvent(document, "keydown", function(n) {
            var r = n.keyCode,
                s = String.fromCharCode(r),
                e, i, h, f, o;
            if (/[a-z]/i.test(s)) {
                for (e = u.selectedIndex + 1, i = e; i < t.length; i++)
                    if (!t[i].header) {
                        if (h = t[i].getLabel ? t[i].getLabel() : t[i].label, h.startWith(s)) {
                            u.selectIndex(i, !0), u.scrollToIndex(i);
                            return
                        }
                        e > 0 && i == t.length - 1 && (e = i = 0)
                    } return
            }
            if (r == 13) {
                u.handleDblClick(u.selectedIndex);
                return
            }
            if (o = 1, r == 36) f = -1;
            else if (r == 35) f = t.length, o = -1;
            else if (r == 38 || r == 40) f = u.selectedIndex, o = r - 39;
            else {
                r == 33 || r == 34;
                return
            }
            for (;;) {
                if (f += o, f > -1 && f < t.length) {
                    if (t[f].header) continue;
                    u.selectIndex(f, !0), u.scrollToIndex(u.selectedIndex)
                }
                break
            }
        })]
    }, u.focus = function() {
        CallLater(function() {
            u.elem.focus()
        })
    }, u.handleDblClick = function(n) {
        var r, n, i;
        if (t[n].getContextMenuItems)
            for (r = t[n].getContextMenuItems(), n = 0; n < r.length; n++)
                if (i = r[n], i && i.auto) {
                    i.action && typeof i.action == "function" ? i.action(i) : i.contextMenuHandler(i);
                    return
                }
    }, u.handleMouseDown = function(n, i) {
        if (u.selectIndex(i), n.button == 2 && t[i].getContextMenuItems) {
            var f = $target(n),
                r = GetOffset(f),
                e = r[0] + r[2] - 4,
                o = r[1] + r[3] - 4;
            new PopupMenu(e, o, t[i].getContextMenuItems(), t[i].contextMenuHandler, 90)
        }
    }, u.moveRow = function(n) {
        if (u.selectedIndex != -1 && (u.selectedIndex != 0 || !n) && (u.selectedIndex != t.length - 1 || n)) {
            var i = u.selectedItem,
                r = u.selectedIndex + (n ? -1 : 1),
                f = t.splice(r, 1);
            t.splice(u.selectedIndex, 0, f[0]), u.fill(), u.selectItem(i), u.scrollToIndex(u.selectedIndex)
        }
    }, u.selectIndex = function(n, r) {
        if (f && (f.className = "listBoxItem roundTop roundBottom"), t && n > t.length - 1 && (n = -1), n > -1) {
            var e = $$(u._("ListBox") + "_" + n);
            e.className = "listBoxItemSelected roundTop roundBottom", f = e
        } else f = null;
        u.selectedIndex = n, u.selectedItem = n > -1 ? t[n] : null, u.selectedLabel = f ? f.innerHTML : "", i && !r && i(u.selectedItem)
    }, u.scrollToIndex = function(n, t) {
        var i = $$(u._("ListBox") + "_" + n);
        if (i) {
            if (t) {
                u.itemsElem.scrollTop = i.offsetTop - (u.itemsElem.clientHeight - i.clientHeight) / 2;
                return
            }
            ScrollToView(i, u.itemsElem, 2, 2)
        }
    }, u.selectItem = function(n, i) {
        if (t) {
            var r = t.indexOf(n);
            u.selectIndex(r, i)
        }
    }, u.selectLabel = function(n) {
        var i, r;
        if (t)
            for (n = n.toLowerCase(), i = 0; i < t.length; i++)
                if (r = (t[i].getLabel ? t[i].getLabel() : t[i].label ? t[i].label : "").toLowerCase(), r == n) {
                    u.selectIndex(i, !0);
                    return
                }
    }, u.destroy = function() {
        RemoveEvents(e), o && o.destroy(), RemoveNode(u.elem), Storage.dispose(u)
    }, u.draw(), u
}

function PopupMenu(n, t, i, r, u, f, e, o) {
    function a(n) {
        if (n) {
            for (var t = s; t.child;) t = t.child;
            for (;;) {
                if (DiveToElem($target(n), t.elem)) return;
                if (t.destroy(), !t.parent) return;
                t = t.parent
            }
        } else __MainPopup.destroy()
    }
    var s = Storage.store(this, "PopupMenu"),
        c = [],
        h, l;
    return s.selectedIndex = -1, s.parent = null, s.child = null, s.popupParentRow = null, s.data = i || [], l = document.activeElement, o ? s.parent = o : (__MainPopup && __MainPopup.destroy(), __MainPopup = s, CallLater(function() {
        c = [AddEvent(document, "mousedown", a)], e && c.push(AddEvent(document, "mouseup", a))
    })), s.draw = function() {
        var h, e, r, f, o;
        if (s._) {
            for (h = [], e = 0; e < i.length; e++)
                if (r = i[e], r != null) {
                    if (r.header) {
                        h.push('<div class="listBoxHeader">' + r.header + "<\/div>");
                        continue
                    }
                    if (f = r.getLabel ? r.getLabel() : r.label, !f) continue;
                    f.length > 50 && (f = f.substr(0, 50) + "..."), r.disabled ? h.push('<div id="' + s._("popupMenu") + "_" + e + '" class="roundTop roundBottom popupMenuItem popupMenuItemDisabled"' + (r.icon ? ' style="background-image:url(' + r.icon + ')"' : "") + ' onmouseover="' + s._var + ".handleItemOver(" + e + ')">' + (r.checked ? "<li><span>" + f + "<\/span><\/li>" : "<span>" + f + "<\/span>") + (r.children ? '<div class="popupMenuItemWithKids"><\/div>' : "") + "<\/div>") : h.push((r.href ? '<a href="' + r.href + '"' + (r.target ? ' target="' + r.target + '"' : "") + ">" : "") + '<div id="' + s._("popupMenu") + "_" + e + '" class="roundTop roundBottom ' + (r.selected ? 'popupMenuItemSelected" ' : 'popupMenuItem" ') + (r.children ? 'onmousedown="StopPropagation(event)"' : 'onmouseup="' + s._var + '.handleItemClick()"') + (r.icon ? ' style="background-image:url(' + r.icon + ')"' : "") + ' onmouseover="' + s._var + ".handleItemOver(" + e + ')">' + (r.checked ? "<li><span>" + f + "<\/span><\/li>" : "<span>" + f + "<\/span>") + (r.children ? '<div class="popupMenuItemWithKids"><\/div>' : "") + "<\/div>" + (r.href ? "<\/a>" : ""))
                } else h.push('<div class="popupMenuSeparator"><\/div>');
            o = CreateElem("div"), o.style.position = "absolute", o.style.left = n + 2 + "px", o.style.top = t + 2 + "px", o.style.zIndex = 100, o.innerHTML = '<div id="' + s._("phPopupBox") + '" tabindex="0" class="popupMenu shadow" onkeydown="' + s._var + '.handleKeyDown(event)" style="' + (u ? "min-width:" + u + "px;" : "") + '">' + h.join("") + "<\/div>", s.elem = o, MoveIntoView(s.elem), s.$("phPopupBox").focus()
        }
    }, s.handleKeyDown = function(n) {
        var r, t, u, f, e;
        if (StopPropagation(n), r = n.keyCode, r == 27 || r == 37 && s != __MainPopup) {
            s.destroy();
            return
        }
        if (t = s.selectedIndex, t == -1 && r == 39) {
            s.handleItemOver(0);
            return
        }
        if (u = i[t], t > -1 && (r == 13 || r == 39) && u.children) {
            s.handleItemOver(t);
            return
        }
        if (t > -1 && r == 13) {
            if (u.href) {
                $$(s._("popupMenu") + "_" + t).parentNode.click();
                return
            }
            u.disabled || CallLater(s.handleItemClick)
        } else if (r == 38 || r == 40) {
            f = r - 39, e = i.length;
            do t += f, f == 1 && t > i.length - 1 ? t = 0 : f == -1 && t < 0 && (t = i.length - 1); while (--e && s.handleItemOver(t, !0) === null)
        }
    }, s.handleItemClick = function() {
        if (s.selectedIndex != -1 && !i[s.selectedIndex].href) {
            var n = i[s.selectedIndex];
            typeof n.action == "function" ? n.action(n) : r && r(n), __MainPopup.destroy()
        }
    }, s.handleItemOver = function(n, t) {
        var f = $$(s._("popupMenu") + "_" + n);
        if (!f) return null;
        if (h && (h.className = h.className.replace(" popupMenuItemSelected", "")), f.className += " popupMenuItemSelected", h = f, s.selectedIndex = n, s.popupParentRow)
            if (s.popupParentRow != f) s.child.destroy();
            else return;
        if (i[n].children && !i[n].disabled && !t) {
            var e = GetOffset(f),
                o = e[0] + e[2] - 3,
                c = e[1] - 4;
            s.child = new PopupMenu(o, c, i[n].children, r, u, null, null, s), s.popupParentRow = f
        }
    }, s.destroy = function() {
        s.child && s.child.destroy(), s.parent && (s.parent.child = s.parent.popupParentRow = null), RemoveNode(s.elem), Storage.dispose(s), l && l.focus(), __MainPopup == s && (RemoveEvents(c), __MainPopup = null, f && f())
    }, CallLater(s.draw), s
}

function ListBoxTopMenu(n) {
    function r(n, t) {
        n.className = "ListBoxTopMenuItem" + (t ? "Selected" : "") + " roundTop roundBottom"
    }
    var t = Storage.store(this, "TopMenu"),
        i = null;
    return t.create = function(i) {
        var u, r;
        for (t.data = i, u = ['<div id="' + t._("topMenu") + '" class="ListBoxTopMenu">'], r = 0; r < i.length; r++) u.push('<div class="ListBoxTopMenuItem roundTop roundBottom" onmouseover="' + t._var + ".over(this," + r + ',1)" onmouseout="' + t._var + ".over(this," + r + ',0)" onmouseup="StopPropagation(event)" onmousedown="' + t._var + ".open(this," + r + ')"' + (i[r].disabled ? ' disabled="disabled" style="color:#aaaaaa;opacity:1"' : "") + ">" + i[r].label + "<\/div>");
        n.innerHTML = u.join("") + "<\/div>"
    }, t.open = function(n, u) {
        if (!i && (i = n, t.data[u].children)) {
            r(i, !0);
            var f = GetOffset(n);
            new PopupMenu(f[0] - 3, f[1] + 20, t.data[u].children, t.data[u].handler, 100, function() {
                r(i, !1), i = null
            }, !0)
        }
    }, t.over = function(n, u, f) {
        if (f) {
            if (i && (r(i, !1), i != n && (__MainPopup && __MainPopup.destroy(), i = null, t.open(n, u))), !t.data[u].children) return;
            r(n, !0)
        } else n != i && r(n, !1)
    }, t.destroy = function() {
        __MainPopup && __MainPopup.destroy(), RemoveNode(t._("topMenu")), Storage.dispose(t)
    }, t
}

function ListContainer(n) {
    var t = Storage.store(this, "ListContainer"),
        i;
    return n.innerHTML = '<div id="' + t._("ListCont") + '" class="ListContainer" data-sticky="2,2,2,2"><\/div>', ValidateLayout(t._("ListCont")), i = new AutoScrollBars(t.$("ListCont"), null, "vertical"), t.create = function(n) {
        var r, i;
        for (t.data = n, r = [], i = 0; i < n.length; i++) r.push('<div id="' + t._("ListContHead") + "_" + i + '" class="ListContainerHeader" onclick="' + t._var + ".open(" + i + ')">' + n[i].label + "<\/div>"), n[i].content && r.push('<div id="' + t._("ListContChld") + "_" + i + '" class="ListContainerContent" style="display:none">' + n[i].content + "<\/div>");
        for (t.$("ListCont").innerHTML = r.join(""), i = 0; i < n.length; i++) n[i]._open && t.open(i)
    }, t.getContentHeader = function(n) {
        return $$(t._("ListContHead") + "_" + n)
    }, t.getContentElem = function(n) {
        return $$(t._("ListContChld") + "_" + n)
    }, t.isOpen = function(n) {
        return $$(t._("ListContChld") + "_" + n).style.display == ""
    }, t.open = function(n) {
        var r = t.getContentHeader(n),
            u = t.getContentElem(n);
        r.className.indexOf("Selected") > -1 ? (r.className = "ListContainerHeader", u.style.display = "none", t.data[n]._open = !1) : (r.className += " ListContainerHeaderSelected", u.style.display = "", ScrollToView(u, t.$("ListCont")), t.data[n]._open = !0), i.updateSliders()
    }, t.clear = function() {
        t.$("ListCont").innerHTML = ""
    }, t.destroy = function() {
        i.destroy(), RemoveNode(t._("ListCont")), Storage.dispose(t)
    }, t
}

function IconMenu(n, t) {
    var i = Storage.store(this, "IconMenu");
    return i.create = function(t) {
        var r, f, u;
        for (i.data = t, f = ['<div id="' + i._("iconMenu") + '" class="IconMenu">'], u = 0; u < t.length; u++)(r = t[u]) ? f.push((r.href ? '<a href="' + r.href + '"' + (r.target ? ' target="' + r.target + '"' : "") + ">" : "") + '<div class="IconMenuItem' + (r.disabled ? "Disabled" : "") + '" roundTop roundBottom" style="background-image:url(' + r.icon + ')" ' + (r.action ? 'onclick="' + i._var + ".handleClick(" + u + ')"' : "") + ' title="' + (r.title.replace(/"/g, "&quot;") || "") + '">' + (r.disabled ? '<div class="IconMenuItemDisabled" style="left:-1px;top:-1px"><\/div>' : "") + "<\/div>" + (r.href ? "<\/a>" : "")) : f.push('<div class="IconMenuSeparator"><\/div>');
        n.innerHTML = f.join("") + '<div style="clear:both"><\/div><\/div>'
    }, i.handleClick = function(n) {
        var t = i.data[n];
        t && !t.disabled && t.action && t.action(t)
    }, i.destroy = function() {
        RemoveNode(i._("iconMenu")), Storage.dispose(i)
    }, t && i.create(t), i
}

function NumInput(n, t, i, r) {
    var u = Storage.store(this, "NumInput"),
        f, e = 0;
    u.minimum = -Infinity, u.maximum = Infinity, u.allowDot = !1, u.value = t, u.fill = function() {
        n.innerHTML = '<div id="' + u._("NumInput") + '" style="width:' + i + 'px" class="numInput">\t<input id="' + u._("NumInputTxt") + '" type="text" onpaste="' + u._var + '.handlePaste(event)" style="border:none;outline:none;height:19px;width:' + (i - 28) + 'px" value="' + u.value + '" class="numInputText" \t\tonkeypress="' + u._var + '.handleKeyPress(event)" onkeydown="' + u._var + '.handleKeyDown(event)" onkeyup="' + u._var + '.handleKeyUp(event)" onblur="if(' + u._var + ")" + u._var + '.validate(1)"/>\t<div id="' + u._("NumInputBtnUp") + '" onmousedown="' + u._var + '.handleArrow(+1)" class="numInputButton" style="top:0px; left:' + (i - 22) + 'px; border-bottom:1px solid #adadad; width:21px; background-image:url(images/gui/combo_up.gif)"><\/div>\t<div id="' + u._("NumInputBtnDown") + '" onmousedown="' + u._var + '.handleArrow(-1)" class="numInputButton" style="top:12px; height:10px; left:' + (i - 22) + 'px; width:21px; background-image:url(images/gui/combo_down.gif)"><\/div>\t<div id="' + u._("NumInputDis") + '" style="width:' + i + 'px; display:none" class="numInputDisabler"><\/div><\/div>', u.input = u.$("NumInputTxt")
    }, u.focus = function() {
        u.input.select()
    }, u.setValue = function(n, t) {
        u.value = parseFloat(n), u.input.value = n, r && !t && r(n)
    }, u.setDisabled = function(n) {
        u.$("NumInputDis").style.display = n ? "" : "none", u.input.disabled = n ? "disabled" : null
    }, u.handleKeyDown = function(n) {
        var t = n.charCode ? n.charCode : n.keyCode;
        (t == 38 || t == 40) && u.handleArrow(39 - t, !0)
    }, u.handleKeyUp = function(n) {
        var t = n.charCode ? n.charCode : n.keyCode;
        (t == 8 || t == 46) && u.validate()
    }, u.handlePaste = function() {
        var n = InputBox.GetCaretPosition(u.input),
            t = u.input.value;
        CallLater(function() {
            var i = u.input.value;
            isNaN(i) || !u.allowDot && i.indexOf(".") > -1 ? (u.input.value = t, InputBox.SetCaretPosition(u.input, n)) : u.validate()
        })
    }, u.handleKeyPress = function(n) {
        var t = n.charCode || n.keyCode,
            i;
        if (!([8, 37, 39, 35, 36].indexOf(t) > -1)) {
            if (t = String.fromCharCode(t), i = u.input, /[0-9]/.test("" + t) || t == "." && i.value.indexOf(".") == -1 && u.allowDot || t == "-" && u.minimum < 0 && InputBox.GetCaretPosition(i) == 0 && i.value.indexOf("-") == -1) {
                CallLater(u.validate);
                return
            }
            n.returnValue = !1, n.preventDefault && n.preventDefault()
        }
    }, u.validate = function(n) {
        var t, i;
        t = i = parseFloat(u.input.value), isNaN(t) && (t = u.minimum < 0 && u.maximum > 0 ? 0 : u.minimum > -Infinity ? u.minimum : u.maximum >= 0 ? 0 : u.maximum), t < u.minimum && (t = u.minimum), t > u.maximum && (t = u.maximum), n ? u.setValue(t) : t == i ? u.setValue(u.input.value) : r && r(t)
    }, u.handleArrow = function(n, t) {
        var i, r = parseFloat(u.input.value);
        (i = isNaN(r) ? u.minimum < 0 && u.maximum > 0 ? 0 : u.minimum > -Infinity ? u.minimum : u.maximum >= 0 ? 0 : u.maximum : r + n, i >= u.minimum && i <= u.maximum && u.setValue(i), t) || (AddEvent(document, "mouseup", function() {
            clearInterval(f), e = 0
        }, !0), f = setInterval(function() {
            var i = Math.pow(10, parseInt(++e / 10)),
                t;
            i > 1e3 && (i = 1e3), t = parseFloat(u.input.value) + n * i, t < u.minimum ? u.setValue(u.minimum) : t > u.maximum ? u.setValue(u.maximum) : u.setValue(t)
        }, 150))
    }, u.destroy = function() {
        Storage.dispose(u)
    }, u.fill()
}

function AutoScrollBars(n, t, i) {
    var u = Storage.store(this, "AutoScrollBars"),
        c, e, o;
    i || (i = "both");
    var s = i == "both" || i == "horizontal",
        h = i == "both" || i == "vertical",
        l = GetSticky(n, 0),
        f = GetSticky(n, 1),
        a = GetSticky(n, 2),
        r = GetSticky(n, 3);
    this.verticalVisible = !1, this.horizontalVisible = !1, c = n.parentNode, h && (n.style.overflowY = "hidden", e = new ScrollBar(c, n, !0, ["", f, a, r].join(","))), s && (n.style.overflowX = "hidden", o = new ScrollBar(c, n, !1, [l, f, "", r].join(","))), this.updateSliders = function() {
        c.removeAttribute("data-sticky-callback", u._var + ".updateSliders()"), h && e.setVisible(!1), s && o.setVisible(!1);
        var l = !1,
            i = !1;
        SetSticky(n, 1, f), SetSticky(n, 3, r), ValidateLayout(n), s && n.scrollWidth > n.clientWidth && (i = !0, SetSticky(n, 3, r + __ScrollSize + 1), ValidateLayout(n)), h && n.scrollHeight > n.clientHeight && (l = !0, SetSticky(n, 1, f + __ScrollSize + 1), ValidateLayout(n), s && !i && (SetSticky(n, 3, r + __ScrollSize + 1), ValidateLayout(n), i = n.scrollWidth > n.clientWidth, i || (SetSticky(n, 3, r), ValidateLayout(n)))), t && (u.verticalVisible != l || u.horizontalVisible != i) && t(l, i), u.verticalVisible = l, u.horizontalVisible = i, i && (o.setVisible(!0), o.setBorder(l ? "1px 1px 0 0" : "1px 0 0 0"), SetSticky(o.elem, 1, l ? f + __ScrollSize : f)), l && (e.setVisible(!0), e.setBorder(i ? "0 0 1px 1px" : "0 0 0 1px"), SetSticky(e.elem, 3, i ? r + __ScrollSize : r)), ValidateLayout(c), h && l && e.updateSlider(), s && i && o.updateSlider(), n.parentNode.setAttribute("data-sticky-callback", u._var + ".updateSliders()")
    }, this.destroy = function() {
        SetSticky(n, 1, f), SetSticky(n, 3, r), n.parentNode.removeAttribute("data-sticky-callback"), h && e.destroy(), s && o.destroy(), Storage.dispose(u)
    }, this.updateSliders()
}

function ScrollBar(n, t, i, r) {
    function p() {
        r || (r = "0,0,0,0"), f = CreateElem("div", n), f.id = u._("__ScrollBar"), f.setAttribute("data-sticky", r), l = AddEvent(f, "mousedown", u.handlePageScroll), a = AddEvent(f, WHEEL_EVENT, function(n) {
            u.handleMouseWheel(n, !i)
        }), i ? (f.innerHTML = '<div id="' + u._("__ScrollBarButt1_") + '" class="VScrollButtonUp VScrollButton" onmousedown="' + u._var + '.scroll($target(event), -1)"><\/div><div id="' + u._("__ScrollBarSlider") + '" class="VScrollSlider" style="position:absolute" onmousedown="' + u._var + '.drag(event)"><\/div><div id="' + u._("__ScrollBarButt2_") + '" class="VScrollButtonDown VScrollButton" style="position:absolute; bottom:0" onmousedown="' + u._var + '.scroll($target(event), 1)"><\/div>', f.className = "VScrollArea") : (f.innerHTML = '<div id="' + u._("__ScrollBarButt1_") + '" class="HScrollButtonLeft HScrollButton" style="position:absolute; left:0" onmousedown="' + u._var + '.scroll($target(event), -1)"><\/div><div id="' + u._("__ScrollBarSlider") + '" class="HScrollSlider" style="position:absolute" onmousedown="' + u._var + '.drag(event)"><\/div><div id="' + u._("__ScrollBarButt2_") + '" class="HScrollButtonRight HScrollButton" style="position:absolute; right:0" onmousedown="' + u._var + '.scroll($target(event), 1)"><\/div>', f.className = "HScrollArea"), u.elem = f, u.updateSlider()
    }
    var u = Storage.store(this, "ScrollBar"),
        f, h = -1,
        c = -1,
        o, e, s = 0,
        l, a, v, y;
    this.setVisible = function(n) {
        f.style.display = n ? "" : "none"
    }, this.setBorder = function(n) {
        f.style.borderWidth = n
    }, this.updateSlider = function(n) {
        var s, r;
        n && (c == t.scrollTop && i || h == t.scrollLeft && !i) || (s = (i ? f.clientHeight : f.clientWidth) - (__ScrollButtSize * 2 + 2), e = parseInt(s * (i ? t.clientHeight / t.scrollHeight : t.clientWidth / t.scrollWidth)), e < __ScrollMinSize && (e = __ScrollMinSize), o = s - e, e >= s && (e = o), r = u.$("__ScrollBarSlider"), r.style.display = e > 0 ? "" : "none", f.disabled = o > 0 && e <= 0, i ? (r.style.height = e + "px", r.style.top = parseInt(o * (t.scrollTop / (t.scrollHeight - t.clientHeight)) + __ScrollButtSize) + "px", c = t.scrollTop) : (r.style.width = e + "px", r.style.left = parseInt(o * (t.scrollLeft / (t.scrollWidth - t.clientWidth)) + __ScrollButtSize) + "px", h = t.scrollLeft))
    }, this.handlePageScroll = function(n) {
        if ($target(n) == f) {
            var r = u.$("__ScrollBarSlider").getBoundingClientRect(),
                e = GetMousePosition(n);
            i ? t.scrollTop += t.clientHeight * (r.top > e[1] ? -1 : 1) : t.scrollLeft += t.clientWidth * (r.left > e[0] ? -1 : 1)
        }
    }, this.destroy = function() {
        var n = u.$("__ScrollBar");
        n && n.parentNode.removeChild(n), RemoveEvent(l), RemoveEvent(a), RemoveEvent(v), RemoveEvent(y), Storage.dispose(u)
    }, this.drag = function(n) {
        HandleDrag(n, function(n, r) {
            var f, u;
            return i ? (f = t.scrollTop, u = (t.scrollHeight - parseInt(t.style.height)) / o, t.scrollTop += parseInt(r * u), r = (t.scrollTop - f) / u) : (f = t.scrollLeft, u = (t.scrollWidth - parseInt(t.style.width)) / o, t.scrollLeft += parseInt(n * u), n = (t.scrollLeft - f) / u), [n, r]
        })
    }, this.scroll = function(n, r) {
        if (n) {
            var f = AddEvent(n, "mouseout", function() {
                s = 2, AddEvent(n, "mouseover", function() {
                    s == 2 && (s = 1)
                }, !0)
            });
            AddEvent(document, "mouseup", function() {
                RemoveEvent(f), s = 0
            }, !0), AddEvent(document, "mouseout", function(n) {
                if (n.relatedTarget) return !0;
                RemoveEvent(f), s = 0
            }, !0), s = 1
        }
        s == 1 && (i ? t.scrollTop += __ScrollStep * r : t.scrollLeft += __ScrollStep * r, setTimeout(function() {
            u.scroll(null, r)
        }, __ScrollInterval))
    }, this.scrollPercent = function(n) {
        i ? this.scrollTo((t.scrollHeight - parseInt(t.style.height)) * (n / 100)) : this.scrollTo((t.scrollWidth - parseInt(t.style.width)) * (n / 100))
    }, this.scrollTo = function(n) {
        i ? t.scrollTop = n : t.scrollLeft = n
    }, this.getScrollValue = function() {
        return i ? t.scrollTop : t.scrollLeft
    }, this.handleMouseWheel = function(n, r) {
        if (i || n.shiftKey || r) {
            var u;
            n.wheelDelta ? (u = n.wheelDelta, window.opera && (u = u / 4)) : n.detail && (u = -n.detail * 20), u < -25 ? u = -25 : u > 25 && (u = 25), i && !n.shiftKey ? t.scrollTop -= u : t.scrollLeft -= u, n.preventDefault && n.preventDefault()
        }
    }, p(), v = AddEvent(t, "scroll", this.updateSlider), y = AddEvent(t, WHEEL_EVENT, this.handleMouseWheel)
}

function ValidateLayouts(n) {
    n || (n = [document.body]);
    for (var t = 0; t < n.length; t++) ValidateLayout(n[t])
}

function IntOrDef(n, t) {
    var i = parseInt(n);
    return isNaN(i) ? t : i
}

function ValidateLayout(n) {
    var t, c, l, u, o, s, i, h, r;
    if (typeof n == "string" && (n = $$(n)), n && n.tagName) {
        if (r = n.getAttribute("data-sticky"), r) {
            n.style.position = "absolute", t = r.split(":"), t.length > 1 && (u = t[1].split(","), c = parseInt(u[0]), l = parseInt(u[1]), c && (n.style.width = c + "px"), l && (n.style.height = l + "px")), t = t[0].split(",");
            var f = parseInt(t[0]),
                a = parseInt(t[1]),
                u = parseInt(t[2]),
                v = parseInt(t[3]),
                y = n.getBoundingClientRect(),
                e = n.parentNode.getBoundingClientRect();
            isNaN(a) || (isNaN(f) ? n.style.left = e.width - y.width - a - IntOrDef(GetStyle(n, "paddingLeft"), 0) - IntOrDef(GetStyle(n.parentNode, "borderLeftWidth"), 0) + "px" : (o = e.width - f - a, i = n.getAttribute("data-minwidth"), i && o < i && (o = i), n.style.width = o - IntOrDef(GetStyle(n, "paddingLeft"), 0) - IntOrDef(GetStyle(n, "paddingRight"), 0) - IntOrDef(GetStyle(n, "borderLeftWidth"), 0) - IntOrDef(GetStyle(n, "borderRightWidth"), 0) + "px")), isNaN(f) || (n.style.left = n.getAttribute("data-offscreen") ? -1e4 : f - IntOrDef(GetStyle(n.parentNode, "paddingLeft"), 0) - IntOrDef(GetStyle(n.parentNode, "borderLeftWidth"), 0) + "px"), isNaN(v) || (isNaN(u) ? n.style.top = e.height - y.height - v - IntOrDef(GetStyle(n.parentNode, "paddingTop"), 0) - IntOrDef(GetStyle(n.parentNode, "borderTopWidth"), 0) + "px" : (s = e.height - u - v, i = n.getAttribute("data-minheight"), i && s < i && (s = i), n.style.height = s - IntOrDef(GetStyle(n, "paddingTop"), 0) - IntOrDef(GetStyle(n, "paddingBottom"), 0) - IntOrDef(GetStyle(n, "borderTopWidth"), 0) - IntOrDef(GetStyle(n, "borderBottomWidth"), 0) + "px")), isNaN(u) || (n.style.top = n.getAttribute("data-offscreen") ? -1e4 : u - IntOrDef(GetStyle(n.parentNode, "paddingTop"), 0) - IntOrDef(GetStyle(n.parentNode, "borderTopWidth"), 0) + "px")
        }
        for (h = 0; h < n.childNodes.length; h++) ValidateLayout(n.childNodes[h]);
        r && (r = n.getAttribute("data-sticky-callback"), r && eval(r))
    }
}

function AddToSticky(n, t, i, r) {
    var u = n.getAttribute("data-sticky").toString();
    u = u ? u.split(",") : ["", "", "", ""], u[t] != "" && (u[t] = parseInt(u[t]) + i), n.setAttribute("data-sticky", u.join(",")), r && ValidateLayout(n)
}

function SetSticky(n, t, i, r) {
    var u = n.getAttribute("data-sticky").toString();
    u = u ? u.split(",") : ["", "", "", ""], u[t] = i, n.setAttribute("data-sticky", u.join(",")), r && ValidateLayout(n)
}

function GetSticky(n, t) {
    var i = n.getAttribute("data-sticky").toString();
    return i = i ? i.split(",") : ["", "", "", ""], isNaN(i[t]) ? i[t] : parseInt(i[t])
}

function CenterSticky(n) {
    var t = (document.body.clientWidth - n.clientWidth) / 2,
        i = (document.body.clientHeight - n.clientHeight) / 2;
    n.setAttribute("data-sticky", t + ",," + i + ","), ValidateLayout(n)
}

function TabNav(n, t, i, r, u, f) {
    var e = Storage.store(this, "TabNav"),
        s = 37,
        h, o;
    this.items = t, u || (u = "0,0,2,0"), this.prepScrollArrows = function() {
        var n = e.$("__TabNavTabsPH"),
            t = n.scrollWidth - n.clientWidth,
            i = GetScrollWidth();
        if (t > 0) {
            if (n.style.overflowX == "scroll") return;
            n.style.overflowX = "scroll", n.style.height = parseInt(n.style.height) + i + "px", AddToSticky(e.$("__TabNavStack"), 2, i)
        } else {
            if (n.style.overflowX == "hidden") return;
            n.style.overflowX = "hidden", t = parseInt(n.style.height), t > s && (n.style.height = parseInt(n.style.height) - i + "px", AddToSticky(e.$("__TabNavStack"), 2, -i))
        }
        ValidateLayout(e.$("__TabNav"))
    }, n.innerHTML = '<div id="' + e._("__TabNav") + '" data-sticky="' + u + '">\t<div id="' + e._("__TabNavStack") + '" data-sticky="0,0,' + (s - 1) + ',0"><\/div>\t<div id="' + e._("__TabNavTabsPH") + '" data-sticky="0,0,0," data-sticky-callback="' + e._var + '.prepScrollArrows()" style="height:' + s + 'px;overflow:hidden">\t\t<div id="' + e._("__TabNavTabs") + '" data-sticky="0,0,5,"><\/div>\t<\/div><\/div>', h = this.stackView = new StackView(e.$("__TabNavStack"), t), o = new TabBar(e.$("__TabNavTabs"), t, function(n) {
        h.selectItem(t[n]), i && i(t[n], n)
    }, r, e.prepScrollArrows), o.draggable = f || !1, this.getSelectedItem = function() {
        return o.selectedItem
    }, this.getSelectedIndex = function() {
        return t && o.selectedItem ? t.indexOf(o.selectedItem) : -1
    }, this.selectIndex = function(n) {
        o.selectIndex(n), o.selectedElem && ScrollToView(o.selectedElem, e.$("__TabNavTabsPH"), 5, 1)
    }, this.selectItem = function(n) {
        var i = t.indexOf(n);
        i > -1 && o.selectIndex(i)
    }, this.destroy = function() {
        h.destroy(), o.destroy(), n.innerHTML = "", Storage.dispose(e)
    }
}

function StackView(n, t) {
    function f(n, t) {
        t.type == "add" ? e(t.index) : t.type == "remove" && t.objects.map(function(n) {
            n.destroy && n.destroy();
            var t = r.get(n);
            t.parentNode.removeChild(t), r.del(n), i.selectedItem == n && (i.selectedItem = null)
        })
    }

    function e(n) {
        var f = i.$("__StackView"),
            u = CreateElem("div", f);
        u.setAttribute("data-sticky", "0,0,0,0"), ValidateLayout(u), t[n].html !== undefined ? u.innerHTML = t[n].html : t[n].fill ? t[n].fill(u) : u.innerHTML = "Empty" + n, u.style.display = "none", r.add(t[n], u)
    }
    var i = Storage.store(this, "StackView"),
        r, u;
    for (this.selectedItem = null, r = new Hash, this.selectItem = function(n) {
        this.selectedItem && (r.get(this.selectedItem).style.display = "none", i.selectedItem.hide && i.selectedItem.hide()), this.selectedItem = n;
        var t = r.get(n);
        t && (t.style.display = "", ValidateLayout(t), t.focus()), n.show && n.show()
    }, this.destroy = function() {
        t.detachEventListener("change", f);
        for (var u = 0; u < t.length; u++) r.del(t[u]), t[u].destroy && t[u].destroy();
        n.innerHTML = "", Storage.dispose(i)
    }, t.attachEventListener("change", f), n.innerHTML = '<div id="' + i._("__StackView") + '" data-sticky="0,0,0,0" style="background-color:white;border:1px solid #adadad;border-top:none;overflow:hidden"><\/div>', u = 0; u < t.length; u++) e(u), t[u].selected && this.selectIndex(u)
}

function TabBar(n, t, i, r, u) {
    function e() {
        var e, o, i, s;
        for (f.selectedLabel = "", f.selectedItem = null, f.selectedElem = null, e = ['<div id="' + f._("TabBar") + '" class="TabBar">'], o = 0; o < t.length; o++) i = t[o], s = i.getLabel ? i.getLabel() : i.label, e.push('<div class="' + (i.selected ? "TabBarCurrent" : i.disabled ? "TabBarDisabled" : "") + '"' + (r ? ' style="padding-right:16px"' : "") + (i.disabled ? "" : ' onmousedown="' + f._var + '.handleClick(event,this)"') + (i.tooltip ? ' title="' + i.tooltip + '"' : "") + ">" + (r ? '<span class="TabBarCloseButt" onclick="' + f._var + '.handleClose()"><\/span>' : "") + s + "<\/div>"), i.selected && (f.selectedItem = i, f.selectedLabel = s);
        e.push("<\/div>"), n.innerHTML = e.join(""), f.repositionTabs(), u && u()
    }
    var f = Storage.store(this, "TabBar");
    f.tabLeftOffset = 8, f.tabSpacing = 4, f.draggable = !1, this.repositionTabs = function(n) {
        for (var e = f.$("TabBar").childNodes, u = this.tabLeftOffset, r, i = 0; i < e.length; i++)(r = e[i], n === undefined || (i == n && (u += f.selectedElem.clientWidth + this.tabSpacing), r != f.selectedElem)) && (r.style.left = u + "px", u += r.clientWidth + this.tabSpacing + (t[i].extraSpace || 0))
    }, this.dragTab = function(n, i) {
        var e, u;
        if (f.draggable && f.selectedElem == i) {
            e = f.$("TabBar"), u = ElemsToArray(e.childNodes).indexOf(i), i.style.zIndex = 1e3;
            var s = ScreenBlock.block(""),
                r = parseInt(i.style.left),
                h = r,
                o = !1;
            HandleDrag(n, function(n, s) {
                var l, c;
                return (r += n, !o && Math.abs(h - r) < 6) ? [n, s] : (o = !0, r < f.tabLeftOffset && (n -= r - f.tabLeftOffset, r = f.tabLeftOffset), i.style.left = r + "px", l = 0, n > 0 ? (c = i.nextElementSibling, c && r + i.clientWidth >= parseInt(c.style.left) + c.clientWidth / 2 && (e.insertBefore(c, i), l = 1)) : n < 0 && (c = i.previousElementSibling, c && r <= parseInt(c.style.left) + c.clientWidth / 2 && (e.insertBefore(i, c), l = -1)), l && (c = u, u += l, l = t[c], t[c] = t[u], t[u] = l, f.repositionTabs(u)), [n, s])
            }, function() {
                i.style.zIndex = "auto", s.remove(), f.repositionTabs()
            })
        }
    }, this.handleClick = function(n, r) {
        if (t.length) {
            var e = ElemsToArray(f.$("TabBar").childNodes),
                u = r ? e.indexOf(r) : n;
            if (u < 0 && (u = 0), u >= t.length && (u = u.length - 1), !t[u].disabled) {
                if (f.selectedLabel = "", f.selectedItem = null, f.selectedElem = null, e.map(function(n, i) {
                    u == i ? (n.className = "TabBarCurrent", f.selectedLabel = t[i].getLabel ? t[i].getLabel() : t[i].label, f.selectedItem = t[i], f.selectedElem = n, t[i].selected = !0) : (n.className = "", delete t[i].selected)
                }), i && i(u), r) {
                    if (n.button == 2) {
                        f.showContextMenu(n);
                        return
                    }
                    f.dragTab(n, $target(n), u)
                }
                return !0
            }
        }
    }, this.handleClose = function() {
        r && r(f.selectedItem)
    }, this.showContextMenu = function(n) {
        var t = f.selectedItem,
            i = GetMousePosition(n);
        new PopupMenu(i[0], i[1], [{
            label: "Rename",
            icon: IMG_TAB_EDIT
        }].concat(r ? [null, {
            label: "Close",
            icon: IMG_CANCEL
        }] : []), function(n) {
            switch (n.label.toLowerCase()) {
                case "rename":
                    Confirm(RES.enter_tab_label, RES.rename_tab, t.getLabel ? t.getLabel() : t.label, function(n) {
                        n && t._set("getLabel", function() {
                            return n
                        })
                    });
                    break;
                case "close":
                    f.handleClose()
            }
        }, 90)
    }, this.selectIndex = function(n) {
        this.handleClick(n)
    }, t.attachEventListener("change", function(n, t) {
        t.type == "add" ? t.object.attachEventListener("change", e) : t.type == "remove" && t.objects[0].detachEventListener("change", e), e()
    }), this.destroy = function() {
        n.innerHTML = "", t.detachEventListener("change", e), t.map(function(n) {
            n.detachEventListener("change", e)
        }), Storage.dispose(f)
    }, t.map(function(n) {
        n.attachEventListener("change", e)
    }), e()
}

function Tree(n, t, i, r, u, f) {
    function v(n, t, i) {
        var r = __TreeItems[n][t],
            u = r.getIcon ? r.getIcon() : r.icon ? r.icon : null;
        return '<div class="treeItem roundTop roundBottom" style="' + (u ? "background-image:url(" + u + ");background-repeat:no-repeat;background-position:2px center;padding-left:20px;" : "") + (i !== undefined ? "margin-left:" + (r.children != null ? "-5" : "1") + 'px" id="' + e._("TreeLeaf") + "_" + t + '" onmousedown="' + e._var + ".handleMouseDown(event," + n + "," + t + ')" ' + (i ? ' ondblclick="' + i + '"' : "") : ';background-color:#dddddd"') + (r.tooltip ? ' title="' + r.tooltip.HTMLEntities() + '"' : "") + ">" + (r.getLabel ? r.getLabel() : r.label) + "<\/div>"
    }

    function y(n, t, i) {
        var u, p, c, a, k, b, w;
        if (t || (h.length = 0), !n.length) return t > 0 ? "" : f || "";
        for (u = [], p = 0; p < n.length; p++)(c = n[p], c._hidden) || (a = __TreeItems[o].length, h.push(c), __TreeItems[o][a] = c, k = p == n.length - 1, b = l ? s.contains(c) : t < r, u.push('<div id="' + e._("TreeNode") + "_" + a + '" style="border-left:1px solid ' + (i ? "#dddddd" : "transparent") + "; padding-left:" + (t > 0 ? "12px" : "0px; margin-left:-2px") + '">'), u.push('<div class="treeNode ' + (t == 0 && n.length == 1 ? "" : k ? "treeNodeLast" : "treeNodeMid") + '">'), w = "", c.children ? c.children.length ? (w = e._var + ".foldUnfold(__TreeItems[" + o + "][" + a + "])", u.push('<img id="' + e._("TreeImg") + "_" + a + '" src="images/gui/tree_' + (b ? "minus" : "plus") + '.gif" style="width:14px;height:25px;margin-left:8px" onmousedown="' + w + '" />')) : u.push('<img src="images/gui/tree_empty.gif" style="width:14px;height:25px;margin-left:8px" />') : (w = e._var + ".handleLeafDblClick(__TreeItems[" + o + "][" + a + "],event.shiftKey)", c.children == "" ? u.push('<img src="images/gui/tree_qmark.gif" style="width:14px;height:25px;margin-left:8px" />') : u.push('<img src="images/gui/tree_spacer.gif" style="width:14px;height:25px" />')), u.push(v(o, a, w) + "<\/div>"), c.children && (u.push('<div id="' + e._("TreeChild") + "_" + a + '"' + (b ? "" : ' style="display:none"') + ">"), u.push(y(c.children, t + 1, !k)), u.push("<\/div>")), u.push("<\/div>"), !l && b && s.push(c));
        return u.join("\n")
    }
    var e = Storage.store(this, "Tree"),
        o = e._id,
        s = [],
        h = [],
        l = !1,
        a = !1,
        c;
    return e.draggableObjTypes = [], e.dragEnabled = !1, e.dropCallback = null, e.selectedNode = null, e.selectedItem = null, e.handleMouseDown = function(n, t, i) {
        var r = __TreeItems[t][i],
            f = $target(n),
            u;
        n.button == 2 && r.getContextMenuItems && e.showContextMenu(f, r), e.selectLeaf(f, r), n.button == 0 && e.dragEnabled && r.objType && e.draggableObjTypes.contains(r.objType) && (a = !0, u = AddEvent(document, "mousemove", function() {
            if (RemoveEvent(u), a) {
                e.dragStartCallback && e.dragStartCallback();
                var r = GetMousePosition(n),
                    f = v(t, i);
                StartDragger(n, r[0] - 30, r[1] + 20, f, function(n) {
                    e.dropCallback && e.dropCallback(n)
                })
            }
        }, !0), AddEvent(document, "mouseup", function() {
            a = !1, RemoveEvent(u)
        }, !0))
    }, e.showContextMenu = function(n, t) {
        var i = GetOffset(n),
            r = i[0] + i[2] - 4,
            u = i[1] + i[3] - 4;
        new PopupMenu(r > e.elem.clientWidth ? e.elem.clientWidth : r, u, t.getContextMenuItems(), t.contextMenuHandler, 90)
    }, e.handleLeafDblClick = function(n, t) {
        var r = n.getContextMenuItems ? n.getContextMenuItems() : null,
            i;
        if (r)
            for (i = 0; i < r.length; i++)
                if (r[i] && r[i].auto) {
                    r[i].action ? r[i].action(r[i], t) : n.contextMenuHandler(r[i], t);
                    return
                }
    }, e.selectLeaf = function(n, t) {
        e.selectedNode && (e.selectedNode.className = "treeItem roundTop roundBottom"), n.className = "treeSelectedItem roundTop roundBottom", e.selectedNode = n, e.selectedItem = t, i && i(t)
    }, e.selectItem = function(n) {
        for (var i, t = 0; t < __TreeItems[o].length; t++)
            if (__TreeItems[o][t] == n) return i = $$(e._("TreeLeaf") + "_" + t), e.selectLeaf(i, n), e.scrollToElem(i), !0
    }, e.scrollToElem = function(n) {
        ScrollToView(n, e.$("Tree"), 5, 2)
    }, e.foldUnfold = function(t, i) {
        for (var r = -1, h = __TreeItems[o], c, u, f = 0; f < h.length; f++)
            if (h[f] == t) {
                r = f;
                break
            } if (r != -1 && h[r].children && h[r].children.length) {
            if (c = $$(e._("TreeChild") + "_" + r), u = c.style.display == "none", i == undefined) i = u;
            else if (u != i) return;
            u ? s.push(t) : delete s[s.indexOf(t)], c.style.display = u ? "" : "none", $$(e._("TreeImg") + "_" + r).src = "images/gui/tree_" + (u ? "minus" : "plus") + ".gif", ValidateLayout(n), u && e.scrollToElem($$(e._("TreeNode") + "_" + r))
        }
    }, e.handleKeyDown = function(n) {
        function f(n) {
            while (n.parent && h.contains(n.parent)) {
                if (!s.contains(n.parent)) return !1;
                n = n.parent
            }
            return !0
        }
        var i = e.selectedItem,
            u, r;
        if (n.keyCode >= 37 && n.keyCode <= 40 && !i && t && t.length) {
            e.selectItem(t[0]);
            return
        }
        if (i) switch (n.keyCode) {
            case 13:
                i.children && i.children.length ? e.foldUnfold(i) : e.handleLeafDblClick(i, n.shiftKey);
                break;
            case 38:
            case 40:
                for (u = n.keyCode - 39, r = h.indexOf(i);;) {
                    if (r += u, r < 0 || r > h.length - 1) return;
                    if (f(h[r])) break
                }
                e.selectItem(h[r]);
                break;
            case 37:
                s.contains(i) ? e.foldUnfold(i, !1) : i.parent && h.contains(i.parent) && e.selectItem(i.parent);
                break;
            case 39:
                i.children && i.children.length && (e.foldUnfold(i, !0), e.selectItem(i.children[0]))
        }
    }, e.refresh = function() {
        var u = e.elem.scrollTop,
            r, i;
        for (__TreeItems[o] = [], r = y(t, 0), e.elem.innerHTML = '<div style="height:5px"><\/div>' + r, e.elem.scrollTop = u, e.selectItem(e.selectedItem), i = 0; i < s.length; i++) __TreeItems[o].contains(s[i]) || (s.splice(i, 1), i--);
        c && c.updateSliders(), ValidateLayout(n)
    }, e.enableDrag = function(n, t, i) {
        e.dragEnabled = !0, e.draggableObjTypes = n, e.dragStartCallback = t, e.dropCallback = i
    }, e.disableDrag = function() {
        e.dragEnabled = !1, e.draggableObjTypes = e.dragStartCallback = e.dragStopCallback = null
    }, e.focus = function() {
        e.elem.focus()
    }, e.destroy = function() {
        c.destroy(), delete __TreeItems[o], Storage.dispose(e)
    }, u || (u = "0,0,0,0"), n.innerHTML = '<div id="' + e._("Tree") + '" tabindex="0" data-sticky="' + u + '" onkeydown="' + e._var + '.handleKeyDown(event)" class="tree focusable"><\/div>', e.elem = e.$("Tree"), e.refresh(), ValidateLayout(e.elem), l = !0, c = new AutoScrollBars(e.elem), e.focus(), e
}
var CONFIG_OPTS = {
        queryPageSize: 100,
        queryMaxCellSize: 4096,
        queryMaxDataSize: 10,
        queryMaxRows: 1e5,
        reqTimeout: 30,
        hideSysDBs: !1,
        showQueryRowNums: !0,
        binCellAction: 0,
        tableAction: 0,
        encrypt: !0,
        secureKey: ""
    },
    CONFIG_OPTS_HOST = ["cid", "label", "host", "port", "uname", "passwd", "keepAlive"],
    InputBox = {
        GetCaretPosition: function(n) {
            var t = 0,
                i;
            return document.selection ? (n.focus(), i = document.selection.createRange(), i.moveStart("character", -n.value.length), t = i.text.length) : (n.selectionStart || n.selectionStart == "0") && (t = n.selectionStart), t
        },
        SetCaretPosition: function(n, t) {
            if (n.setSelectionRange) n.focus(), n.setSelectionRange(t, t);
            else if (n.createTextRange) {
                var i = n.createTextRange();
                i.collapse(!0), i.moveEnd("character", t), i.moveStart("character", t), i.select()
            }
        },
        PasswdStrength: function(n) {
            var t = 0;
            return n.length > 5 && t++, n.length > 8 && t++, /[A-Z]/.test(n) && t++, /\d+/.test(n) && t++, /\W/i.test(n) && t++, t
        }
    },
    Storage = new function() {
        var t = [],
            n = [],
            i = 0;
        return this.store = function(r, u) {
            var f;
            return f = t.length ? t.shift() : i++, n[f] = r, r._id = f, u && (r._desc = u), r._var = "Storage.obj(" + f + ")", r._ = function(n) {
                return n + r._id
            }, r.$ = function(n) {
                return $$(r._(n))
            }, r._deathList = [], r._addToDeathList = function(n) {
                Array.isArray(n) || (n = [n]);
                for (var t = 0; t < n.length; t++) r._deathList.push(n[t])
            }, r
        }, this.obj = function(t) {
            return n[t]
        }, this.dump = function() {
            LOG("---------------", 1), LOG(n.map(function(n) {
                if (n) return n._id + ": " + n._desc
            }).join("\n"), 1), LOG("---------------", 1)
        }, this.dispose = function(i) {
            if (!n[i._id]) {
                alert("dispose error");
                return
            }
            while (i._deathList.length) {
                var r = i._deathList.shift();
                r.destroy()
            }
            delete n[i._id], t.push(i._id), delete i._id, delete i._var, delete i._deathList, delete i._addToDeathList, delete i._
        }, this
    },
    Cookies = {
        set: function(n, t, i) {
            var u = "",
                r;
            isNaN(i) || (r = new Date, r.setTime(r.getTime() + i * 6e4), u = "; expires=" + r.toGMTString()), document.cookie = n + "=" + escape(t) + u + "; path=/"
        },
        get: function(n, t) {
            var i = document.cookie.toString().match(new RegExp(n + "\\s*=\\s*(.*?)(;|$)")),
                r;
            return i ? (r = unescape(i[1]), t && Cookies.del(n), r) : null
        },
        del: function(n) {
            document.cookie = n + "=; path=/; expires=Thu, 01-Jan-1970 00:00:01 GMT"
        },
        test: function() {
            var n = "cookietest",
                t;
            return Cookies.set(n, "ok", 1), t = Cookies.get(n), Cookies.del(n), t
        }
    },
    __ResizeCallbacks = [],
    __EventCallbacks = [],
    __FillerQueryH1 = 62,
    HTTPComm = function() {
        function s() {
            var t = r.shift();
            t && n._send(t[0], t[1], t[2], t[3], t[4], t[5], t[6])
        }
        var n = this,
            e, t = new XMLHttpRequest,
            i = !1,
            r = [],
            u = !1,
            f;
        return n.encryptKey = "", n.decryptKey = "", n.defaultTimeout = 6e4, n.send = function(n, t, u, f, e, o, h) {
            r.push([n, t, u, f, e, o, h]), i || s()
        }, n._send = function(h, c, l, a, v, y, p) {
            function w(n) {
                i && (r.length = 0, i = !1, n = "" + n, a ? a(n) : alert(n))
            }
            u = !1, i = !0, v || (v = n.defaultTimeout), t.onreadystatechange = function() {
                var c, r, h;
                if (t.readyState == 4) {
                    clearTimeout(e), f && f.remove();
                    try {
                        c = t.status == 200
                    } catch (a) {}
                    if (c) {
                        if (r = t.responseText, r) {
                            r.substr(0, 2) == "!:" && (r = bytes2utf(rc4_arr(n.decryptKey || n.encryptKey, hex2bytes(r.substr(2)))), h = r.match(/^\!\:(\w+)\n/), h && (n.encryptKey = h[1], r = r.substr(h[0].length))), r.startWith("throw") || (r = "var o=" + r);
                            try {
                                eval(r)
                            } catch (a) {
                                w(a);
                                return
                            }
                        } else o = r;
                        i = !1, l(o)
                    } else w(u ? "timeout" : "term");
                    s()
                }
            }, t.open("POST", h, !0), t.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), e = setTimeout(function() {
                u = !0, t.abort()
            }, v), f = p ? null : ScreenBlock.block(), c = c ? typeof c == "object" ? JSON.stringify(c) : c : null, LOG(c), y && n.encryptKey && (c = "!:" + bytes2hex(rc4_arr(n.encryptKey, utf2bytes(c)))), t.send(c)
        }, this
    }(),
    WINDOWS = [],
    NAV, DBNINJAWS = "www.dbninja.com",
    __inIfr = !1,
    __queryLog = !1,
    RES, __dialogs, ScreenBlock, __MainPopup, __TreeItems;
window.onerror = function(n, t, i) {
    return n.indexOf("extension") == -1 && Alert('<div style="border-bottom:1px solid #adadad;padding-bottom:5px;margin-bottom:10px;font-weight:bold">Line ' + i + ", " + EscapeHtml(n) + "<\/div>Please note that this error may be caused by one of your browser's extensions. Try disabling the extensions and please " + MakeLink("let us know", [DBNINJAWS, "/?page=bug-report"], "_blank", !1) + " if this doesn't help.", "Oops"), !1
};
var QUERY_WITH_FIELD_DETAILS = 1,
    QUERY_WITH_INSERT_ID = 2,
    QUERY_WITH_HASHING = 4,
    QUERY_ONLY_FIELDS = 8,
    QUERY_CALC_FOUND_ROWS = 16,
    FIELD_FLAGS = {
        NOT_NULL: 1,
        PRI_KEY: 2,
        UNIQUE_KEY: 4,
        MULTIPLE_KEY: 8,
        BLOB: 16,
        UNSIGNED: 32,
        ZEROFILL: 64,
        BINARY: 128,
        ENUM: 256,
        AUTO_INCREMENT: 512,
        TIMESTAMP: 1024,
        SET: 2048,
        NUM: 32768,
        PART_KEY: 16384,
        GROUP: 32768,
        UNIQUE: 65536
    },
    ENGINES = {
        innodb: "A transaction-safe (ACID compliant) storage engine for MySQL that has commit, rollback, and crash-recovery capabilities to protect user data. InnoDB row-level locking (without escalation to coarser granularity locks) and Oracle-style consistent nonlocking reads increase multi-user concurrency and performance. InnoDB stores user data in clustered indexes to reduce I/O for common queries based on primary keys. To maintain data integrity, InnoDB also supports FOREIGN KEY referential-integrity constraints.",
        myisam: "These tables have a small footprint. Table-level locking limits the performance in read/write workloads, so it is often used in read-only or read-mostly workloads in Web and data warehousing configurations.",
        memory: "Stores all data in RAM, for fast access in environments that require quick lookups of non-critical data. This engine was formerly known as the HEAP engine. Its use cases are decreasing; InnoDB with its buffer pool memory area provides a general-purpose and durable way to keep most or all data in memory.",
        csv: "Its tables are really text files with comma-separated values. CSV tables let you import or dump data in CSV format, to exchange data with scripts and applications that read and write that same format. Because CSV tables are not indexed, you typically keep the data in InnoDB tables during normal operation, and only use CSV tables during the import or export stage.",
        archive: "These compact, unindexed tables are intended for storing and retrieving large amounts of seldom-referenced historical, archived, or security audit information.",
        blackhole: "The Blackhole storage engine accepts but does not store data, similar to the Unix /dev/null device. Queries always return an empty set. These tables can be used in replication configurations where DML statements are sent to slave servers, but the master server does not keep its own copy of the data.",
        merge: "Enables a MySQL DBA or developer to logically group a series of identical MyISAM tables and reference them as one object. Good for VLDB environments such as data warehousing.",
        federated: "Enables a MySQL DBA or developer to logically group a series of identical MyISAM tables and reference them as one object. Good for VLDB environments such as data warehousing."
    },
    ROW_FORMATS = [{
        label: "DEFAULT",
        tooltip: "Causes the column to use fixed-width or variable-width storage as determined by the column's data type."
    }, {
        label: "DYNAMIC",
        tooltip: "Allows the columns to be variable-width."
    }, {
        label: "FIXED",
        tooltip: "Allows the columns to be variable-width."
    }, {
        label: "COMPRESSED",
        tooltip: "Compressed storage format is a read-only format that is generated with the myisampack tool. Compressed tables can be uncompressed with myisamchk."
    }, {
        label: "COMPACT",
        tooltip: "Compressed storage format is a read-only format that is generated with the myisampack tool. Compressed tables can be uncompressed with myisamchk."
    }, {
        label: "REDUNDANT",
        tooltip: "The non-compact format used in older versions of MySQL with InnoDB engine."
    }],
    PACK_KEYS = [{
        label: "DEFAULT",
        tooltip: "The default is to pack strings, but not numbers."
    }, {
        label: "YES",
        tooltip: "Select this option if you want to have smaller indexes. This usually makes updates slower and reads faster."
    }, {
        label: "NO",
        tooltip: "Select this option to disable all packing of keys."
    }],
    INDEX_TYPES = [{
        label: "PRIMARY",
        tooltip: "Unique index where all key columns must be defined as NOT NULL."
    }, {
        label: "UNIQUE",
        tooltip: "Creates a constraint such that all values in the index must be destinct. This constraint does not apply to NULL values except for the BDB storage engine."
    }, {
        label: "NORMAL",
        tooltip: "Does not create any constraint."
    }, {
        label: "FULLTEXT",
        tooltip: "Supported only for MySAM tables and can include only CHAR, VARCHAR and TEXT collumns. Indexing always happens over the entire column. Column prefix indexing is not supported and any prefix length is ignored if specified."
    }],
    USING_TYPES = [{
        label: "DEFAULT"
    }, {
        label: "HASH"
    }, {
        label: "BTREE"
    }],
    DATA_TYPES = [{
        header: "INTEGER"
    }, {
        label: "TINYINT",
        tooltip: "Range of -128 to 127 or 0 to 255 unsigned"
    }, {
        label: "SMALLINT",
        tooltip: "Range of -32,768 to 32,767 or 0 to 65,535 unsigned"
    }, {
        label: "MEDIUMINT",
        tooltip: "Range of -8,388,608 to 8,388,607 or 0 to 16,777,215 unsigned"
    }, {
        label: "INT",
        tooltip: "Range of -2,147,483,648 to 2,147,483,647 or 0 to 4,294,967,295 unsigned"
    }, {
        label: "BIGINT",
        tooltip: "Range of -9,223,372,036,854,775,808 to 9,223,372,036,854,775,807 or 0 to 18,446,744,073,709,551,615 unsigned"
    }, {
        header: "REAL"
    }, {
        label: "FLOAT",
        tooltip: "A large number with a floating decimal point"
    }, {
        label: "DOUBLE",
        tooltip: "A DOUBLE stored as a string, allowing for a fixed decimal point"
    }, {
        label: "DECIMAL",
        tooltip: "A packed `exact` fixed-point number (65 bytes)"
    }, {
        header: "TEXT"
    }, {
        label: "CHAR",
        tooltip: "A fixed-length field from 0 to 255 characters long"
    }, {
        label: "VARCHAR",
        tooltip: "A variable-length field from 0 to 65,535 characters long (255 before v5.0.3)"
    }, {
        label: "TINYTEXT",
        tooltip: "A string with a maximum length of 255 characters"
    }, {
        label: "TEXT",
        tooltip: "A string with a maximum length of 65,535 characters"
    }, {
        label: "MEDIUMTEXT",
        tooltip: "A string with a maximum length of 16,777,215 characters"
    }, {
        label: "LONGTEXT",
        tooltip: "A string with a maximum length of 4,294,967,295 characters"
    }, {
        header: "BINARY"
    }, {
        label: "BINARY",
        tooltip: "Similar to CHAR, except that it can contain binary strings rather than non-binary strings"
    }, {
        label: "VARBINARY",
        tooltip: "Similar to VARCHAR, except that it can contain binary strings rather than non-binary strings"
    }, {
        label: "TINYBLOB",
        tooltip: "Binary object that can hold a variable amount of data. Maximum length 255 bytes"
    }, {
        label: "BLOB",
        tooltip: "Binary object that can hold a variable amount of data. Maximum length 65,536 bytes"
    }, {
        label: "MEDIUMBLOB",
        tooltip: "Binary object that can hold a variable amount of data. Maximum length 16,777,216 bytes"
    }, {
        label: "LONGBLOB",
        tooltip: "Binary object that can hold a variable amount of data. Maximum length 4,294,967,296 bytes"
    }, {
        header: "TEMPORAL"
    }, {
        label: "DATE",
        tooltip: "In the format of YYYY-MM-DD (3 bytes)"
    }, {
        label: "TIME",
        tooltip: "In the format of HH:MM:SS (3 bytes)"
    }, {
        label: "YEAR",
        tooltip: "In the format of YYYY (1 byte)"
    }, {
        label: "DATETIME",
        tooltip: "In the format of YYYY-MM-DD HH:MM:SS (8 bytes)"
    }, {
        label: "TIMESTAMP",
        tooltip: "In the format of YYYYMMDDHHMMSS; acceptable range ends in the year 2037 (4 bytes)"
    }, {
        header: "OTHER (Nonstandard)"
    }, {
        label: "BIT",
        tooltip: "Storing bit-field values"
    }, {
        label: "SET",
        tooltip: "Like ENUM except that each column can have more than one of several possible values"
    }, {
        label: "ENUM",
        tooltip: "Short for enumeration, which means that each column can have one of several possible values"
    }, {
        header: "GEOMETRY"
    }, {
        label: "POINT",
        tooltip: ""
    }, {
        label: "LINESTRING",
        tooltip: ""
    }, {
        label: "POLYGON",
        tooltip: ""
    }, {
        label: "GEOMETRY",
        tooltip: ""
    }, {
        label: "MULTIPOINT",
        tooltip: ""
    }, {
        label: "MULTLINESTRING",
        tooltip: ""
    }, {
        label: "MULTIPOLYGON",
        tooltip: ""
    }, {
        label: "GEOMETRYCOLLECTION",
        tooltip: ""
    }];
String.prototype.trim = function() {
    return this.replace(/^\s+|\s+$/g, "")
}, String.prototype.startWith = function(n) {
    var t = this.replace(/^\\s+/, "");
    return t.substr(0, n.length).toLowerCase() == n.toLowerCase()
}, String.prototype.capitalize = function() {
    return this.replace(/([a-z]+)/ig, function(n) {
        return n.substr(0, 1).toUpperCase() + n.substr(1).toLowerCase()
    })
}, String.prototype.SQLEscape = function() {
    return this.replace(/\\/g, "\\\\").replace(/'/g, "''").replace(/\0/g, "\\0").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\t/g, "\\t")
}, String.prototype.HTMLEntities = function() {
    return this.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;")
}, String.prototype.CRLF = function() {
    return this.replace(/\x0A/g, "&#x21b2;").replace(/\x0D/g, "&#x21a9;")
}, String.prototype.repeat = function(n) {
    var t = [];
    return t.length = n + 1, t.join(this)
}, String.random = function(n) {
    for (var t = [], i = 0; i < n; i++) t.push(String.fromCharCode(Math.floor(Math.random() * 26 + 97)));
    return t.join("")
}, String.prototype.split2 = function(n, t) {
    for (var i = this.split(n, t), u = 0, r = 0; r < i.length; r++) u += i[r].length + n.length;
    return u < this.length && (i[i.length - 1] += this.substr(u - 1)), i
}, String.prototype.addslashes = function() {
    return this.replace(/\\/g, "\\\\").replace(/\x00/g, "\\0").replace(/\x1a/g, "\\x1a").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/'/g, "\\'").replace(/"/g, '\\"')
}, Number.prototype.pad = function(n, t, i) {
    for (var r = [], u = this + "", f = 0; f < t - u.length; f++) r.push(n);
    return i ? u + r.join("") : r.join("") + u
}, Date.prototype.toMySQL = function() {
    return this.getFullYear() + "-" + (this.getMonth() + 1).pad("0", 2) + "-" + this.getDate().pad("0", 2) + " " + this.getHours().pad("0", 2) + ":" + this.getMinutes().pad("0", 2) + ":" + this.getSeconds().pad("0", 2)
}, Object.prototype._set = function(n, t) {
    var i = this[n];
    if (i !== t) return this[n] = t, this.dispatchEvent("change", {
        type: "set",
        target: this,
        property: n,
        value: t,
        oldValue: i
    }), t
}, Object.prototype._delete = function(n) {
    delete this[n], this.dispatchEvent("change", {
        type: "delete",
        target: this,
        property: n
    })
}, Object.prototype.copyTo = function(n, t) {
    var i;
    if (t)
        for (i = 0; i < t.length; i++) n[t[i]] = this[t[i]];
    else
        for (i in this) this.hasOwnProperty(i) && (n[i] = this[i])
}, Object.prototype.getKeys = function(n) {
    var t = [],
        i;
    for (i in this) this.hasOwnProperty(i) && t.push(i);
    return n && t.sort(), t
}, Object.prototype.attachEventListener = attachEventListener, Object.prototype.detachEventListener = detachEventListener, Object.prototype.detachAllEventListeners = detachAllEventListeners, Object.prototype.dispatchEvent = dispatchEvent, Object.prototype.clone = function(n) {
    var i = {},
        t;
    if (n)
        for (t = 0; t < n.length; t++) i[n[t]] = this[n[t]];
    else
        for (t in this) this.hasOwnProperty(t) && (i[t] = this[t]);
    return i
}, Object.prototype.watchChanges = function(n) {
    this._changedProperties || (this._changedCallback = n, this._changedProperties = [], this._changed = !1, this.attachEventListener("change", __changeWatchHandler))
}, Object.prototype.unwatchChanges = function() {
    this.detachEventListener("change", __changeWatchHandler), delete this._changedCallback, delete this._changed, delete this._changedProperties
}, Object.prototype.confirmChanges = function() {
    this._changedProperties = [], this._changed = !1
}, Object.prototype.undoChanges = function() {
    var t = this._changedProperties,
        n;
    if (t) {
        for (n = 0; n < t.length; n++) this[t[n][0]] = t[n][1];
        this.confirmChanges()
    }
}, Object.prototype.propChanged = function(n) {
    for (var i = this._changedProperties, t = 0; t < i.length; t++)
        if (i[t][0] == n) return !0;
    return !1
}, Object.prototype.pauseWatchChanges = function() {
    this.detachEventListener("change", __changeWatchHandler)
}, Object.prototype.resumeWatchChanges = function() {
    this.attachEventListener("change", __changeWatchHandler)
}, Object.prototype.prevValue = function(n) {
    for (var i = this._changedProperties, t = 0; t < i.length; t++)
        if (i[t][0] == n) return i[t][1];
    return this[n]
}, Array.prototype.attachEventListener = attachEventListener, Array.prototype.detachEventListener = detachEventListener, Array.prototype.detachAllEventListeners = detachAllEventListeners, Array.prototype.dispatchEvent = dispatchEvent, Array.prototype.indexOf = function(n, t, i) {
    var u, r;
    if (t || (t = 0), u = this.length, typeof n != "string" || i) {
        for (r = t; r < u; r++)
            if (this[r] == n) return r
    } else
        for (n = ("" + n).toLowerCase(), r = t; r < u; r++)
            if (("" + this[r]).toLowerCase() == n) return r;
    return -1
}, Array.prototype.push2 = function(n) {
    n !== null && n !== undefined && n !== "" && this.push(n)
}, Array.prototype.contains = function(n) {
    return this.indexOf(n) > -1
}, Array.prototype.map = function(n, t) {
    var u, i, r;
    if (t) {
        for (i = 0; i < this.length; i++)
            if (r = n(this[i], i), r !== undefined) return r;
        return
    }
    for (u = [], i = 0; i < this.length; i++) r = n(this[i], i), r !== undefined && u.push(r);
    return u
}, Array.prototype.getLength = function() {
    for (var n = 0; this[n] !== undefined;) n++;
    return n
}, Array.prototype.removeAll = function(n) {
    var i = 0,
        t;
    do {
        if (t = this.indexOf(n), t == -1) return i;
        this.splice(t, 1), i++
    } while (1)
}, Array.prototype.clone = function(n) {
    for (var i = [], t = 0; t < this.length; t++) i.push(this[t].clone(n));
    return i
}, Array.prototype.findByProp = function(n, t, i) {
    var r;
    if (i || typeof t != "string") {
        for (r = 0; r < this.length; r++)
            if (this[r][n] == t) return r
    } else
        for (t = t.toLowerCase(), r = 0; r < this.length; r++)
            if (this[r][n].toLowerCase() == t) return r;
    return -1
}, Array.prototype.sortProp = function(n) {
    this.sort(function(t, i) {
        return t = t[n], i = i[n], t < i ? -1 : t > i ? 1 : 0
    })
}, Array.prototype._push = function(n) {
    this.push(n), this.dispatchEvent("change", {
        type: "add",
        target: this,
        object: n,
        index: this.length - 1
    })
}, Array.prototype._extend = function(n) {
    for (var t = 0; t < n.length; t++) this.push(n[t]);
    this.dispatchEvent("change", {
        type: "add",
        target: this,
        objects: n
    })
}, Array.prototype._splice = function(n, t) {
    var i = this.splice(n, t);
    return this.dispatchEvent("change", {
        type: "remove",
        target: this,
        objects: i,
        index: n,
        length: t
    }), i
}, Array.prototype._clear = function() {
    this._splice(0, this.length)
}, Array.prototype._remove = function(n) {
    for (var t = 0; t < this.length; t++)
        if (this[t] == n) return this._splice(t, 1), n
}, RES = {
    loading: "Working...",
    warn_file_post_size: "Selected file exceeds the 'upload_max_filesize' or 'post_max_size' directive in php.ini file",
    enter_script_name: "Please enter a name for this script",
    select_a_database: "Select a Database",
    sort_unavailable: "Sort is unavailable while record is being edited",
    data_copied_to_clipboard: "Data has been copied to clipboard",
    rename_tab: "Rename Tab",
    enter_tab_label: "Enter a new label for this tab",
    copy_contents: "Press " + (navigator.userAgent.indexOf("Mac OS") == -1 ? "CTRL" : "Command") + "-C to copy the contents",
    save_changes: "Save changes before close?",
    discard_changes: "Discard changes and close?",
    chosen_weak_password: "You have chosen a weak password. Do you want to continue?",
    object_code_unavailable: "Object code is unavailable. Make sure you have the appropriate permissions.",
    request_timeout: "The request has timed out. You can change the timeout period in Settings.",
    request_failed: "Request to the server has failed.",
    upload_sql_script: "Upload SQL Script",
    script_run_warn: "Warning: running scripts can cause significant damage to your database!",
    script_name: "Script Name",
    export_to_script: "Export to Script",
    export_data: "Export Data",
    import_data: "Import Data",
    window_unload_message: "",
    obj_doesnt_exist: "Object does not exist in the database",
    copy_to_clipboard: "Copy to Clipboard",
    completed_successfully: "Operation completed successfully",
    duplicate_enter_new_name: "Enter a name for the new object",
    rename_enter_new_name: "Enter a new name for the object",
    constraint_unique_name: "Note: Every constraint must have a unique name in the database!",
    foreign_keys_no_support: "Foreign keys are supported only by InnoDB engine",
    user_select_denied: "Current MySQL user does not have user management privileges."
}, __dialogs = [], ScreenBlock = function() {
    var n = this,
        r, i, t = [],
        u = 0;
    return n.isBlocking = !1, n.block = function(f, e, o) {
        var f = f === undefined ? RES.loading : f,
            s = CreateElem("div");
        return t.push(s), s.tabIndex = 0, s.style.zIndex = 1e3 + u++, s.className = "screenBlock " + (e ? " screenBlockVisible" : ""), o && (s.style.cursor = o), s.setAttribute("data-sticky", "0,0,0,0"), f && (s.innerHTML = '<div class="roundTop roundBottom screenBlockTitle">' + f + "<\/div>"), i = document.activeElement, ValidateLayout(s), s.focus(), n.isBlocking || (r = setInterval(function() {
            var t, n;
            if (!__dialogs.length) {
                document.body.focus();
                return
            }
            t = __dialogs[__dialogs.length - 1], DiveToElem(document.activeElement, t.elem) || (n = t.elem.getElementsByTagName("input"), n.length || (n = t.elem.getElementsByTagName("button")), n.length && n[0].focus())
        }, 50), n.isBlocking = !0), {
            zIndex: parseInt(s.style.zIndex),
            remove: function() {
                var f = t.indexOf(s);
                f != -1 && (t.splice(f, 1), t.length || (clearInterval(r), n.isBlocking = !1, u = 0), RemoveNode(s), i && i.focus())
            }
        }
    }, n
}(), __MainPopup = null;
var __ScrollSize = 16,
    __ScrollButtSize = 16,
    __ScrollMinSize = 3,
    __ScrollStep = 35,
    __ScrollInterval = 100,
    WHEEL_EVENT = /Firefox/i.test(navigator.userAgent) ? "DOMMouseScroll" : "mousewheel";
__TreeItems = []